<?php

namespace App\Http\Controllers;

use App\Models\Assignment;
use App\Models\Business_location;
use App\Models\Question;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AssignmentController extends Controller
{
    // Show list of Assignments in descenting according to ID with pagination
    public function list(){
        $assignments = Assignment::orderBy('id', 'desc')
        // ->paginate(1);
        ->get();
        return view('assignments.list' , [
            'assignments' => $assignments
        ]);
    }
    
    // View specific Assignment
    public function view($id){
        
        $assignment =Assignment::find($id);
        
        return view('assignments.view' , [
            'assignment' => $assignment
        ]);
    }
    
    // Search in Assignments
    public function search($word){
        
        $assignments =Assignment::where('assignment_title', 'like' , '%'.$word.'%')
        // ->paginate(25);
        ->get();
        return view('assignments.search' , [
            'assignments' => $assignments
        ]);
    }
    
    // Create Assignment
    public function create(){
        // Get Business Locations data
        $business_locations = Business_location::select('id' , 'business_name')->get();
        $questions = Question::orderBy('id', 'desc')
        ->get();
        // $questions = Question::where('business_id' , '=' , 1)
        // ->orderBy('id', 'desc')
        // ->get();

        // dd($questions);

        return view('assignments.create' , [
            'business_locations' => $business_locations,
            'questions' => $questions
        ]);
    }

    // Store data to Assignment table at DB
    public function store(Request $request){

        // dd($request);
        // Make validation on entered data 
        $request->validate([
            'assignment_title'=>'required|string',
            'assignment_title_ar'=>'required|string',
            'assignment_note'=>'nullable|string', 
            'assignment_note_ar'=>'nullable|string', 
            'assignment_instructions'=>'nullable|string', 
            'assignment_instructions_ar'=>'nullable|string', 
            'assignment_shortname'=>'required|string',
            'assignment_structure'=>'required|string',          
            'assignment_questions'=>'required|string',          
            'assignment_condition'=>'nullable|string',          

        ]);

        $assignment_title = $request->assignment_title;
        $assignment_title_ar = $request->assignment_title_ar;
        $assignment_note = $request->assignment_note;
        $assignment_note_ar = $request->assignment_note_ar;
        $assignment_instructions = $request->assignment_instructions;
        $assignment_instructions_ar = $request->assignment_instructions_ar;
        $assignment_structure = $request->assignment_structure;
        $assignment_questions = $request->assignment_questions;
        $assignment_condition = $request->assignment_condition;
        $assignment_shortname = $request->assignment_shortname;
        $created_by = Auth::user()->id;
        // $business_id = 1;
        
        // Insert data into Assignments table in DB
        Assignment::create([
            'assignment_title' => $assignment_title,
            'assignment_title_ar' => $assignment_title_ar,
            'assignment_note' => $assignment_note,
            'assignment_note_ar' => $assignment_note_ar,
            'assignment_instructions' => $assignment_instructions,
            'assignment_instructions_ar' => $assignment_instructions_ar,
            'assignment_structure' => $assignment_structure,
            'assignment_questions' => $assignment_questions,
            'assignment_condition' => $assignment_condition,
            'assignment_shortname' => $assignment_shortname,
            // 'business_id' => $business_id,
            'created_by' => $created_by,
            // 'logo' => $logo,

        ]);

        return redirect( route('allAssignments') )->with('message',"New Assignment has been created");
        
    }

    // Edit specifi Assignment Data
    // get this specific Assignment data and return it at the form
    public function edit($id){
        $assignment =Assignment::find($id);
        $business_locations = Business_location::select('id' , 'business_name')->get();
        $questions = Question::orderBy('id', 'desc')
        ->get();
        // $questions = Question::where('business_id' , '=' , 1)
        // ->orderBy('id', 'desc')
        // ->get();

        // dd( $assignment);
        // $authors = Author::select('id' , 'name')->get();
        // dd($business_locations);
        return view('assignments.edit', [
            'business_locations' => $business_locations,
            'assignment' => $assignment,
            'questions' => $questions,
            // 'assignment_condition'=>$assignment->assignment_condition
        ]);
    }
    
    public function update(Request $request , $id){
        
        $request->validate([
            'assignment_title'=>'required|string',
            'assignment_title_ar'=>'required|string',
            'assignment_note'=>'nullable|string', 
            'assignment_note_ar'=>'nullable|string', 
            'assignment_instructions'=>'nullable|string', 
            'assignment_instructions_ar'=>'nullable|string', 
            'assignment_structure'=>'required|string',          
            'assignment_questions'=>'required|string',          
            'assignment_condition'=>'nullable|string',  
            // 'business_id'=>'required|exists:business_locations,id',
        ]);
      
        $assignment = Assignment::find($id);

/*
        if ($request->hasFile('logo')) {
            
            if ( $business_location->logo !== null) {
                $old_image = $business_location->logo;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->logo ;
            $ext = $image->getClientOriginalExtension();
            $newImageName = "business_location-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $imageName = $newImageName;
        }
        else
        {
            $imageName = $business_location->logo;
        }
*/
        $assignment_title = $request->assignment_title;
        $assignment_title_ar = $request->assignment_title_ar;
        $assignment_note = $request->assignment_note;
        $assignment_note_ar = $request->assignment_note_ar;
        $assignment_instructions = $request->assignment_instructions;
        $assignment_instructions_ar = $request->assignment_instructions_ar;
        $assignment_structure = $request->assignment_structure;
        $assignment_questions = $request->assignment_questions;
        $assignment_condition = $request->assignment_condition;
        // $created_by = 1;
        // $business_id = $request->business_id;
        // $business_id = 1;
        // $logo = $imageName;

        $assignment->update([
            'assignment_title' => $assignment_title,
            'assignment_title_ar' => $assignment_title_ar,
            'assignment_note' => $assignment_note,
            'assignment_note_ar' => $assignment_note_ar,
            'assignment_instructions' => $assignment_instructions,
            'assignment_instructions_ar' => $assignment_instructions_ar,
            'assignment_structure' => $assignment_structure,
            'assignment_questions' => $assignment_questions,
            'assignment_condition' => $assignment_condition,
            // 'business_id' => $business_id,
            // 'created_by' => $created_by,
            // 'logo' => $logo,
        ]);

        return redirect( route('allAssignments') )->with('message',"Assignment data has been updated succesffuly");
    }


    public function delete($id){
        $deleted_by = Auth::user()->id;
        $assignment = Assignment::find($id);
        $assignment -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $assignment -> delete();


        return redirect( route('allAssignments') )->with('message',"Assignment data has been deleted succesffuly");
    }

}
