<?php

namespace App\Http\Controllers;

use App\Models\Business_location;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class AuthController extends Controller
{
    public function login(){

        return view('auth.login');
    }

    public function doLogin(Request $request){
        
        
        $request->validate([
            'user_name'=>'required|string',
            'password'=>'required|string|min:6'
        ]);
        
        $user_name = $request->user_name;
        $password = $request->password;
        
        if( ! Auth::attempt(['user_name' => $user_name, 'password' => $password]) )
        {
            return redirect( route('authLogin') )->with('message',"Not correct username or password, please try again");
        }
        else
        {
            if( Auth::user()->is_active == "Active" )
            {
                return redirect( route('dashboardIndex') );
            }
            else
            {
                return redirect( route('authLogin') )->with('message',"Your account is deactivated and not allowable to login, please contact the adminstration");
            }
        }
        
    }

    public function register(){

        return view('auth.register');
    }

    public function doRegister(Request $request){
        
        // dd($request);

        // Make validation on entered data 
        $request->validate([
            'user_name'=>'required|string|unique:users,user_name',
            'full_name'=>'required|string',
            'password'=>'required|string|min:6',
            'email'=>'required|string|email|unique:users,email',
            'phone'=>'nullable|integer',
            'alternative_phone'=>'nullable|integer',
            'contact_number'=>'nullable|integer',
            'language'=>'nullable|string',
            'nationality'=>'nullable|string',
            'national_number'=>'nullable|string',
            'dob'=>'nullable|date',
            'image'=>'nullable|image|mimes:jpg,jpeg,png',
            'gender'=>'nullable|string',
            'marital_status'=>'nullable|string',
            'blood_group'=>'nullable|string',
            'fb_link'=>'nullable|url',
            'twitter_link'=>'nullable|url',
            'social_media_1'=>'nullable|url',
            'social_media_2'=>'nullable|url',
            'is_active'=>'required|string',
            'allow_login'=>'required|string',

            // Business Location Data
            'business_name'=>'required|string',
            'business_email'=>'required|string|email|unique:business_locations,email',
            'business_address'=>'nullable|string',
            'business_phone'=>'nullable|string',
            'business_alternative_phone'=>'nullable|string',
            'business_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'business_is_active'=>'required|string',
            'technical_supervisor'=>'required|string',

        ]);
        
        // Check if user upload image or no 
        if ($request->hasFile('image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->image ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "user-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        // Check if user upload image or no 
        if ($request->hasFile('business_image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->business_image ;
            $ext = $img->getClientOriginalExtension();
            $businessImageName = "business_location-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $businessImageName);

        } else {
            // If user doesn't upload image
            $businessImageName = null;
        }

        $user_name = $request->user_name;
        $full_name = $request->full_name;
        $email = $request->email;
        $password = $request->password;
        $phone = $request->phone;
        $alternative_phone = $request->alternative_phone;
        $contact_number = $request->contact_number;
        $language = $request->language;
        $nationality = $request->nationality;
        $national_number = $request->national_number;
        $marital_status = $request->marital_status;
        $image = $imageName;
        $dob = $request->dob;
        $gender = $request->gender;
        $blood_group = $request->blood_group;
        $fb_link = $request->fb_link;
        $twitter_link = $request->twitter_link;
        $social_media_1 = $request->social_media_1;
        $social_media_2 = $request->social_media_2;
        $allow_login = $request->allow_login;
        $is_active = $request->is_active;
        $role = "admin";

        // Business Location Data
        $business_name = $request->business_name;
        $business_email = $request->business_email;
        $business_address = $request->business_address;
        $business_phone = $request->business_phone;
        $business_alternative_phone = $request->business_alternative_phone;
        $business_image = $businessImageName;
        $is_active = $request->business_is_active;
        $technical_supervisor = $request->technical_supervisor;
        
        
        
        // Insert data into Users table in DB
        $new_user = User::create([
            'user_name' => $user_name,
            'full_name' => $full_name,
            'email' => $email,
            'password' => Hash::make($password),
            'phone' => $phone,
            'alternative_phone' => $alternative_phone,
            'contact_number' => $contact_number,
            'language' => $language,
            'nationality' => $nationality,
            'national_number' => $national_number,
            'marital_status' => $marital_status,
            'dob' => $dob,
            'gender' => $gender,
            'blood_group' => $blood_group,
            'fb_link' => $fb_link,
            'twitter_link' => $twitter_link,
            'social_media_1' => $social_media_1,
            'social_media_2' => $social_media_2,
            'image' => $image,
            'allow_login' => $allow_login,
            'is_active' => $is_active,
            'role' => $role,
            
        ]);

        $owner_id = $new_user->id;
        $created_by = $new_user->id;
        
        // Insert data into Business Location table in DB
        $new_business_location = Business_location::create([
            'business_name' => $business_name,
            'email' => $business_email,
            'address' => $business_address,
            'phone' => $business_phone,
            'alternative_phone' => $business_alternative_phone,
            'image' => $business_image,
            'is_active' => $is_active,
            'technical_supervisor' => $technical_supervisor,
            'owner_id' => $owner_id,
            'created_by' => $created_by,
        ]);

        $user =User::find($new_user->id);
        $user->update([
            'business_id' => $new_business_location->id
        ]);

        return redirect( route('dashboardIndex') )->with('message',"New business location request has been sent");
        
    }
    
    
    public function logout(){
        Auth::logout();
        
        return redirect( route('authLogin') );
    }
    
    public function notAuth(){
        
        return view('auth.403');
    }
}
