<?php

namespace App\Http\Controllers;

use App\Models\Business_location;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class BusinessLocationController extends Controller
{
    
    public function list(){
        
        // Show list of Business Locations in descenting according to ID with pagination
        if (Auth::user()->role != 'super_admin') {
            $business_locations = Business_location::select('id' , 'business_name' , 'email' , 'phone' , 'alternative_phone' , 'image' , 'address' , 'owner_id' , 'created_by', 'is_active')
            ->where('id' , Auth::user()->business_id )
            ->orderBy('id', 'desc')
            ->get();
        }
        else
        {
            $business_locations = Business_location::select('id' , 'business_name' , 'email' , 'phone' , 'alternative_phone' , 'image' , 'address' , 'owner_id' , 'created_by', 'is_active')
            ->orderBy('id', 'desc')
            ->get();
        }

        return view('business-locations.list' , [
            'business_locations' => $business_locations
        ]);
    }
    
    // View specific Business Location
    public function view($id){

        if((Auth::user()->role == 'super_admin') || (Auth::user()->role == 'owner' && $id == Auth::user()->business_id)) {
            $business_location =Business_location::find($id);
            
            return view('business-locations.view' , [
                'business_location' => $business_location
            ]); 
        } else {
            return redirect( route('notAuth') );
        }
    }
    
    // Search in Business Locations
    // public function search($word){
        
    //     $business_locations =Business_location::where('business_name', 'like' , '%'.$word.'%')
    //     // ->paginate(25);
    //     ->get();
    //     return view('business-locations.search' , [
    //         'business_locations' => $business_locations
    //     ]);
    // }
    
    // Create Business Location
    public function create(){
        // Get Users data
        $users = User::select('id' , 'full_name')->get();

        return view('business-locations.create' , [
            'users' => $users
        ]);
        // return view('business-locations.create');
    }

    // Store data to Business Location table at DB
    public function store(Request $request){

        // Make validation on entered data 
        $request->validate([
            // Business Location Info
            'business_name'=>'required|string',
            'email'=>'required|string|email|unique:business_locations,email',
            'address'=>'nullable|string',
            'phone'=>'nullable|string',
            'alternative_phone'=>'nullable|string',
            'image'=>'nullable|image|mimes:jpg,jpeg,png',
            'license_start_date'=>'required|date',
            'license_end_date'=>'required|date',
            'max_students'=>'required|integer',
            'max_assignments'=>'required|integer',
            'max_submissions'=>'required|integer',
            'max_admins'=>'required|integer',
            'max_trainers'=>'required|integer',
            'is_active'=>'required|string',
            'technical_supervisor'=>'required|string',
            'theme_color'=>'required|string',

            // Owner Info
            'owner_user_name'=>'required|string|unique:users,user_name',
            'owner_full_name'=>'required|string',
            'owner_password'=>'required|string',
            'owner_email'=>'required|string|email|unique:users,email',
            'owner_address'=>'nullable|string',
            'owner_city'=>'nullable|string',
            'owner_state'=>'nullable|string',
            'owner_country'=>'nullable|string',
            'owner_landmark'=>'nullable|string',
            'owner_phone'=>'nullable|integer',
            'owner_alternative_phone'=>'nullable|integer',
            'owner_contact_number'=>'nullable|integer',
            'owner_language'=>'nullable|string',
            'owner_nationality'=>'nullable|string',
            'owner_national_number'=>'nullable|string',
            'owner_dob'=>'nullable|date',
            'owner_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'owner_gender'=>'nullable|string',
            'owner_marital_status'=>'nullable|string',
            'owner_blood_group'=>'nullable|string',
            'owner_fb_link'=>'nullable|url',
            'owner_twitter_link'=>'nullable|url',
            'owner_social_media_1'=>'nullable|url',
            'owner_social_media_2'=>'nullable|url',
            'owner_is_active'=>'required|string',
            
        ]);
        
        // Check if user upload image or no 
        if ($request->hasFile('image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->image ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "business_location-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        // Check if user upload image or no 
        if ($request->hasFile('owner_image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->owner_image ;
            $ext = $img->getClientOriginalExtension();
            $owner_imageName = "user-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $owner_imageName = null;
        }

        // Business Location Info
        $business_name = $request->business_name;
        $email = $request->email;
        $address = $request->address;
        $phone = $request->phone;
        $alternative_phone = $request->alternative_phone;
        $image = $imageName;
        $is_active = $request->is_active;
        $license_start_date = $request->license_start_date;
        $license_end_date = $request->license_end_date;
        $max_students = $request->max_students;
        $max_assignments = $request->max_assignments;
        $max_submissions = $request->max_submissions;
        $max_admins = $request->max_admins;
        $max_trainers = $request->max_trainers;
        $technical_supervisor = $request->technical_supervisor;
        $theme_color = $request->theme_color;
        // $owner_id = $request->owner_id;
        $created_by = Auth::user()->id;

        // Owner Info
        $owner_user_name = $request->owner_user_name;
        $owner_full_name = $request->owner_full_name;
        $owner_email = $request->owner_email;
        $owner_password = $request->owner_password;
        $owner_address = $request->owner_address;
        $owner_city = $request->owner_city;
        $owner_state = $request->owner_state;
        $owner_country = $request->owner_country;
        $owner_landmark = $request->owner_landmark;
        $owner_phone = $request->owner_phone;
        $owner_alternative_phone = $request->owner_alternative_phone;
        $owner_language = $request->owner_language;
        $owner_nationality = $request->owner_nationality;
        $owner_national_number = $request->owner_national_number;
        $owner_marital_status = $request->owner_marital_status;
        $owner_image = $owner_imageName;
        $owner_dob = $request->owner_dob;
        $owner_gender = $request->owner_gender;
        $owner_blood_group = $request->owner_blood_group;
        $owner_contact_number = $request->owner_contact_number;
        $owner_fb_link = $request->owner_fb_link;
        $owner_twitter_link = $request->owner_twitter_link;
        $owner_social_media_1 = $request->owner_social_media_1;
        $owner_social_media_2 = $request->owner_social_media_2;
        $owner_is_active = $request->owner_is_active;
        

        
        // Insert data into Business Location table in DB
        $new_business_location = Business_location::create([
            'business_name' => $business_name,
            'email' => $email,
            'address' => $address,
            'phone' => $phone,
            'alternative_phone' => $alternative_phone,
            'image' => $image,
            'is_active' => $is_active,
            'license_start_date' => $license_start_date,
            'license_end_date' => $license_end_date,
            'max_students' => $max_students,
            'max_assignments' => $max_assignments,
            'max_submissions' => $max_submissions,
            'max_admins' => $max_admins,
            'max_trainers' => $max_trainers,
            'technical_supervisor' => $technical_supervisor,
            'theme_color' => $theme_color,
            'created_by' => $created_by,
        ]);

        $business_id = $new_business_location->id;

        // Insert data into Users table in DB
        $new_owner = User::create([
                'user_name' => $owner_user_name,
                'full_name' => $owner_full_name,
                'email' => $owner_email,
                'password' => Hash::make($owner_password),
                'address' => $owner_address,
                'city' => $owner_city,
                'state' => $owner_state,
                'country' => $owner_country,
                'landmark' => $owner_landmark,
                'phone' => $owner_phone,
                'alternative_phone' => $owner_alternative_phone,
                'language' => $owner_language,
                'nationality' => $owner_nationality,
                'national_number' => $owner_national_number,
                'marital_status' => $owner_marital_status,
                'dob' => $owner_dob,
                'gender' => $owner_gender,
                'blood_group' => $owner_blood_group,
                'contact_number' => $owner_contact_number,
                'image' => $owner_image,
                'fb_link' => $owner_fb_link,
                'twitter_link' => $owner_twitter_link,
                'social_media_1' => $owner_social_media_1,
                'social_media_2' => $owner_social_media_2,
                'is_active' => $owner_is_active,
                'business_id' => $business_id,
                'role' => "owner",
                'created_by' => $created_by
            ]);

        $created_business_location = Business_location::find($business_id);

        $created_business_location->update([
            'owner_id' => $new_owner->id,
        ]);

        return redirect( route('allBusinessLocations') )->with('message',"New Business Location has been created");
        
    }

    // Edit specifi Business Location Data
    // get this specific Business Location data and return it at the form
    public function edit($id){
        $business_location =Business_location::find($id);
        // $users = User::select('id' , 'full_name')->get();
        // $authors = Author::select('id' , 'name')->get();
        // dd($book);
        return view('business-locations.edit', [
            'business_location' => $business_location,
            // 'users' => $users,
        ]);
    }
    
    public function update(Request $request , $id){

        
        
        $business_location = Business_location::find($id);
        $owner = User::find($business_location->owner_id);
        $request->validate([
            // Business Location Info
            'business_name'=>'required|string',
            'email'=>'required|string|email|unique:business_locations,email,'.$business_location->id,
            'address'=>'nullable|string',
            'phone'=>'nullable|string',
            'alternative_phone'=>'nullable|string',
            'image'=>'nullable|image|mimes:jpg,jpeg,png',
            'license_start_date'=>'required|date',
            'license_end_date'=>'required|date',
            'max_students'=>'required|integer',
            'max_assignments'=>'required|integer',
            'max_submissions'=>'required|integer',
            'max_admins'=>'required|integer',
            'max_trainers'=>'required|integer',
            'is_active'=>'required|string',
            'technical_supervisor'=>'required|string',
            'theme_color'=>'required|string',

            // Owner Info
            'owner_user_name'=>'required|string|unique:users,user_name,'.$business_location->owner_id,
            'owner_full_name'=>'required|string',
            'owner_email'=>'required|string|email|unique:users,email,'.$business_location->owner_id,
            'owner_address'=>'nullable|string',
            'owner_city'=>'nullable|string',
            'owner_state'=>'nullable|string',
            'owner_country'=>'nullable|string',
            'owner_landmark'=>'nullable|string',
            'owner_phone'=>'nullable|integer',
            'owner_alternative_phone'=>'nullable|integer',
            'owner_contact_number'=>'nullable|integer',
            'owner_language'=>'nullable|string',
            'owner_nationality'=>'nullable|string',
            'owner_national_number'=>'nullable|string',
            'owner_dob'=>'nullable|date',
            'owner_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'owner_gender'=>'nullable|string',
            'owner_marital_status'=>'nullable|string',
            'owner_blood_group'=>'nullable|string',
            'owner_fb_link'=>'nullable|url',
            'owner_twitter_link'=>'nullable|url',
            'owner_social_media_1'=>'nullable|url',
            'owner_social_media_2'=>'nullable|url',
            'owner_is_active'=>'required|string',
        ]);
        
        if ($request->hasFile('image')) {
            
            if ( $business_location->image !== null) {
                $old_image = $business_location->image;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->image ;
            $ext = $image->getClientOriginalExtension();
            $newImageName = "business_location-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $imageName = $newImageName;
        }
        else
        {
            $imageName = $business_location->image;
        }

        if ($request->hasFile('owner_image')) {
            
            if ( $business_location->owner->image !== null) {
                $old_image = $business_location->owner->image;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->owner_image ;
            $ext = $image->getClientOriginalExtension();
            $newOwnerImageName = "user-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $owner_imageName = $newOwnerImageName;
        }
        else
        {
            $owner_imageName = $business_location->owner->image;
        }

        // Business Location Info
        $business_name = $request->business_name;
        $email = $request->email;
        $address = $request->address;
        $phone = $request->phone;
        $alternative_phone = $request->alternative_phone;
        $image = $imageName;
        $is_active = $request->is_active;
        $license_start_date = $request->license_start_date;
        $license_end_date = $request->license_end_date;
        $max_students = $request->max_students;
        $max_assignments = $request->max_assignments;
        $max_submissions = $request->max_submissions;
        $max_admins = $request->max_admins;
        $max_trainers = $request->max_trainers;
        $technical_supervisor = $request->technical_supervisor;
        $theme_color = $request->theme_color;
        // Owner Info
        $owner_user_name = $request->owner_user_name;
        $owner_full_name = $request->owner_full_name;
        $owner_email = $request->owner_email;
        $owner_address = $request->owner_address;
        $owner_city = $request->owner_city;
        $owner_state = $request->owner_state;
        $owner_country = $request->owner_country;
        $owner_landmark = $request->owner_landmark;
        $owner_phone = $request->owner_phone;
        $owner_alternative_phone = $request->owner_alternative_phone;
        $owner_language = $request->owner_language;
        $owner_nationality = $request->owner_nationality;
        $owner_national_number = $request->owner_national_number;
        $owner_marital_status = $request->owner_marital_status;
        $owner_image = $owner_imageName;
        $owner_dob = $request->owner_dob;
        $owner_gender = $request->owner_gender;
        $owner_blood_group = $request->owner_blood_group;
        $owner_contact_number = $request->owner_contact_number;
        $owner_fb_link = $request->owner_fb_link;
        $owner_twitter_link = $request->owner_twitter_link;
        $owner_social_media_1 = $request->owner_social_media_1;
        $owner_social_media_2 = $request->owner_social_media_2;
        $owner_is_active = $request->owner_is_active;

        $business_location->update([
            'business_name' => $business_name,
            'email' => $email,
            'address' => $address,
            'phone' => $phone,
            'alternative_phone' => $alternative_phone,
            'image' => $image,
            'is_active' => $is_active,
            'license_start_date' => $license_start_date,
            'license_end_date' => $license_end_date,
            'max_students' => $max_students,
            'max_assignments' => $max_assignments,
            'max_submissions' => $max_submissions,
            'max_admins' => $max_admins,
            'max_trainers' => $max_trainers,
            'technical_supervisor' => $technical_supervisor,
            'theme_color' => $theme_color,
        ]);
        
        $owner->update([
            'user_name' => $owner_user_name,
                'full_name' => $owner_full_name,
                'email' => $owner_email,
                'address' => $owner_address,
                'city' => $owner_city,
                'state' => $owner_state,
                'country' => $owner_country,
                'landmark' => $owner_landmark,
                'phone' => $owner_phone,
                'alternative_phone' => $owner_alternative_phone,
                'language' => $owner_language,
                'nationality' => $owner_nationality,
                'national_number' => $owner_national_number,
                'marital_status' => $owner_marital_status,
                'dob' => $owner_dob,
                'gender' => $owner_gender,
                'blood_group' => $owner_blood_group,
                'contact_number' => $owner_contact_number,
                'image' => $owner_image,
                'fb_link' => $owner_fb_link,
                'twitter_link' => $owner_twitter_link,
                'social_media_1' => $owner_social_media_1,
                'social_media_2' => $owner_social_media_2,
                'is_active' => $owner_is_active,
            ]);

        return redirect( route('allBusinessLocations') )->with('message',"Business Location data has been updated succesffuly");
    }
    
    public function delete($id){
        $deleted_by = Auth::user()->id;
        $Business_location = Business_location::find($id);
        $owner = User::find($Business_location->owner_id);
        $Business_location -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $Business_location -> delete();
        
        $owner -> update([
            'is_active' => "InActive"
        ]);


        return redirect( route('allBusinessLocations') )->with('message',"Business Location data has been deleted succesffuly");
    }

}
