<?php

namespace App\Http\Controllers;

use App\Models\Business_location;
use App\Models\Question;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class QuestionController extends Controller
{
    // Show list of Questions in descenting according to ID with pagination
    public function list(){
        $questions = Question::orderBy('id', 'desc')
        ->get();
        return view('questions.list' , [
            'questions' => $questions
        ]);
    }
    
    // View specific Question
    public function view($id){
        
        $question =Question::find($id);
        
        return view('questions.view' , [
            'question' => $question,            
        ]);
    }
    
    // Search in Questions
    public function search($word){
        
        $questions =Question::where('question_title', 'like' , '%'.$word.'%')
        // ->paginate(25);
        ->get();
        return view('questions.search' , [
            'questions' => $questions
        ]);
    }
    
    // Create Question
    public function create(){
        // Get Business Locations data
        // $business_locations = Business_location::select('id' , 'business_name')->get();

        return view('questions.create');

        // return view('questions.create' , [
        //     'business_locations' => $business_locations
        // ]);
    }

    // Store data to Question table at DB
    public function store(Request $request){

        // Make validation on entered data 
        $request->validate([
            'question_title'=>'required|string',
            'question_note'=>'nullable|string',
            'question_title_ar'=>'required|string',
            'question_note_ar'=>'nullable|string',
            'answers'=>'nullable|array',
            // 'business_id'=>'required|exists:business_locations,id',
            'answers.*.answer_image'=>'nullable|image|mimes:jpg,jpeg,png',        
            
        ]);
        
        $answers = [];
        foreach ($request->answers as $key => $value) {
            
            
            // Check if user upload image on question or no 
            if ($request->hasFile('answers.*.answer_image')) {
                
                // Rename image and save it in case of image has been uploaded
                $img = $value['answer_image'] ;
                $ext = $img->getClientOriginalExtension();
                $imageName = "question-" . uniqid() . ".$ext";
                $img->move( public_path('uploads') , $imageName);
                $new_answer = [
                    'answer_index' => $value['answer_index'],
                    'answer_text' => $value['answer_text'],
                    'answer_text_ar' => $value['answer_text_ar'],
                    'answer_image' => $imageName,
                ];
                $answers[] = $new_answer;
                
            } else {
                $imageName = null;
                $new_answer = [
                    'answer_index' => $value['answer_index'],
                    'answer_text' => $value['answer_text'],
                    'answer_text_ar' => $value['answer_text_ar'],
                    'answer_image' => $imageName,
                ];
                $answers[] = $new_answer;
                
            }

        }

        $question_title = $request->question_title;
        $question_note = $request->question_note;
        $question_title_ar = $request->question_title_ar;
        $question_note_ar = $request->question_note_ar;
        $answers = json_encode($answers);
        $created_by = Auth::user()->id;
        // $business_id = 1;


        // Insert data into Questions table in DB
        Question::create([
            'question_title' => $question_title,
            'question_note' => $question_note,
            'question_title_ar' => $question_title_ar,
            'question_note_ar' => $question_note_ar,
            'answers' => $answers,
            // 'business_id' => $business_id,
            'created_by' => $created_by,

        ]);

        return redirect( route('allQuestions') )->with('message',"New Question has been created");
        
    }

    // Edit specifi Question Data
    // get this specific Question data and return it at the form
    public function edit($id){
        $question =Question::find($id);
        // $business_locations = Business_location::select('id' , 'business_name')->get();
        // $authors = Author::select('id' , 'name')->get();
        // dd($book);
        return view('questions.edit', [
            // 'business_locations' => $business_locations,
            'question' => $question,
        ]);
    }
    
    public function update(Request $request , $id){
        // dd($request);
        $request->validate([
            'question_title'=>'required|string',
            'question_note'=>'nullable|string',
            'question_title_ar'=>'required|string',
            'question_note_ar'=>'nullable|string',
            'answers'=>'nullable|array',
            // 'business_id'=>'required|exists:business_locations,id',
            'answers.*.answer_image'=>'nullable|image|mimes:jpg,jpeg,png',        
            
        ]);
        
        $question = Question::find($id);
        $answers = [];
        foreach ($request->answers as $key => $value) {
            
            
            // Check if user upload image on question or no 
            if ($request->hasFile('answers.*.answer_image')) {
                
                // Rename image and save it in case of image has been uploaded
                $img = $value['answer_image'] ;
                $ext = $img->getClientOriginalExtension();
                $imageName = "question-" . uniqid() . ".$ext";
                $img->move( public_path('uploads') , $imageName);
                $new_answer = [
                    'answer_index' => $value['answer_index'],
                    'answer_text' => $value['answer_text'],
                    'answer_text_ar' => $value['answer_text_ar'],
                    'answer_image' => $imageName,
                ];
                $answers[] = $new_answer;
                
            } else {
                $imageName = null;
                $new_answer = [
                    'answer_index' => $value['answer_index'],
                    'answer_text' => $value['answer_text'],
                    'answer_text_ar' => $value['answer_text_ar'],
                    'answer_image' => $imageName,
                ];
                $answers[] = $new_answer;
                
            }

        }
        
        $question_title = $request->question_title;
        $question_note = $request->question_note;
        $question_title_ar = $request->question_title_ar;
        $question_note_ar = $request->question_note_ar;
        $answers = json_encode($answers);
        

        $question->update([
            'question_title' => $question_title,
            'question_note' => $question_note,
            'question_title_ar' => $question_title_ar,
            'question_note_ar' => $question_note_ar,
            'answers' => $answers,
           
        ]);

        return redirect( route('allQuestions') )->with('message',"Question data has been updated succesffuly");
    }


    public function delete($id){
        $deleted_by = Auth::user()->id;
        $question = Question::find($id);
        $question -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $question -> delete();


        return redirect( route('allQuestions') )->with('message',"Question data has been deleted succesffuly");
    }

}
