<?php

namespace App\Http\Controllers;

use App\Models\Business_location;
use App\Models\Report;
use App\Models\Submission;
use Illuminate\Http\Request;

class ReportController extends Controller
{

    public function index($assignment_id , $submission_id)
    {

        $submission_id = $submission_id;
        $reports = Report::where('assignment_ids' , 'LIKE' , '%'.$assignment_id.'%')
        ->get();

        // dd($submission_id);
        // dd($reports);
        

        return view('reports.index', [
            'reports' => $reports,
            'submission_id' => $submission_id
        ]);
    }

    public function check($report_id)
    {

        $report = Report::find($report_id);
        $ids = explode(',', $report->assignment_ids);
        $submissions = Submission::whereIn('assignment_id', $ids)->get();
        
        // dd($report);
        // dd($report->assignment_ids);
        // dd($ids);
        // dd($submissions);
        
        // $business_location_id = 1 ;
        // $business_location = Business_location::select('technical_supervisor' , 'u.full_name' )
        // ->leftjoin('users as u','u.id', '=', 'owner_id')
        // ->find($business_location_id);
        
        // dd($business_location);


        return view('reports.templates.check_templates', [
            'report' => $report,
            'submissions' =>  $submissions,
            // 'business_location' =>  $business_location,
        ]);
    }
 
    public function view(Request $request)
    {

        
        $report = Report::find($request->report_id);
        
        // $submission = Submission::find($submission_id);
        // dd($request->submission_id);
        $report_file = "reports.templates." . $report->report_file;
        // $ids = str_split(str_replace(',', '', $report->assignment_ids));
        $ids = explode(',', $request->submission_id);
        
        $submissions = Submission::whereIn('id', $ids)->get();
        
        // dd($report_id);
        // dd($submission_id);
        // dd($report_file);
        // dd($report);
        // dd($report->assignment_ids);
        dd($ids);
        // dd($submissions);
        // dd($submissions->student_id );
        
        $business_location_id = 1 ;
        $business_location = Business_location::select('technical_supervisor' , 'u.full_name' )
        ->leftjoin('users as u','u.id', '=', 'owner_id')
        ->find($business_location_id);
        
        // dd($business_location);


        return view($report_file, [
            'report' => $report,
            'submissions' =>  $submissions,
            'business_location' =>  $business_location,
        ]);
    }

}
