<?php

namespace App\Http\Controllers;

use App\Models\Assignment;
use App\Models\Question;
use App\Models\Student;
use App\Models\Student_father_profile;
use App\Models\Student_mother_profile;
use App\Models\Student_superior_profile;
use App\Models\Students_group1_profile;
use App\Models\Students_group2_profile;
use App\Models\Students_group3_profile;
use App\Models\Students_group4_profile;
use App\Models\Submission;
use Illuminate\Http\Request;

class StudentController extends Controller
{
    public function index()
    {
        $students = "Hello";
        dd($students);
        return view('students.index', [
            'students' => $students
        ]);
    }

    public function list()
    {
        $students = Student::orderBy('id', 'desc')
            ->get();
        // dd($students);
        return view('students.list', [
            'students' => $students
        ]);
    }
    
    public function view($id)
    {
        $student = Student::leftjoin('students_group1_profiles','students_group1_profiles.student_id', '=', 'students.id')
        ->leftjoin('students_group2_profiles','students_group2_profiles.student_id', '=', 'students.id')
        ->leftjoin('students_group3_profiles','students_group3_profiles.student_id', '=', 'students.id')
        ->leftjoin('students_group4_profiles','students_group4_profiles.student_id', '=', 'students.id')
        ->leftjoin('student_father_profiles','student_father_profiles.id', '=', 'students.father_id')
        ->leftjoin('student_mother_profiles','student_mother_profiles.id', '=', 'students.mother_id')
        ->leftjoin('student_superior_profiles','student_superior_profiles.id', '=', 'students.superior_id')
        // ->leftjoin('users','student.created_by', '=', 'students.superior_id')
        // ->where('students.id', '=' , $id)
        // ->get();
        ->find($id);
        
        // dd($student);

        return view('students.view', [
            'student' => $student
        ]);
    }

    public function search($word)
    {
        $students = Student::where($word, 'like', '%' . $word . '%')
            ->paginate(25);

        return view('students.search', [
            'students' => $students
        ]);
    }

    // Create user
    public function create_old()
    {
        // // Get business locations data
        // $business_locations = Business_location::select('id' , 'business_name')->get();
        return view('students.create-old');
        // return view('users.create' , [
        //     'business_locations' => $business_locations
        // ]);
    }

    // Create user
    public function create()
    {
        // // Get business locations data
        $student_father_profiles = Student_father_profile::select('id' , 'father_name' , 'father_national_number')->get();
        $student_mother_profiles = Student_mother_profile::select('id' , 'mother_name' , 'mother_national_number')->get();
        $student_superior_profiles = Student_superior_profile::select('id' , 'superior_name' , 'superior_national_number')->get();
        return view('students.create' , [
            'student_father_profiles' => $student_father_profiles,
            'student_mother_profiles' => $student_mother_profiles,
            'student_superior_profiles' => $student_superior_profiles
        ]);
    }

    // Store data to Users table at DB
    public function store(Request $request)
    {
        // dd($request->does_complex_disabilities);
        // dd($request);
        // // Make validation on entered data 
        $request->validate([
            'student_name'=>'required|string',
            'birth_address'=>'nullable|string',
            'address'=>'nullable|string',
            'city'=>'nullable|string',
            'state'=>'nullable|string',
            'country'=>'nullable|string',
            'landmark'=>'nullable|string',
            'home_phone'=>'nullable|string',
            'phone'=>'nullable|string',
            'alternative_phone'=>'nullable|string',
            'contact_number'=>'nullable|string',
            'height'=>'nullable|string',
            'weight'=>'nullable|string',
            'dob'=>'nullable|date',
            'image'=>'nullable|image|mimes:jpg,jpeg,png',
            'gender'=>'nullable|string',
            'school_name'=>'nullable|string',
            'nationality'=>'required|string',
            'national_number'=>'required|string|unique:students,national_number',
            'blood_group'=>'nullable|string',
            'fb_link'=>'nullable|url',
            'twitter_link'=>'nullable|url',
            'social_media_1'=>'nullable|url',
            'social_media_2'=>'nullable|url',
            // 'created_by'=>'nullable|exists:users,id'
            // Student Group 1
            // Main Problem Info
            'main_complaint'=>'nullable|string',
            'problem_start_at'=>'nullable|date',
            'time_of_increasing_problem_feeling'=>'nullable|string',
            'time_of_decreasing_problem_feeling'=>'nullable|string',
            'problem_as_child_view'=>'nullable|string',
            'problem_as_father_view'=>'nullable|string',
            'problem_as_mother_view'=>'nullable|string',
            'problem_reasons'=>'nullable|string',
            'student_diseases'=>'nullable|array',
            'previous_treatment_efforts'=>'nullable|array',
            'genetic_diseases'=>'nullable|array',
            'injuries_and_wounds'=>'nullable|array',
            // Family History
            // Father Info
            'father_age_when_applying' =>'nullable|string',
            'father_age_at_student_birth' =>'nullable|string',
            'father_relation_with_child' =>'nullable|string',
            'child_attitudes_towards_father' =>'nullable|string',
            // Mother Info
            'mother_age_when_applying' =>'nullable|string',
            'mother_age_at_student_birth' =>'nullable|string',
            'mother_relation_with_child' =>'nullable|string',
            'child_attitudes_towards_mother' =>'nullable|string',
            // Superior Info
            'superior_age_when_applying' =>'nullable|string',
            'superior_age_at_student_birth' =>'nullable|string',
            'superior_relation_with_child' =>'nullable|string',
            'child_attitudes_towards_superior' =>'nullable|string',
            // Continue Family History
            'relation_between_parents' =>'nullable|string',
            'main_problems_between_parents' =>'nullable|string',
            'child_attitude_towards_family_problems' =>'nullable|string',
            'brothers_and_sisters' =>'nullable|array',
            'brothers_and_sisters_notes' =>'nullable|string',
            'are_relatives' =>'nullable|string',
            'other_relatives' =>'nullable|array',
            'other_relatives_notes' =>'nullable|string',
            // The standard of living for the family
            'economic_situation' =>'nullable|string',
            'monthly_average_income' =>'nullable|string',
            'monthly_average_expenses' =>'nullable|string',
            'family_economic_problems' =>'nullable|string',
            'family_child_acceptance' =>'nullable|string',
            'home_type' =>'nullable|string',
            'no_persons_in_room' =>'nullable|string',
            'has_child_individual_room' =>'nullable|string',
            'no_father_married' =>'nullable|string',
            'no_mother_married' =>'nullable|string',
            'family_divorce_cases' =>'nullable|string',
            'family_stress_source' =>'nullable|string',
            'family_entertainment_source' =>'nullable|string',
            'family_entertainment_source_child_involve' =>'nullable|string',
            'psychological_social_conditions_affect_child' =>'nullable|string',
            // Student Group 2
            // Organic Growth History
            'mother_diseases_during_pregnancy' =>'nullable|string',
            'mother_pregnancy_type' =>'nullable|string',
            'disturbances_during_childbirth' =>'nullable|string',
            'mother_pregnancy_injuries' =>'nullable|string',
            'child_weight_at_birth' =>'nullable|string',
            'breastfeeding_type' =>'nullable|string',
            'breastfeeding_type_note' =>'nullable|string',
            'child_age_on_weaning' =>'nullable|string',
            'weaning_problems' =>'nullable|string',
            'child_age_on_first_tooth' =>'nullable|string',
            'child_age_on_sitting' =>'nullable|string',
            'child_age_on_crawls' =>'nullable|string',
            'child_age_on_stand_up' =>'nullable|string',
            'child_age_on_walking' =>'nullable|string',
            'child_age_on_first_word' =>'nullable|string',
            'child_age_on_open_door' =>'nullable|string',
            'child_age_on_use_spoon' =>'nullable|string',
            'child_age_on_adjust_output_process' =>'nullable|string',
            'does_health_problems' =>'nullable|string',
            'current_health_problems' =>'nullable|array',
            'does_regularly_medicines' =>'nullable|string',
            'regularly_medicines' =>'nullable|array',
            'does_complex_disabilities' =>'nullable|array',
            'complex_disabilities_other' =>'nullable|string',
            'does_prosthetic_devices' =>'nullable|string',
            'prosthetic_devices' =>'nullable|array',
            // pills Psychological behavioral
            'personality_traits' =>'nullable|string',
            'relation_with_friends' =>'nullable|string',
            'relation_with_relatives' =>'nullable|string',
            'relation_with_neighbour' =>'nullable|string',
            'relation_with_other_gender' =>'nullable|string',
            'upbringing_style' =>'nullable|string',
            'reinforcements' =>'nullable|array',
            'is_punishment' =>'nullable|string',
            'punishment_reasons' =>'nullable|string',
            'child_behavior_notes' =>'nullable|string',
            'source_of_authority' =>'nullable|string',
            'source_of_authority_notes' =>'nullable|string',
            'crying' =>'nullable|string',
            'talkative' =>'nullable|string',
            'lots_of_movement' =>'nullable|string',
            'orderly_plan' =>'nullable|string',
            'damages' =>'nullable|string',
            'find_around_place' =>'nullable|string',
            'grieves_with_specialist' =>'nullable|string',
            'afraid' =>'nullable|string',
            'enjoys' =>'nullable|string',
            'runs_randomly' =>'nullable|string',
            // Student Group 3
            // The main neurological and behavioral symptoms
            'outbursts_of_anger' =>'nullable|string',
            'outbursts_of_anger_time' =>'nullable|string',
            'outbursts_of_anger_degree' =>'nullable|string',
            'finger_sucking' =>'nullable|string',
            'finger_sucking_time' =>'nullable|string',
            'finger_sucking_degree' =>'nullable|string',
            'wetting_bed' =>'nullable|string',
            'wetting_bed_time' =>'nullable|string',
            'wetting_bed_degree' =>'nullable|string',
            'night_screams_of_terror' =>'nullable|string',
            'night_screams_of_terror_time' =>'nullable|string',
            'night_screams_of_terror_degree' =>'nullable|string',
            'sleep_walking' =>'nullable|string',
            'sleep_walking_time' =>'nullable|string',
            'sleep_walking_degree' =>'nullable|string',
            'excessive_fears' =>'nullable|string',
            'excessive_fears_time' =>'nullable|string',
            'excessive_fears_degree' =>'nullable|string',
            'nervous_crises' =>'nullable|string',
            'nervous_crises_time' =>'nullable|string',
            'nervous_crises_degree' =>'nullable|string',
            'cramps' =>'nullable|string',
            'cramps_time' =>'nullable|string',
            'cramps_degree' =>'nullable|string',
            'biting_nails' =>'nullable|string',
            'biting_nails_time' =>'nullable|string',
            'biting_nails_degree' =>'nullable|string',
            'smash_clothes' =>'nullable|string',
            'smash_clothes_time' =>'nullable|string',
            'smash_clothes_degree' =>'nullable|string',
            'stereotyped_movements' =>'nullable|string',
            'stereotyped_movements_time' =>'nullable|string',
            'stereotyped_movements_degree' =>'nullable|string',
            'baby_gets_nervous_from_loud_noises' =>'nullable|string',
            'baby_gets_nervous_from_loud_noises_time' =>'nullable|string',
            'baby_gets_nervous_from_loud_noises_degree' =>'nullable|string',
            'baby_gets_nervous_from_bright_lights' =>'nullable|string',
            'baby_gets_nervous_from_bright_lights_time' =>'nullable|string',
            'baby_gets_nervous_from_bright_lights_degree' =>'nullable|string',
            'sexual_behaviors' =>'nullable|string',
            'sexual_behaviors_time' =>'nullable|string',
            'sexual_behaviors_degree' =>'nullable|string',
            'epileptic_seizures' =>'nullable|string',
            'epileptic_seizures_time' =>'nullable|string',
            'epileptic_seizures_degree' =>'nullable|string',
            'difficulty_interacting_with_peers' =>'nullable|string',
            'difficulty_interacting_with_peers_desc' =>'nullable|string',
            'extra_activity' =>'nullable|string',
            'extra_activity_desc' =>'nullable|string',
            'make_fun_of_others' =>'nullable|string',
            'make_fun_of_others_desc' =>'nullable|string',
            'can_not_wait' =>'nullable|string',
            'can_not_wait_desc' =>'nullable|string',
            'curses_and_says_inappropriate_words' =>'nullable|string',
            'curses_and_says_inappropriate_words_desc' =>'nullable|string',
            'acts_inappropriately' =>'nullable|string',
            'acts_inappropriately_desc' =>'nullable|string',
            'very_shy' =>'nullable|string',
            'very_shy_desc' =>'nullable|string',
            'speaks_low_voice' =>'nullable|string',
            'speaks_low_voice_desc' =>'nullable|string',
            'not_defend_himself' =>'nullable|string',
            'not_defend_himself_desc' =>'nullable|string',
            'afraid_of_animals' =>'nullable|string',
            'afraid_of_animals_desc' =>'nullable|string',
            'hesitant_and_confused' =>'nullable|string',
            'hesitant_and_confused_desc' =>'nullable|string',
            'feeling_powerless_and_lacking_in_self_confidence' =>'nullable|string',
            'feeling_powerless_and_lacking_in_self_confidence_desc' =>'nullable|string',
            'feeling_tense_and_refuses_to_hug' =>'nullable|string',
            'feeling_tense_and_refuses_to_hug_desc' =>'nullable|string',
            'other_social_problems' =>'nullable|string',
            // Student Group 4
            // Psychological Examination
            'last_psychological_examination_name' =>'nullable|string',
            'last_psychological_examination_date' =>'nullable|string',
            'previous_mental_disorders' =>'nullable|array',
            'first_intelligence_and_ability_test_name' =>'nullable|string',
            'first_intelligence_and_ability_test_date' =>'nullable|string',
            'first_intelligence_and_ability_test_reason' =>'nullable|string',
            'first_intelligence_and_ability_test_result' =>'nullable|string',
            'first_intelligence_and_ability_test_who_recommended_it' =>'nullable|string',
            'first_intelligence_and_ability_test_explan' =>'nullable|string',
            'first_intelligence_and_ability_test_recommendations' =>'nullable|string',
            'second_intelligence_and_ability_test_name' =>'nullable|string',
            'second_intelligence_and_ability_test_date' =>'nullable|string',
            'second_intelligence_and_ability_test_reason' =>'nullable|string',
            'second_intelligence_and_ability_test_result' =>'nullable|string',
            'second_intelligence_and_ability_test_who_recommended_it' =>'nullable|string',
            'second_intelligence_and_ability_test_explan' =>'nullable|string',
            'second_intelligence_and_ability_test_recommendations' =>'nullable|string',
            'third_intelligence_and_ability_test_name' =>'nullable|string',
            'third_intelligence_and_ability_test_date' =>'nullable|string',
            'third_intelligence_and_ability_test_reason' =>'nullable|string',
            'third_intelligence_and_ability_test_result' =>'nullable|string',
            'third_intelligence_and_ability_test_who_recommended_it' =>'nullable|string',
            'third_intelligence_and_ability_test_explan' =>'nullable|string',
            'third_intelligence_and_ability_test_recommendations' =>'nullable|string',
            'fourth_intelligence_and_ability_test_name' =>'nullable|string',
            'fourth_intelligence_and_ability_test_date' =>'nullable|string',
            'fourth_intelligence_and_ability_test_reason' =>'nullable|string',
            'fourth_intelligence_and_ability_test_result' =>'nullable|string',
            'fourth_intelligence_and_ability_test_who_recommended_it' =>'nullable|string',
            'fourth_intelligence_and_ability_test_explan' =>'nullable|string',
            'fourth_intelligence_and_ability_test_recommendations' =>'nullable|string',
            'eats_alone_without_help' =>'nullable|string',
            'gets_dressed_without_help' =>'nullable|string',
            'asking_to_go_to_the_bathroom' =>'nullable|string',
            'takes_care_of_himself_in_bathroom' =>'nullable|string',
            'use_of_yelling_to_express' =>'nullable|string',
            'pay_attention_to_sounds' =>'nullable|string',
            'distinguish_mother_and_father_voice' =>'nullable|string',
            'distinguish_family_members_voice' =>'nullable|string',
            'using_audio_clips' =>'nullable|string',
            'pronounces_word_understandable' =>'nullable|string',
            'turns_around_when_he_hears_his_name' =>'nullable|string',
            'looking_the_person_speaking_during_conversation' =>'nullable|string',
            'uses_two_words_sentence' =>'nullable|string',
            'needs_encouragement_to_speak' =>'nullable|string',
            'uses_expressive_language_to_express_his_needs' =>'nullable|string',
            'stutters_while_speaking' =>'nullable|string',
            'remove_letters_from_words' =>'nullable|string',
            'add_letters_to_words' =>'nullable|string',
            'turns_some_letters_in_word' =>'nullable|string',
            'changes_some_letters_when_saying_word' =>'nullable|string',
            'speaks_but_the_words_are_distorted_and_incomprehensible' =>'nullable|string',
            'understands_what_is_asked_of_him' =>'nullable|string',
            'language_level' =>'nullable|string',
            'level_of_expression_of_his_needs_linguistically' =>'nullable|string',
            'level_of_coherence_of_ideas' =>'nullable|string',
            'speed_level' =>'nullable|string',
            'response' =>'nullable|string',

        ]);

        // dd($request);
        
        // Check if user upload image or no 
        if ($request->hasFile('image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->image ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "student-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        $student_name = $request->student_name;
        $birth_address = $request->birth_address;
        $address = $request->address;
        $city = $request->city;
        $state = $request->state;
        $country = $request->country;
        $landmark = $request->landmark;
        $home_phone = $request->home_phone;
        $phone = $request->phone;
        $alternative_phone = $request->alternative_phone;
        $contact_number = $request->contact_number;
        $height = $request->height;
        $weight = $request->weight;
        $image = $imageName;
        $dob = $request->dob;
        $gender = $request->gender;
        $blood_group = $request->blood_group;
        $school_name = $request->school_name;
        $nationality = $request->nationality;
        $national_number = $request->national_number;
        $fb_link = $request->fb_link;
        $twitter_link = $request->twitter_link;
        $social_media_1 = $request->social_media_1;
        $social_media_2 = $request->social_media_2;
        // $created_by = $request->created_by;
        $created_by = 1;
        // Student Group 1
        // Main Problem Info
        $main_complaint = $request->main_complaint;
        $problem_start_at = $request->problem_start_at;
        $time_of_increasing_problem_feeling = $request->time_of_increasing_problem_feeling;
        $time_of_decreasing_problem_feeling = $request->time_of_decreasing_problem_feeling;
        $problem_as_child_view = $request->problem_as_child_view;
        $problem_as_father_view = $request->problem_as_father_view;
        $problem_as_mother_view = $request->problem_as_mother_view;
        $problem_reasons = $request->problem_reasons;
        $student_diseases = json_encode($request->student_diseases);
        $previous_treatment_efforts = json_encode($request->previous_treatment_efforts);
        $genetic_diseases = json_encode($request->genetic_diseases);
        $injuries_and_wounds = json_encode($request->injuries_and_wounds);
        
        // Father Info
        $father_age_when_applying = $request->father_age_when_applying;
        $father_age_at_student_birth = $request->father_age_at_student_birth;
        $father_relation_with_child = $request->father_relation_with_child;
        $child_attitudes_towards_father = $request->child_attitudes_towards_father;
        
        // Mother Info
        $mother_age_when_applying = $request->mother_age_when_applying;
        $mother_age_at_student_birth = $request->mother_age_at_student_birth;
        $mother_relation_with_child = $request->mother_relation_with_child;
        $child_attitudes_towards_mother = $request->child_attitudes_towards_mother;
        
        // Superior Info
        $superior_age_when_applying = $request->superior_age_when_applying;
        $superior_age_at_student_birth = $request->superior_age_at_student_birth;
        $superior_relation_with_child = $request->superior_relation_with_child;
        $child_attitudes_towards_superior = $request->child_attitudes_towards_superior;
        
        // Continue Family History
        $relation_between_parents = $request->relation_between_parents;
        $main_problems_between_parents = $request->main_problems_between_parents;
        $child_attitude_towards_family_problems = $request->child_attitude_towards_family_problems;
        $brothers_and_sisters = json_encode($request->brothers_and_sisters);
        $brothers_and_sisters_notes = $request->brothers_and_sisters_notes;
        $are_relatives = $request->are_relatives;
        $other_relatives = json_encode($request->other_relatives);
        $other_relatives_notes = $request->other_relatives_notes;
        // The standard of living for the family
        $economic_situation = $request->economic_situation;
        $monthly_average_income = $request->monthly_average_income;
        $monthly_average_expenses = $request->monthly_average_expenses;
        $family_economic_problems = $request->family_economic_problems;
        $family_child_acceptance = $request->family_child_acceptance;
        $home_type = $request->home_type;
        $no_persons_in_room = $request->no_persons_in_room;
        $has_child_individual_room = $request->has_child_individual_room;
        $no_father_married = $request->no_father_married;
        $no_mother_married = $request->no_mother_married;
        $family_divorce_cases = $request->family_divorce_cases;
        $family_stress_source = $request->family_stress_source;
        $family_entertainment_source = $request->family_entertainment_source;
        $family_entertainment_source_child_involve = $request->family_entertainment_source_child_involve;
        $psychological_social_conditions_affect_child = $request->psychological_social_conditions_affect_child;
        
        // Student Group 2
        // Organic Growth History
        $mother_diseases_during_pregnancy = $request->mother_diseases_during_pregnancy;
        $mother_pregnancy_type = $request->mother_pregnancy_type;
        $disturbances_during_childbirth = $request->disturbances_during_childbirth;
        $mother_pregnancy_injuries = $request->mother_pregnancy_injuries;
        $child_weight_at_birth = $request->child_weight_at_birth;
        $breastfeeding_type = $request->breastfeeding_type;
        $breastfeeding_type_note = $request->breastfeeding_type_note;
        $child_age_on_weaning = $request->child_age_on_weaning;
        $weaning_problems = $request->weaning_problems;
        $child_age_on_first_tooth = $request->child_age_on_first_tooth;
        $child_age_on_sitting = $request->child_age_on_sitting;
        $child_age_on_crawls = $request->child_age_on_crawls;
        $child_age_on_stand_up = $request->child_age_on_stand_up;
        $child_age_on_walking = $request->child_age_on_walking;
        $child_age_on_first_word = $request->child_age_on_first_word;
        $child_age_on_open_door = $request->child_age_on_open_door;
        $child_age_on_use_spoon = $request->child_age_on_use_spoon;
        $child_age_on_adjust_output_process = $request->child_age_on_adjust_output_process;
        $does_health_problems = $request->does_health_problems;
        $current_health_problems = json_encode($request->current_health_problems);
        $does_regularly_medicines = $request->does_regularly_medicines;
        $regularly_medicines = json_encode($request->regularly_medicines);
        $does_complex_disabilities = json_encode($request->does_complex_disabilities);
        $complex_disabilities_other = $request->complex_disabilities_other;
        $does_prosthetic_devices = $request->does_prosthetic_devices;
        $prosthetic_devices = json_encode($request->prosthetic_devices);
        
        // pills Psychological behavioral
        $personality_traits = $request->personality_traits;
        $relation_with_friends = $request->relation_with_friends;
        $relation_with_relatives = $request->relation_with_relatives;
        $relation_with_neighbour = $request->relation_with_neighbour;
        $relation_with_other_gender = $request->relation_with_other_gender;
        $upbringing_style = $request->upbringing_style;
        $reinforcements = json_encode($request->reinforcements);
        $is_punishment = $request->is_punishment;
        $punishment_reasons = $request->punishment_reasons;
        $child_behavior_notes = $request->child_behavior_notes;
        $source_of_authority = $request->source_of_authority;
        $source_of_authority_notes = $request->source_of_authority_notes;
        $crying = $request->crying;
        $talkative = $request->talkative;
        $lots_of_movement = $request->lots_of_movement;
        $orderly_plan = $request->orderly_plan;
        $damages = $request->damages;
        $find_around_place = $request->find_around_place;
        $grieves_with_specialist = $request->grieves_with_specialist;
        $afraid = $request->find_around_place;
        $enjoys = $request->enjoys;
        $runs_randomly = $request->runs_randomly;
        
        // Student Group 3
        // The main neurological and behavioral symptoms
        $outbursts_of_anger = $request->outbursts_of_anger;
        $outbursts_of_anger_time = $request->outbursts_of_anger_time;
        $outbursts_of_anger_degree = $request->outbursts_of_anger_degree;
        $finger_sucking = $request->finger_sucking;
        $finger_sucking_time = $request->finger_sucking_time;
        $finger_sucking_degree = $request->finger_sucking_degree;
        $wetting_bed = $request->wetting_bed;
        $wetting_bed_time = $request->wetting_bed_time;
        $wetting_bed_degree = $request->wetting_bed_degree;
        $night_screams_of_terror = $request->night_screams_of_terror;
        $night_screams_of_terror_time = $request->night_screams_of_terror_time;
        $night_screams_of_terror_degree = $request->night_screams_of_terror_degree;
        $sleep_walking = $request->sleep_walking;
        $sleep_walking_time = $request->sleep_walking_time;
        $sleep_walking_degree = $request->sleep_walking_degree;
        $excessive_fears = $request->excessive_fears;
        $excessive_fears_time = $request->excessive_fears_time;
        $excessive_fears_degree = $request->excessive_fears_degree;
        $nervous_crises = $request->nervous_crises;
        $nervous_crises_time = $request->nervous_crises_time;
        $nervous_crises_degree = $request->nervous_crises_degree;
        $cramps = $request->cramps;
        $cramps_time = $request->cramps_time;
        $cramps_degree = $request->cramps_degree;
        $biting_nails = $request->biting_nails;
        $biting_nails_time = $request->biting_nails_time;
        $biting_nails_degree = $request->biting_nails_degree;
        $smash_clothes = $request->smash_clothes;
        $smash_clothes_time = $request->smash_clothes_time;
        $smash_clothes_degree = $request->smash_clothes_degree;
        $stereotyped_movements = $request->stereotyped_movements;
        $stereotyped_movements_time = $request->stereotyped_movements_time;
        $stereotyped_movements_degree = $request->stereotyped_movements_degree;
        $baby_gets_nervous_from_loud_noises = $request->baby_gets_nervous_from_loud_noises;
        $baby_gets_nervous_from_loud_noises_time = $request->baby_gets_nervous_from_loud_noises_time;
        $baby_gets_nervous_from_loud_noises_degree = $request->baby_gets_nervous_from_loud_noises_degree;
        $baby_gets_nervous_from_bright_lights = $request->baby_gets_nervous_from_bright_lights;
        $baby_gets_nervous_from_bright_lights_time = $request->baby_gets_nervous_from_bright_lights_time;
        $baby_gets_nervous_from_bright_lights_degree = $request->baby_gets_nervous_from_bright_lights_degree;
        $sexual_behaviors = $request->sexual_behaviors;
        $sexual_behaviors_time = $request->sexual_behaviors_time;
        $sexual_behaviors_degree = $request->sexual_behaviors_degree;
        $epileptic_seizures = $request->epileptic_seizures;
        $epileptic_seizures_time = $request->epileptic_seizures_time;
        $epileptic_seizures_degree = $request->epileptic_seizures_degree;
        $difficulty_interacting_with_peers = $request->difficulty_interacting_with_peers;
        $difficulty_interacting_with_peers_desc = $request->difficulty_interacting_with_peers_desc;
        $extra_activity = $request->extra_activity;
        $extra_activity_desc = $request->extra_activity_desc;
        $make_fun_of_others = $request->make_fun_of_others;
        $make_fun_of_others_desc = $request->make_fun_of_others_desc;
        $can_not_wait = $request->can_not_wait;
        $can_not_wait_desc = $request->can_not_wait_desc;
        $curses_and_says_inappropriate_words = $request->curses_and_says_inappropriate_words;
        $curses_and_says_inappropriate_words_desc = $request->curses_and_says_inappropriate_words_desc;
        $acts_inappropriately = $request->acts_inappropriately;
        $acts_inappropriately_desc = $request->acts_inappropriately_desc;
        $very_shy = $request->very_shy;
        $very_shy_desc = $request->very_shy_desc;
        $speaks_low_voice = $request->speaks_low_voice;
        $speaks_low_voice_desc = $request->speaks_low_voice_desc;
        $not_defend_himself = $request->not_defend_himself;
        $not_defend_himself_desc = $request->not_defend_himself_desc;
        $afraid_of_animals = $request->afraid_of_animals;
        $afraid_of_animals_desc = $request->afraid_of_animals_desc;
        $hesitant_and_confused = $request->hesitant_and_confused;
        $hesitant_and_confused_desc = $request->hesitant_and_confused_desc;
        $feeling_powerless_and_lacking_in_self_confidence = $request->feeling_powerless_and_lacking_in_self_confidence;
        $feeling_powerless_and_lacking_in_self_confidence_desc = $request->feeling_powerless_and_lacking_in_self_confidence_desc;
        $feeling_tense_and_refuses_to_hug = $request->feeling_tense_and_refuses_to_hug;
        $feeling_tense_and_refuses_to_hug_desc = $request->feeling_tense_and_refuses_to_hug_desc;
        $other_social_problems = $request->other_social_problems;

        // Student Group 4
        // Psychological Examination
        $last_psychological_examination_name = $request->last_psychological_examination_name;
        $last_psychological_examination_date = $request->last_psychological_examination_date;
        $previous_mental_disorders = json_encode($request->previous_mental_disorders);
        $first_intelligence_and_ability_test_name = $request->first_intelligence_and_ability_test_name;
        $first_intelligence_and_ability_test_date = $request->first_intelligence_and_ability_test_date;
        $first_intelligence_and_ability_test_reason = $request->first_intelligence_and_ability_test_reason;
        $first_intelligence_and_ability_test_result = $request->first_intelligence_and_ability_test_result;
        $first_intelligence_and_ability_test_who_recommended_it = $request->first_intelligence_and_ability_test_who_recommended_it;
        $first_intelligence_and_ability_test_explan = $request->first_intelligence_and_ability_test_explan;
        $first_intelligence_and_ability_test_recommendations = $request->first_intelligence_and_ability_test_recommendations;
        $second_intelligence_and_ability_test_name = $request->second_intelligence_and_ability_test_name;
        $second_intelligence_and_ability_test_date = $request->second_intelligence_and_ability_test_date;
        $second_intelligence_and_ability_test_reason = $request->second_intelligence_and_ability_test_reason;
        $second_intelligence_and_ability_test_result = $request->second_intelligence_and_ability_test_result;
        $second_intelligence_and_ability_test_who_recommended_it = $request->second_intelligence_and_ability_test_who_recommended_it;
        $second_intelligence_and_ability_test_explan = $request->second_intelligence_and_ability_test_explan;
        $second_intelligence_and_ability_test_recommendations = $request->second_intelligence_and_ability_test_recommendations;
        $third_intelligence_and_ability_test_name = $request->third_intelligence_and_ability_test_name;
        $third_intelligence_and_ability_test_date = $request->third_intelligence_and_ability_test_date;
        $third_intelligence_and_ability_test_reason = $request->third_intelligence_and_ability_test_reason;
        $third_intelligence_and_ability_test_result = $request->third_intelligence_and_ability_test_result;
        $third_intelligence_and_ability_test_who_recommended_it = $request->third_intelligence_and_ability_test_who_recommended_it;
        $third_intelligence_and_ability_test_explan = $request->third_intelligence_and_ability_test_explan;
        $third_intelligence_and_ability_test_recommendations = $request->third_intelligence_and_ability_test_recommendations;
        $fourth_intelligence_and_ability_test_name = $request->fourth_intelligence_and_ability_test_name;
        $fourth_intelligence_and_ability_test_date = $request->fourth_intelligence_and_ability_test_date;
        $fourth_intelligence_and_ability_test_reason = $request->fourth_intelligence_and_ability_test_reason;
        $fourth_intelligence_and_ability_test_result = $request->fourth_intelligence_and_ability_test_result;
        $fourth_intelligence_and_ability_test_who_recommended_it = $request->fourth_intelligence_and_ability_test_who_recommended_it;
        $fourth_intelligence_and_ability_test_explan = $request->fourth_intelligence_and_ability_test_explan;
        $fourth_intelligence_and_ability_test_recommendations = $request->fourth_intelligence_and_ability_test_recommendations;
        $eats_alone_without_help = $request->eats_alone_without_help;
        $gets_dressed_without_help = $request->gets_dressed_without_help;
        $asking_to_go_to_the_bathroom = $request->asking_to_go_to_the_bathroom;
        $takes_care_of_himself_in_bathroom = $request->takes_care_of_himself_in_bathroom;
        $use_of_yelling_to_express = $request->use_of_yelling_to_express;
        $pay_attention_to_sounds = $request->pay_attention_to_sounds;
        $distinguish_mother_and_father_voice = $request->distinguish_mother_and_father_voice;
        $distinguish_family_members_voice = $request->distinguish_family_members_voice;
        $using_audio_clips = $request->using_audio_clips;
        $pronounces_word_understandable = $request->pronounces_word_understandable;
        $turns_around_when_he_hears_his_name = $request->turns_around_when_he_hears_his_name;
        $looking_the_person_speaking_during_conversation = $request->looking_the_person_speaking_during_conversation;
        $uses_two_words_sentence = $request->uses_two_words_sentence;
        $needs_encouragement_to_speak = $request->needs_encouragement_to_speak;
        $uses_expressive_language_to_express_his_needs = $request->uses_expressive_language_to_express_his_needs;
        $stutters_while_speaking = $request->stutters_while_speaking;
        $remove_letters_from_words = $request->remove_letters_from_words;
        $add_letters_to_words = $request->add_letters_to_words;
        $turns_some_letters_in_word = $request->turns_some_letters_in_word;
        $changes_some_letters_when_saying_word = $request->changes_some_letters_when_saying_word;
        $speaks_but_the_words_are_distorted_and_incomprehensible = $request->speaks_but_the_words_are_distorted_and_incomprehensible;
        $understands_what_is_asked_of_him = $request->understands_what_is_asked_of_him;
        $language_level = $request->language_level;
        $level_of_expression_of_his_needs_linguistically = $request->level_of_expression_of_his_needs_linguistically;
        $level_of_coherence_of_ideas = $request->level_of_coherence_of_ideas;
        $speed_level = $request->speed_level;
        $response = $request->response;
        
        


        
        // Father Info
        // Check if selected from exsit fathers data or new father
        if ($request->father_id != null) {
            
            $request->validate([
                'father_id'=>'required|exists:student_father_profiles,id',
            ]);

            $father_id = $request->father_id;
            
        }else{

            $request->validate([
                // Father Info
                'father_name'=>'required|string',
                'father_dob'=>'nullable|date',
                'father_nationality'=>'required|string',
                'father_national_number'=>'required|string|unique:student_father_profiles,father_national_number',
                'father_degree_of_kinship'=>'nullable|string',
                'father_address'=>'nullable|string',
                'father_city'=>'nullable|string',
                'father_state'=>'nullable|string',
                'father_country'=>'nullable|string',
                'father_landmark'=>'nullable|string',
                'father_job'=>'nullable|string',
                'father_image'=>'nullable|image|mimes:jpg,jpeg,png',
                'father_email'=>'required|string|email|unique:student_father_profiles,father_email',
                'father_marital_status'=>'nullable|string',
                'father_phone'=>'nullable|string',
                'father_alternative_phone'=>'nullable|string',
                'father_fb_link'=>'nullable|url',
                'father_twitter_link'=>'nullable|url',
                'father_social_media_1'=>'nullable|url',
                'father_social_media_2'=>'nullable|url',
                'father_qualification'=>'nullable|string',
                'father_qualification_other'=>'nullable|string',
                'father_wedding_date'=>'nullable|string',
                'father_interests'=>'nullable|string',
            ]);
                // Check if user upload image or no 
            if ($request->hasFile('father_image')) {
                // Rename image and save it in case of image has been uploaded
                $father_img = $request->father_image ;
                $father_ext = $father_img->getClientOriginalExtension();
                $father_imageName = "father-" . uniqid() . ".$father_ext";
                $father_img->move( public_path('uploads') , $father_imageName);

            } else {
                // If user doesn't upload image
                $father_imageName = null;
            }

            $father_name = $request->father_name;
            $father_dob = $request->father_dob;
            $father_nationality = $request->father_nationality;
            $father_national_number = $request->father_national_number;
            $father_degree_of_kinship = $request->father_degree_of_kinship;
            $father_address = $request->father_address;
            $father_city = $request->father_city;
            $father_state = $request->father_state;
            $father_country = $request->father_country;
            $father_landmark = $request->father_landmark;
            $father_job = $request->father_job;
            $father_image = $father_imageName;
            $father_email = $request->father_email;
            $father_marital_status = $request->father_marital_status;
            $father_phone = $request->father_phone;
            $father_alternative_phone = $request->father_alternative_phone;
            $father_fb_link = $request->father_fb_link;
            $father_twitter_link = $request->father_twitter_link;
            $father_social_media_1 = $request->father_social_media_1;
            $father_social_media_2 = $request->father_social_media_2;
            $father_qualification = $request->father_qualification;
            $father_qualification_other = $request->father_qualification_other;
            $father_wedding_date = $request->father_wedding_date;
            $father_interests = $request->father_interests;
            // Insert data into Father table in DB
            $new_father = Student_father_profile::create([
                'father_name' => $father_name,
                'father_dob' => $father_dob,
                'father_nationality' => $father_nationality,
                'father_national_number' => $father_national_number,
                'father_degree_of_kinship' => $father_degree_of_kinship,
                'father_address' => $father_address,
                'father_city' => $father_city,
                'father_state' => $father_state,
                'father_country' => $father_country,
                'father_landmark' => $father_landmark,
                'father_job' => $father_job,
                'father_image' => $father_image,
                'father_email' => $father_email,
                'father_marital_status' => $father_marital_status,
                'father_phone' => $father_phone,
                'father_alternative_phone' => $father_alternative_phone,
                'father_fb_link' => $father_fb_link,
                'father_twitter_link' => $father_twitter_link,
                'father_social_media_1' => $father_social_media_1,
                'father_social_media_2' => $father_social_media_2,
                'father_qualification' => $father_qualification,
                'father_qualification_other' => $father_qualification_other,
                'father_wedding_date' => $father_wedding_date,
                'father_interests' => $father_interests,
                'father_created_by' => $created_by
            ]);
            $father_id = $new_father->id;
        }

        // Mother Info
        // Check if selected from exsit Mothers data or new Mother
        if ($request->mother_id != null) {
            
            $request->validate([
                'mother_id'=>'required|exists:student_mother_profiles,id',
            ]);

            $mother_id = $request->mother_id;

        }else{

            $request->validate([
                // Mother Info
                'mother_name'=>'required|string',
                'mother_dob'=>'nullable|date',
                'mother_nationality'=>'required|string',
                'mother_national_number'=>'required|string|unique:student_mother_profiles,mother_national_number',
                'mother_degree_of_kinship'=>'nullable|string',
                'mother_address'=>'nullable|string',
                'mother_city'=>'nullable|string',
                'mother_state'=>'nullable|string',
                'mother_country'=>'nullable|string',
                'mother_landmark'=>'nullable|string',
                'mother_job'=>'nullable|string',
                'mother_image'=>'nullable|image|mimes:jpg,jpeg,png',
                'mother_email'=>'required|string|email|unique:student_mother_profiles,mother_email',
                'mother_marital_status'=>'nullable|string',
                'mother_phone'=>'nullable|string',
                'mother_alternative_phone'=>'nullable|string',
                'mother_fb_link'=>'nullable|url',
                'mother_twitter_link'=>'nullable|url',
                'mother_social_media_1'=>'nullable|url',
                'mother_social_media_2'=>'nullable|url',
                'mother_qualification'=>'nullable|string',
                'mother_qualification_other'=>'nullable|string',
                'mother_wedding_date'=>'nullable|string',
                'mother_interests'=>'nullable|string',
                'mother_pregnancy_number'=>'nullable|string',
                'mother_miscarriages_number'=>'nullable|string'
            ]);
                // Check if user upload Mother image or no 
            if ($request->hasFile('mother_image')) {
                // Rename image and save it in case of image has been uploaded
                $mother_img = $request->mother_image ;
                $mother_ext = $mother_img->getClientOriginalExtension();
                $mother_imageName = "mother-" . uniqid() . ".$mother_ext";
                $mother_img->move( public_path('uploads') , $mother_imageName);

            } else {
                // If user doesn't upload image
                $mother_imageName = null;
            }

            $mother_name = $request->mother_name;
            $mother_dob = $request->mother_dob;
            $mother_nationality = $request->mother_nationality;
            $mother_national_number = $request->mother_national_number;
            $mother_degree_of_kinship = $request->mother_degree_of_kinship;
            $mother_address = $request->mother_address;
            $mother_city = $request->mother_city;
            $mother_state = $request->mother_state;
            $mother_country = $request->mother_country;
            $mother_landmark = $request->mother_landmark;
            $mother_job = $request->mother_job;
            $mother_image = $mother_imageName;
            $mother_email = $request->mother_email;
            $mother_marital_status = $request->mother_marital_status;
            $mother_phone = $request->mother_phone;
            $mother_alternative_phone = $request->mother_alternative_phone;
            $mother_fb_link = $request->mother_fb_link;
            $mother_twitter_link = $request->mother_twitter_link;
            $mother_social_media_1 = $request->mother_social_media_1;
            $mother_social_media_2 = $request->mother_social_media_2;
            $mother_qualification = $request->mother_qualification;
            $mother_qualification_other = $request->mother_qualification_other;
            $mother_wedding_date = $request->mother_wedding_date;
            $mother_interests = $request->mother_interests;
            $mother_pregnancy_number = $request->mother_pregnancy_number;
            $mother_miscarriages_number = $request->mother_miscarriages_number;

            // Insert data into Mother table in DB
            $new_mother = Student_mother_profile::create([
                'mother_name' => $mother_name,
                'mother_dob' => $mother_dob,
                'mother_nationality' => $mother_nationality,
                'mother_national_number' => $mother_national_number,
                'mother_degree_of_kinship' => $mother_degree_of_kinship,
                'mother_address' => $mother_address,
                'mother_city' => $mother_city,
                'mother_state' => $mother_state,
                'mother_country' => $mother_country,
                'mother_landmark' => $mother_landmark,
                'mother_job' => $mother_job,
                'mother_image' => $mother_image,
                'mother_email' => $mother_email,
                'mother_marital_status' => $mother_marital_status,
                'mother_phone' => $mother_phone,
                'mother_alternative_phone' => $mother_alternative_phone,
                'mother_fb_link' => $mother_fb_link,
                'mother_twitter_link' => $mother_twitter_link,
                'mother_social_media_1' => $mother_social_media_1,
                'mother_social_media_2' => $mother_social_media_2,
                'mother_qualification' => $mother_qualification,
                'mother_qualification_other' => $mother_qualification_other,
                'mother_wedding_date' => $mother_wedding_date,
                'mother_interests' => $mother_interests,
                'mother_pregnancy_number' => $mother_pregnancy_number,
                'mother_miscarriages_number' => $mother_miscarriages_number,
                'mother_created_by' => $created_by
            ]);
            $mother_id = $new_mother->id;
        }

        // Superior Info
        // If there's superior or no
        if ($request->are_Superior == "Yes") {
            // Check if selected from exsit Superior data or new Superior
            if ($request->superior_id != null) {
                
                $request->validate([
                    'superior_id'=>'required|exists:student_superior_profiles,id',
                    'are_Superior'=>'required|string',
                ]);
                
                $superior = $request->are_Superior;
                $superior_id = $request->superior_id;

            }else{

                $request->validate([
                    // Superior Info
                    'are_Superior'=>'required|string',
                    'superior_name'=>'required|string',
                    'superior_dob'=>'nullable|date',
                    'superior_nationality'=>'required|string',
                    'superior_national_number'=>'required|string|unique:student_superior_profiles,superior_national_number',
                    'superior_degree_of_kinship'=>'nullable|string',
                    'superior_address'=>'nullable|string',
                    'superior_city'=>'nullable|string',
                    'superior_state'=>'nullable|string',
                    'superior_country'=>'nullable|string',
                    'superior_landmark'=>'nullable|string',
                    'superior_job'=>'nullable|string',
                    'superior_gender'=>'nullable|string',
                    'superior_image'=>'nullable|image|mimes:jpg,jpeg,png',
                    'superior_email'=>'required|string|email|unique:student_superior_profiles,superior_email',
                    'superior_marital_status'=>'nullable|string',
                    'superior_phone'=>'nullable|string',
                    'superior_alternative_phone'=>'nullable|string',
                    'superior_fb_link'=>'nullable|url',
                    'superior_twitter_link'=>'nullable|url',
                    'superior_social_media_1'=>'nullable|url',
                    'superior_social_media_2'=>'nullable|url',
                    'superior_qualification'=>'nullable|string',
                    'superior_qualification_other'=>'nullable|string',
                    'superior_wedding_date'=>'nullable|string',
                    'superior_interests'=>'nullable|string',
                ]);
                // Check if user upload Superior image or no 
                if ($request->hasFile('superior_image')) {
                    // Rename image and save it in case of image has been uploaded
                    $superior_img = $request->superior_image ;
                    $superior_ext = $superior_img->getClientOriginalExtension();
                    $superior_imageName = "superior-" . uniqid() . ".$superior_ext";
                    $superior_img->move( public_path('uploads') , $superior_imageName);

                } else {
                    // If user doesn't upload image
                    $superior_imageName = null;
                }

                $superior_name = $request->superior_name;
                $superior_dob = $request->superior_dob;
                $superior_nationality = $request->superior_nationality;
                $superior_national_number = $request->superior_national_number;
                $superior_degree_of_kinship = $request->superior_degree_of_kinship;
                $superior_address = $request->superior_address;
                $superior_city = $request->superior_city;
                $superior_state = $request->superior_state;
                $superior_country = $request->superior_country;
                $superior_landmark = $request->superior_landmark;
                $superior_job = $request->superior_job;
                $superior_gender = $request->superior_gender;
                $superior_image = $imageName;
                $superior_email = $request->superior_email;
                $superior_marital_status = $request->superior_marital_status;
                $superior_phone = $request->superior_phone;
                $superior_alternative_phone = $request->superior_alternative_phone;
                $superior_fb_link = $request->superior_fb_link;
                $superior_twitter_link = $request->superior_twitter_link;
                $superior_social_media_1 = $request->superior_social_media_1;
                $superior_social_media_2 = $request->superior_social_media_2;
                $superior_qualification = $request->superior_qualification;
                $superior_qualification_other = $request->superior_qualification_other;
                $superior_wedding_date = $request->superior_wedding_date;
                $superior_interests = $request->superior_interests;

                // Insert data into Superior table in DB
                $new_superior = Student_superior_profile::create([
                    'superior_name' => $superior_name,
                    'superior_dob' => $superior_dob,
                    'superior_nationality' => $superior_nationality,
                    'superior_national_number' => $superior_national_number,
                    'superior_degree_of_kinship' => $superior_degree_of_kinship,
                    'superior_address' => $superior_address,
                    'superior_city' => $superior_city,
                    'superior_state' => $superior_state,
                    'superior_country' => $superior_country,
                    'superior_landmark' => $superior_landmark,
                    'superior_job' => $superior_job,
                    'superior_gender' => $superior_gender,
                    'superior_image' => $superior_image,
                    'superior_email' => $superior_email,
                    'superior_marital_status' => $superior_marital_status,
                    'superior_phone' => $superior_phone,
                    'superior_alternative_phone' => $superior_alternative_phone,
                    'superior_fb_link' => $superior_fb_link,
                    'superior_twitter_link' => $superior_twitter_link,
                    'superior_social_media_1' => $superior_social_media_1,
                    'superior_social_media_2' => $superior_social_media_2,
                    'superior_qualification' => $superior_qualification,
                    'superior_qualification_other' => $superior_qualification_other,
                    'superior_wedding_date' => $superior_wedding_date,
                    'superior_interests' => $superior_interests,
                    'superior_created_by' => $created_by
                ]);

                $superior = $request->are_Superior;
                $superior_id = $new_superior->id;
            }
            
        }else {   
            $superior = $request->are_Superior;
            $superior_id = null;
        }      


        // Insert data into Students table in DB
        $new_student = Student::create([
            'student_name' => $student_name,
            'birth_address' => $birth_address,
            'address' => $address,
            'city' => $city,
            'state' => $state,
            'country' => $country,
            'landmark' => $landmark,
            'home_phone' => $home_phone,
            'phone' => $phone,
            'alternative_phone' => $alternative_phone,
            'height' => $height,
            'weight' => $weight,
            'dob' => $dob,
            'gender' => $gender,
            'blood_group' => $blood_group,
            'contact_number' => $contact_number,
            'school_name' => $school_name,
            'nationality' => $nationality,
            'national_number' => $national_number,
            'image' => $image,
            'fb_link' => $fb_link,
            'twitter_link' => $twitter_link,
            'social_media_1' => $social_media_1,
            'social_media_2' => $social_media_2,
            'father_id' => $father_id,
            'mother_id' => $mother_id,
            'superior' => $superior,
            'superior_id' => $superior_id,
            'created_by' => $created_by
        ]);

        Students_group1_profile::create([
            'student_id' => $new_student->id,
            'main_complaint' => $main_complaint,
            'problem_start_at' => $problem_start_at,
            'time_of_increasing_problem_feeling' => $time_of_increasing_problem_feeling,
            'time_of_decreasing_problem_feeling' => $time_of_decreasing_problem_feeling,
            'problem_as_child_view' => $problem_as_child_view,
            'problem_as_father_view' => $problem_as_father_view,
            'problem_as_mother_view' => $problem_as_mother_view,
            'problem_reasons' => $problem_reasons,
            'student_diseases' => $student_diseases,
            'previous_treatment_efforts' => $previous_treatment_efforts,
            'genetic_diseases' => $genetic_diseases,
            'injuries_and_wounds' => $injuries_and_wounds,
            'father_age_when_applying' => $father_age_when_applying,
            'father_age_at_student_birth' => $father_age_at_student_birth,
            'father_relation_with_child' => $father_relation_with_child,
            'child_attitudes_towards_father' => $child_attitudes_towards_father,
            'mother_age_when_applying' => $mother_age_when_applying,
            'mother_age_at_student_birth' => $mother_age_at_student_birth,
            'mother_relation_with_child' => $mother_relation_with_child,
            'child_attitudes_towards_mother' => $child_attitudes_towards_mother,
            'superior_age_when_applying' => $superior_age_when_applying,
            'superior_age_at_student_birth' => $superior_age_at_student_birth,
            'superior_relation_with_child' => $superior_relation_with_child,
            'child_attitudes_towards_superior' => $child_attitudes_towards_superior,
            'relation_between_parents' => $relation_between_parents,
            'main_problems_between_parents' => $main_problems_between_parents,
            'child_attitude_towards_family_problems' => $child_attitude_towards_family_problems,
            'brothers_and_sisters' => $brothers_and_sisters,
            'brothers_and_sisters_notes' => $brothers_and_sisters_notes,
            'are_relatives' => $are_relatives,
            'other_relatives' => $other_relatives,
            'other_relatives_notes' => $other_relatives_notes,
            'economic_situation' => $economic_situation,
            'monthly_average_income' => $monthly_average_income,
            'monthly_average_expenses' => $monthly_average_expenses,
            'family_economic_problems' => $family_economic_problems,
            'family_child_acceptance' => $family_child_acceptance,
            'home_type' => $home_type,
            'no_persons_in_room' => $no_persons_in_room,
            'has_child_individual_room' => $has_child_individual_room,
            'no_father_married' => $no_father_married,
            'no_mother_married' => $no_mother_married,
            'family_divorce_cases' => $family_divorce_cases,
            'family_stress_source' => $family_stress_source,
            'family_entertainment_source' => $family_entertainment_source,
            'family_entertainment_source_child_involve' => $family_entertainment_source_child_involve,
            'psychological_social_conditions_affect_child' => $psychological_social_conditions_affect_child,
        ]);
// dd($superior_id);        
        Students_group2_profile::create([
            'student_id' => $new_student->id,
            // Organic Growth History
            'mother_diseases_during_pregnancy' => $mother_diseases_during_pregnancy,
            'mother_pregnancy_type' => $mother_pregnancy_type,
            'disturbances_during_childbirth' => $disturbances_during_childbirth,
            'mother_pregnancy_injuries' => $mother_pregnancy_injuries,
            'child_weight_at_birth' => $child_weight_at_birth,
            'breastfeeding_type' => $breastfeeding_type,
            'breastfeeding_type_note' => $breastfeeding_type_note,
            'child_age_on_weaning' => $child_age_on_weaning,
            'weaning_problems' => $weaning_problems,
            'child_age_on_first_tooth' => $child_age_on_first_tooth,
            'child_age_on_sitting' => $child_age_on_sitting,
            'child_age_on_crawls' => $child_age_on_crawls,
            'child_age_on_stand_up' => $child_age_on_stand_up,
            'child_age_on_walking' => $child_age_on_walking,
            'child_age_on_first_word' => $child_age_on_first_word,
            'child_age_on_open_door' => $child_age_on_open_door,
            'child_age_on_use_spoon' => $child_age_on_use_spoon,
            'child_age_on_adjust_output_process' => $child_age_on_adjust_output_process,
            'does_health_problems' => $does_health_problems,
            'current_health_problems' => $current_health_problems,
            'does_regularly_medicines' => $does_regularly_medicines,
            'regularly_medicines' => $regularly_medicines,
            'does_complex_disabilities' => $does_complex_disabilities,
            'complex_disabilities_other' => $complex_disabilities_other,
            'does_prosthetic_devices' => $does_prosthetic_devices,
            'prosthetic_devices' => $prosthetic_devices,
            
            // pills Psychological behavioral
            'personality_traits' => $personality_traits,
            'relation_with_friends' => $relation_with_friends,
            'relation_with_relatives' => $relation_with_relatives,
            'relation_with_neighbour' => $relation_with_neighbour,
            'relation_with_other_gender' => $relation_with_other_gender,
            'upbringing_style' => $upbringing_style,
            'reinforcements' => $reinforcements,
            'is_punishment' => $is_punishment,
            'punishment_reasons' => $punishment_reasons,
            'child_behavior_notes' => $child_behavior_notes,
            'source_of_authority' => $source_of_authority,
            'source_of_authority_notes' => $source_of_authority_notes,
            'crying' => $crying,
            'talkative' => $talkative,
            'lots_of_movement' => $lots_of_movement,
            'orderly_plan' => $orderly_plan,
            'damages' => $damages,
            'find_around_place' => $find_around_place,
            'grieves_with_specialist' => $grieves_with_specialist,
            'afraid' => $afraid,
            'enjoys' => $enjoys,
            'runs_randomly' => $runs_randomly,
            
        ]);

        Students_group3_profile::create([
            'student_id' => $new_student->id,
            // Student Group 3
            // The main neurological and behavioral symptoms
            'outbursts_of_anger' => $outbursts_of_anger,
            'outbursts_of_anger_time' => $outbursts_of_anger_time,
            'outbursts_of_anger_degree' => $outbursts_of_anger_degree,
            'finger_sucking' => $finger_sucking,
            'finger_sucking_time' => $finger_sucking_time,
            'finger_sucking_degree' => $finger_sucking_degree,
            'wetting_bed' => $wetting_bed,
            'wetting_bed_time' => $wetting_bed_time,
            'wetting_bed_degree' => $wetting_bed_degree,
            'night_screams_of_terror' => $night_screams_of_terror,
            'night_screams_of_terror_time' => $night_screams_of_terror_time,
            'night_screams_of_terror_degree' => $night_screams_of_terror_degree,
            'sleep_walking' => $sleep_walking,
            'sleep_walking_time' => $sleep_walking_time,
            'sleep_walking_degree' => $sleep_walking_degree,
            'excessive_fears' => $excessive_fears,
            'excessive_fears_time' => $excessive_fears_time,
            'excessive_fears_degree' => $excessive_fears_degree,
            'nervous_crises' => $nervous_crises,
            'nervous_crises_time' => $nervous_crises_time,
            'nervous_crises_degree' => $nervous_crises_degree,
            'cramps' => $cramps,
            'cramps_time' => $cramps_time,
            'cramps_degree' => $cramps_degree,
            'biting_nails' => $biting_nails,
            'biting_nails_time' => $biting_nails_time,
            'biting_nails_degree' => $biting_nails_degree,
            'smash_clothes' => $smash_clothes,
            'smash_clothes_time' => $smash_clothes_time,
            'smash_clothes_degree' => $smash_clothes_degree,
            'stereotyped_movements' => $stereotyped_movements,
            'stereotyped_movements_time' => $stereotyped_movements_time,
            'stereotyped_movements_degree' => $stereotyped_movements_degree,
            'baby_gets_nervous_from_loud_noises' => $baby_gets_nervous_from_loud_noises,
            'baby_gets_nervous_from_loud_noises_time' => $baby_gets_nervous_from_loud_noises_time,
            'baby_gets_nervous_from_loud_noises_degree' => $baby_gets_nervous_from_loud_noises_degree,
            'baby_gets_nervous_from_bright_lights' => $baby_gets_nervous_from_bright_lights,
            'baby_gets_nervous_from_bright_lights_time' => $baby_gets_nervous_from_bright_lights_time,
            'baby_gets_nervous_from_bright_lights_degree' => $baby_gets_nervous_from_bright_lights_degree,
            'sexual_behaviors' => $sexual_behaviors,
            'sexual_behaviors_time' => $sexual_behaviors_time,
            'sexual_behaviors_degree' => $sexual_behaviors_degree,
            'epileptic_seizures' => $epileptic_seizures,
            'epileptic_seizures_time' => $epileptic_seizures_time,
            'epileptic_seizures_degree' => $epileptic_seizures_degree,
            'difficulty_interacting_with_peers' => $difficulty_interacting_with_peers,
            'difficulty_interacting_with_peers_desc' => $difficulty_interacting_with_peers_desc,
            'extra_activity' => $extra_activity,
            'extra_activity_desc' => $extra_activity_desc,
            'make_fun_of_others' => $make_fun_of_others,
            'make_fun_of_others_desc' => $make_fun_of_others_desc,
            'can_not_wait' => $can_not_wait,
            'can_not_wait_desc' => $can_not_wait_desc,
            'curses_and_says_inappropriate_words' => $curses_and_says_inappropriate_words,
            'curses_and_says_inappropriate_words_desc' => $curses_and_says_inappropriate_words_desc,
            'acts_inappropriately' => $acts_inappropriately,
            'acts_inappropriately_desc' => $acts_inappropriately_desc,
            'very_shy' => $very_shy,
            'very_shy_desc' => $very_shy_desc,
            'speaks_low_voice' => $speaks_low_voice,
            'speaks_low_voice_desc' => $speaks_low_voice_desc,
            'not_defend_himself' => $not_defend_himself,
            'not_defend_himself_desc' => $not_defend_himself_desc,
            'afraid_of_animals' => $afraid_of_animals,
            'afraid_of_animals_desc' => $afraid_of_animals_desc,
            'hesitant_and_confused' => $hesitant_and_confused,
            'hesitant_and_confused_desc' => $hesitant_and_confused_desc,
            'feeling_powerless_and_lacking_in_self_confidence' => $feeling_powerless_and_lacking_in_self_confidence,
            'feeling_powerless_and_lacking_in_self_confidence_desc' => $feeling_powerless_and_lacking_in_self_confidence_desc,
            'feeling_tense_and_refuses_to_hug' => $feeling_tense_and_refuses_to_hug,
            'feeling_tense_and_refuses_to_hug_desc' => $feeling_tense_and_refuses_to_hug_desc,
            'other_social_problems' => $other_social_problems,

        ]);

        Students_group4_profile::create([
            'student_id' => $new_student->id,
            // Student Group 4
            // Psychological Examination
            'last_psychological_examination_name' => $last_psychological_examination_name,
            'last_psychological_examination_date' => $last_psychological_examination_date,
            'previous_mental_disorders' => $previous_mental_disorders,
            'first_intelligence_and_ability_test_name' => $first_intelligence_and_ability_test_name,
            'first_intelligence_and_ability_test_date' => $first_intelligence_and_ability_test_date,
            'first_intelligence_and_ability_test_reason' => $first_intelligence_and_ability_test_reason,
            'first_intelligence_and_ability_test_result' => $first_intelligence_and_ability_test_result,
            'first_intelligence_and_ability_test_who_recommended_it' => $first_intelligence_and_ability_test_who_recommended_it,
            'first_intelligence_and_ability_test_explan' => $first_intelligence_and_ability_test_explan,
            'first_intelligence_and_ability_test_recommendations' => $first_intelligence_and_ability_test_recommendations,
            'second_intelligence_and_ability_test_name' => $second_intelligence_and_ability_test_name,
            'second_intelligence_and_ability_test_date' => $second_intelligence_and_ability_test_date,
            'second_intelligence_and_ability_test_reason' => $second_intelligence_and_ability_test_reason,
            'second_intelligence_and_ability_test_result' => $second_intelligence_and_ability_test_result,
            'second_intelligence_and_ability_test_who_recommended_it' => $second_intelligence_and_ability_test_who_recommended_it,
            'second_intelligence_and_ability_test_explan' => $second_intelligence_and_ability_test_explan,
            'second_intelligence_and_ability_test_recommendations' => $second_intelligence_and_ability_test_recommendations,
            'third_intelligence_and_ability_test_name' => $third_intelligence_and_ability_test_name,
            'third_intelligence_and_ability_test_date' => $third_intelligence_and_ability_test_date,
            'third_intelligence_and_ability_test_reason' => $third_intelligence_and_ability_test_reason,
            'third_intelligence_and_ability_test_result' => $third_intelligence_and_ability_test_result,
            'third_intelligence_and_ability_test_who_recommended_it' => $third_intelligence_and_ability_test_who_recommended_it,
            'third_intelligence_and_ability_test_explan' => $third_intelligence_and_ability_test_explan,
            'third_intelligence_and_ability_test_recommendations' => $third_intelligence_and_ability_test_recommendations,
            'fourth_intelligence_and_ability_test_name' => $fourth_intelligence_and_ability_test_name,
            'fourth_intelligence_and_ability_test_date' => $fourth_intelligence_and_ability_test_date,
            'fourth_intelligence_and_ability_test_reason' => $fourth_intelligence_and_ability_test_reason,
            'fourth_intelligence_and_ability_test_result' => $fourth_intelligence_and_ability_test_result,
            'fourth_intelligence_and_ability_test_who_recommended_it' => $fourth_intelligence_and_ability_test_who_recommended_it,
            'fourth_intelligence_and_ability_test_explan' => $fourth_intelligence_and_ability_test_explan,
            'fourth_intelligence_and_ability_test_recommendations' => $fourth_intelligence_and_ability_test_recommendations,
            'eats_alone_without_help' => $eats_alone_without_help,
            'gets_dressed_without_help' => $gets_dressed_without_help,
            'asking_to_go_to_the_bathroom' => $asking_to_go_to_the_bathroom,
            'takes_care_of_himself_in_bathroom' => $takes_care_of_himself_in_bathroom,
            'use_of_yelling_to_express' => $use_of_yelling_to_express,
            'pay_attention_to_sounds' => $pay_attention_to_sounds,
            'distinguish_mother_and_father_voice' => $distinguish_mother_and_father_voice,
            'distinguish_family_members_voice' => $distinguish_family_members_voice,
            'using_audio_clips' => $using_audio_clips,
            'pronounces_word_understandable' => $pronounces_word_understandable,
            'turns_around_when_he_hears_his_name' => $turns_around_when_he_hears_his_name,
            'looking_the_person_speaking_during_conversation' => $looking_the_person_speaking_during_conversation,
            'uses_two_words_sentence' => $uses_two_words_sentence,
            'needs_encouragement_to_speak' => $needs_encouragement_to_speak,
            'uses_expressive_language_to_express_his_needs' => $uses_expressive_language_to_express_his_needs,
            'stutters_while_speaking' => $stutters_while_speaking,
            'remove_letters_from_words' => $remove_letters_from_words,
            'add_letters_to_words' => $add_letters_to_words,
            'turns_some_letters_in_word' => $turns_some_letters_in_word,
            'changes_some_letters_when_saying_word' => $changes_some_letters_when_saying_word,
            'speaks_but_the_words_are_distorted_and_incomprehensible' => $speaks_but_the_words_are_distorted_and_incomprehensible,
            'understands_what_is_asked_of_him' => $understands_what_is_asked_of_him,
            'language_level' => $language_level,
            'level_of_expression_of_his_needs_linguistically' => $level_of_expression_of_his_needs_linguistically,
            'level_of_coherence_of_ideas' => $level_of_coherence_of_ideas,
            'speed_level' => $speed_level,
            'response' => $response,

        ]);
        return redirect(route('allStudents'))->with('message', "New Student has been created");

    }

    // Take Student Assignment
    public function take_assignment($studentId)
    {
        $assignments = Assignment::select('id' , 'assignment_title' , 'assignment_shortname')->get();
        $student = Student::find($studentId);
        // dd($assignments);
        return view('students.take_assignment', [
            'assignments' => $assignments,
            'student' => $student
        ]);
    }

    // Create Student Assignment
    public function create_assignment(Request $request)
    {
        // dd( $request);
        $assignment = explode('|',$request->assignment);
        $assignmentId = $assignment[0];
        $assignment_shortname = $assignment[1];
        $studentId = $request->studentId;
        $assignmentInformation = $request->assignmentInformation;
        $assignment = Assignment::find($assignmentId);

        // dd(json_decode($assignment->assignment_questions));
        $assignment_question_ids = json_decode($assignment->assignment_questions);
        $assignment_questions = Question::whereIn('id', $assignment_question_ids)->get();
        // dd($assignment_questions);

        // foreach ($assignment->assignment_structure as $assignment_structure) {
        //     dd("hello");
        //     dd($assignment_structure);
        //     }


        $student_dob = Student::select('dob')
            ->find($studentId);
            // dd( $assignment_shortname);
            $student_contation = ''.json_decode($assignment->assignment_condition)->condation.''.\Carbon\Carbon::parse($student_dob->dob)->diff(\Carbon\Carbon::now())->format('%y');
            

        // dd( $student_contation);
        
        // dd($assignment->assignment_condition);
        
        // dd($assignment_shortname);
        return view('students.create_assignment', [
            'assignment_id' => $assignmentId,
            'assignment_shortname' => $assignment_shortname,
            'student_id' => $studentId,
            'assignment_informations' => $assignmentInformation,
            'assignment' => $assignment,
            'assignment_questions' => $assignment_questions,
            'student_contation'=>$student_contation,
            'alert'=>json_decode($assignment->assignment_condition)->alert_message
        ]);
    }

    
    // Store data to Submission table at DB
    public function store_assignment(Request $request)
    {       
        // Make validation on entered data 
        $request->validate([
            'assignment_id'=>'required|integer',
            'assignment_shortname'=>'required|string',
            'student_id'=>'required|integer',
            'assignment_information_provider'=>'required|array',
            'assignment_data'=>'required|string', 
            'final_report'=>'nullable|string', 
        ]);
        // dd($request);
        

        $assignment_id = $request->assignment_id;
        $assignment_shortname = $request->assignment_shortname;
        $student_id = $request->student_id;
        $assignment_information_provider = json_encode($request->assignment_information_provider);
        $assignment_data = $request->assignment_data;
        $final_report = $request->final_report;
        $trainer_id = 1;
        $business_id = 1;


        // Insert data into Submission table in DB
        Submission::create([
            'assignment_id' => $assignment_id,
            'assignment_shortname' => $assignment_shortname,
            'student_id' => $student_id,
            'assignment_information_provider' => $assignment_information_provider,
            'answer' => $assignment_data,
            'final_report' => $final_report,
            'business_id' => $business_id,
            'trainer_id' => $trainer_id,

        ]);

            return redirect(route('allStudents'))->with('message', "New Submission has been created");
    }


    // Taken Student Assignments 
    public function taken_assignment($id)
    {
        $taken_assignments = Submission::orderBy('id', 'desc')
            ->where("student_id" , "=" , $id)
            ->get();
            // ->find($id);
        // dd($taken_assignments);
        return view('students.taken_assignments', [
            'taken_assignments' => $taken_assignments
        ]);
    }

}
