<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\Student_father_profile;
use Illuminate\Http\Request;

class StudentFatherProfileController extends Controller
{
    // Show list of Fathers in descenting according to ID with pagination
    public function list(){
        $student_father_profiles = Student_father_profile::select('id' , 'father_name' , 'father_nationality' , 'father_phone' , 'father_email' , 'father_image' , 'father_created_by')
        ->orderBy('id', 'desc')
        // ->paginate(1);
        ->get();
        return view('fathers.list' , [
            'student_father_profiles' => $student_father_profiles
        ]);
    }
    
    // View specific Father
    public function view($id){
        
        $student_father_profile =Student_father_profile::find($id);
        $students = Student::select('id' , 'student_name' , 'phone', 'gender' , 'dob' )
        ->where('father_id' , '=' , $id)
        ->get();
        return view('fathers.view' , [
            'student_father_profile' => $student_father_profile,
            'students' => $students
        ]);
    }
    
    // Search in Fathers
    public function search($word){
        
        $student_father_profiles = Student_father_profile::select('id' , 'father_name' , 'father_nationality' , 'father_phone' , 'father_email' , 'father_image' , 'father_created_by')
        ->where('father_name', 'like' , '%'.$word.'%')
        // ->paginate(25);
        ->get();
        return view('fathers.search' , [
            'student_father_profiles' => $student_father_profiles
        ]);
    }
   
    // Create Father
    public function create(){
        return view('fathers.create');
    }


    // Store data to Trainer table at DB
    public function store(Request $request){
        // Make validation on entered data 
        $request->validate([
            'father_name'=>'required|string',
            'father_dob'=>'nullable|date',
            'father_nationality'=>'nullable|string',
            'father_national_number'=>'nullable|string|unique:student_father_profiles,father_national_number',
            'father_degree_of_kinship'=>'nullable|string',
            'father_address'=>'nullable|string',
            'father_city'=>'nullable|string',
            'father_state'=>'nullable|string',
            'father_country'=>'nullable|string',
            'father_landmark'=>'nullable|string',
            'father_job'=>'nullable|string',
            'father_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'father_email'=>'required|string|email|unique:student_father_profiles,father_email',
            'father_marital_status'=>'nullable|string',
            'father_phone'=>'nullable|string',
            'father_alternative_phone'=>'nullable|string',
            'father_fb_link'=>'nullable|url',
            'father_twitter_link'=>'nullable|url',
            'father_social_media_1'=>'nullable|url',
            'father_social_media_2'=>'nullable|url',
            'father_qualification'=>'nullable|string',
            'father_qualification_other'=>'nullable|string',
            'father_wedding_date'=>'nullable|string',
            'father_interests'=>'nullable|string',
            'father_age_at_student_birth'=>'nullable|string',
            'father_relation_with_child'=>'nullable|string',
            'father_attitudes_towards_parent'=>'nullable|string'

        ]);
        
        // Check if user upload image or no 
        if ($request->hasFile('father_image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->father_image ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "father-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        $father_name = $request->father_name;
        $father_dob = $request->father_dob;
        $father_nationality = $request->father_nationality;
        $father_national_number = $request->father_national_number;
        $father_degree_of_kinship = $request->father_degree_of_kinship;
        $father_address = $request->father_address;
        $father_city = $request->father_city;
        $father_state = $request->father_state;
        $father_country = $request->father_country;
        $father_landmark = $request->father_landmark;
        $father_job = $request->father_job;
        $father_image = $imageName;
        $father_email = $request->father_email;
        $father_marital_status = $request->father_marital_status;
        $father_phone = $request->father_phone;
        $father_alternative_phone = $request->father_alternative_phone;
        $father_fb_link = $request->father_fb_link;
        $father_twitter_link = $request->father_twitter_link;
        $father_social_media_1 = $request->father_social_media_1;
        $father_social_media_2 = $request->father_social_media_2;
        $father_qualification = $request->father_qualification;
        $father_qualification_other = $request->father_qualification_other;
        $father_wedding_date = $request->father_wedding_date;
        $father_interests = $request->father_interests;
        $father_age_at_student_birth = $request->father_age_at_student_birth;
        $father_relation_with_child = $request->father_relation_with_child;
        $father_attitudes_towards_parent = $request->father_attitudes_towards_parent;
        $created_by = 1;
        
        // Insert data into Father table in DB
        Student_father_profile::create([
            'father_name' => $father_name,
            'father_dob' => $father_dob,
            'father_nationality' => $father_nationality,
            'father_national_number' => $father_national_number,
            'father_degree_of_kinship' => $father_degree_of_kinship,
            'father_address' => $father_address,
            'father_city' => $father_city,
            'father_state' => $father_state,
            'father_country' => $father_country,
            'father_landmark' => $father_landmark,
            'father_job' => $father_job,
            'father_image' => $father_image,
            'father_email' => $father_email,
            'father_marital_status' => $father_marital_status,
            'father_phone' => $father_phone,
            'father_alternative_phone' => $father_alternative_phone,
            'father_fb_link' => $father_fb_link,
            'father_twitter_link' => $father_twitter_link,
            'father_social_media_1' => $father_social_media_1,
            'father_social_media_2' => $father_social_media_2,
            'father_qualification' => $father_qualification,
            'father_qualification_other' => $father_qualification_other,
            'father_wedding_date' => $father_wedding_date,
            'father_interests' => $father_interests,
            'father_age_at_student_birth' => $father_age_at_student_birth,
            'father_relation_with_child' => $father_relation_with_child,
            'father_attitudes_towards_parent' => $father_attitudes_towards_parent,
            'father_created_by' => $created_by
        ]);

        return redirect( route('allFathers') )->with('message',"New Trainer has been created");
        
    }

    // Edit specifi Father Data
    // get this specific Father data and return it at the form
    public function edit($id){
        $student_father_profile =Student_father_profile::find($id);
        
        return view('fathers.edit', [
            'student_father_profile' => $student_father_profile
        ]);
    }
   
    public function update(Request $request , $id){
        
        $student_father_profile = Student_father_profile::find($id);
        $request->validate([
            'father_name'=>'required|string',
            'father_dob'=>'nullable|date',
            'father_nationality'=>'nullable|string',
            'father_national_number'=>'nullable|string',
            'father_degree_of_kinship'=>'nullable|string',
            'father_address'=>'nullable|string',
            'father_city'=>'nullable|string',
            'father_state'=>'nullable|string',
            'father_country'=>'nullable|string',
            'father_landmark'=>'nullable|string',
            'father_job'=>'nullable|string',
            'father_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'father_email'=>'required|string|email|unique:student_father_profiles,father_email,'.$student_father_profile->id,
            'father_marital_status'=>'nullable|string',
            'father_phone'=>'nullable|string',
            'father_alternative_phone'=>'nullable|string',
            'father_fb_link'=>'nullable|url',
            'father_twitter_link'=>'nullable|url',
            'father_social_media_1'=>'nullable|url',
            'father_social_media_2'=>'nullable|url',
            'father_qualification'=>'nullable|string',
            'father_qualification_other'=>'nullable|string',
            'father_wedding_date'=>'nullable|string',
            'father_interests'=>'nullable|string',
            'father_age_at_student_birth'=>'nullable|string',
            'father_relation_with_child'=>'nullable|string',
            'father_attitudes_towards_parent'=>'nullable|string'
        ]);
        
        if ($request->hasFile('father_image')) {
            
            if ( $student_father_profile->father_image !== null) {
                $old_image = $student_father_profile->father_image;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->father_image ;
            $ext = $image->getClientOriginalExtension();
            $newImageName = "father-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $imageName = $newImageName;
        }
        else
        {
            $imageName = $student_father_profile->father_image;
        }

        $father_name = $request->father_name;
        $father_dob = $request->father_dob;
        $father_nationality = $request->father_nationality;
        $father_national_number = $request->father_national_number;
        $father_degree_of_kinship = $request->father_degree_of_kinship;
        $father_address = $request->father_address;
        $father_city = $request->father_city;
        $father_state = $request->father_state;
        $father_country = $request->father_country;
        $father_landmark = $request->father_landmark;
        $father_job = $request->father_job;
        $father_image = $imageName;
        $father_email = $request->father_email;
        $father_marital_status = $request->father_marital_status;
        $father_phone = $request->father_phone;
        $father_alternative_phone = $request->father_alternative_phone;
        $father_fb_link = $request->father_fb_link;
        $father_twitter_link = $request->father_twitter_link;
        $father_social_media_1 = $request->father_social_media_1;
        $father_social_media_2 = $request->father_social_media_2;
        $father_qualification = $request->father_qualification;
        $father_qualification_other = $request->father_qualification_other;
        $father_wedding_date = $request->father_wedding_date;
        $father_interests = $request->father_interests;
        $father_age_at_student_birth = $request->father_age_at_student_birth;
        $father_relation_with_child = $request->father_relation_with_child;
        $father_attitudes_towards_parent = $request->father_attitudes_towards_parent;
        

        $student_father_profile->update([
            'father_name' => $father_name,
            'father_dob' => $father_dob,
            'father_nationality' => $father_nationality,
            'father_national_number' => $father_national_number,
            'father_degree_of_kinship' => $father_degree_of_kinship,
            'father_address' => $father_address,
            'father_city' => $father_city,
            'father_state' => $father_state,
            'father_country' => $father_country,
            'father_landmark' => $father_landmark,
            'father_job' => $father_job,
            'father_image' => $father_image,
            'father_email' => $father_email,
            'father_marital_status' => $father_marital_status,
            'father_phone' => $father_phone,
            'father_alternative_phone' => $father_alternative_phone,
            'father_fb_link' => $father_fb_link,
            'father_twitter_link' => $father_twitter_link,
            'father_social_media_1' => $father_social_media_1,
            'father_social_media_2' => $father_social_media_2,
            'father_qualification' => $father_qualification,
            'father_qualification_other' => $father_qualification_other,
            'father_wedding_date' => $father_wedding_date,
            'father_interests' => $father_interests,
            'father_age_at_student_birth' => $father_age_at_student_birth,
            'father_relation_with_child' => $father_relation_with_child,
            'father_attitudes_towards_parent' => $father_attitudes_towards_parent,
        ]);

        return redirect( route('allFathers') )->with('message',"Father data has been updated succesffuly");
    }

 
    public function delete($id){
        $deleted_by = 1;   // will use user
        $student_father_profile = Student_father_profile::find($id);
        $student_father_profile -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $student_father_profile -> delete();


        return redirect( route('allFathers') )->with('message',"Trainer data has been deleted succesffuly");
    }

}
