<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\Student_mother_profile;
use Illuminate\Http\Request;

class StudentMotherProfileController extends Controller
{
    // Show list of Mothers in descenting according to ID with pagination
    public function list(){
        $student_mother_profiles = Student_mother_profile::select('id' , 'mother_name' , 'mother_nationality' , 'mother_phone' , 'mother_email' , 'mother_image' , 'mother_created_by')
        ->orderBy('id', 'desc')
        // ->paginate(1);
        ->get();
        return view('mothers.list' , [
            'student_mother_profiles' => $student_mother_profiles
        ]);
    }
    
    // View specific Mother
    public function view($id){
        
        $student_mother_profile =Student_mother_profile::find($id);
        $students = Student::select('id' , 'student_name' , 'phone', 'gender' , 'dob' )
        ->where('mother_id' , '=' , $id)
        ->get();
        return view('mothers.view' , [
            'student_mother_profile' => $student_mother_profile,
            'students' => $students
        ]);
    }
    
    // Search in Mothers
    public function search($word){
        
        $student_mother_profiles = Student_mother_profile::select('id' , 'mother_name' , 'mother_nationality' , 'mother_phone' , 'mother_email' , 'mother_image' , 'mother_created_by')
        ->where('mother_name', 'like' , '%'.$word.'%')
        // ->paginate(25);
        ->get();
        return view('mothers.search' , [
            'student_mother_profiles' => $student_mother_profiles
        ]);
    }
    
    // Create Mother
    public function create(){
        return view('mothers.create');
    }


    // Store data to Mother table at DB
    public function store(Request $request){
        // Make validation on entered data 
        $request->validate([
            'mother_name'=>'required|string',
            'mother_dob'=>'nullable|date',
            'mother_nationality'=>'required|string',
            'mother_national_number'=>'required|string|unique:student_mother_profiles,mother_national_number',
            'mother_degree_of_kinship'=>'nullable|string',
            'mother_address'=>'nullable|string',
            'mother_city'=>'nullable|string',
            'mother_state'=>'nullable|string',
            'mother_country'=>'nullable|string',
            'mother_landmark'=>'nullable|string',
            'mother_job'=>'nullable|string',
            'mother_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'mother_email'=>'required|string|email|unique:student_mother_profiles,email',
            'mother_marital_status'=>'nullable|string',
            'mother_phone'=>'nullable|string',
            'mother_alternative_phone'=>'nullable|string',
            'mother_fb_link'=>'nullable|url',
            'mother_twitter_link'=>'nullable|url',
            'mother_social_media_1'=>'nullable|url',
            'mother_social_media_2'=>'nullable|url',
            'mother_qualification'=>'nullable|string',
            'mother_qualification_other'=>'nullable|string',
            'mother_wedding_date'=>'nullable|string',
            'mother_interests'=>'nullable|string',
            'mother_pregnancy_number'=>'nullable|string',
            'mother_miscarriages_number'=>'nullable|string'
        ]);
        
        // Check if user upload Mother image or no 
        if ($request->hasFile('mother_image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->mother_image ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "mother-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        $mother_name = $request->mother_name;
        $mother_dob = $request->mother_dob;
        $mother_nationality = $request->mother_nationality;
        $mother_national_number = $request->mother_national_number;
        $mother_degree_of_kinship = $request->mother_degree_of_kinship;
        $mother_address = $request->mother_address;
        $mother_city = $request->mother_city;
        $mother_state = $request->mother_state;
        $mother_country = $request->mother_country;
        $mother_landmark = $request->mother_landmark;
        $mother_job = $request->mother_job;
        $mother_image = $imageName;
        $mother_email = $request->mother_email;
        $mother_marital_status = $request->mother_marital_status;
        $mother_phone = $request->mother_phone;
        $mother_alternative_phone = $request->mother_alternative_phone;
        $mother_fb_link = $request->mother_fb_link;
        $mother_twitter_link = $request->mother_twitter_link;
        $mother_social_media_1 = $request->mother_social_media_1;
        $mother_social_media_2 = $request->mother_social_media_2;
        $mother_qualification = $request->mother_qualification;
        $mother_qualification_other = $request->mother_qualification_other;
        $mother_wedding_date = $request->mother_wedding_date;
        $mother_interests = $request->mother_interests;
        $mother_pregnancy_number = $request->mother_pregnancy_number;
        $mother_miscarriages_number = $request->mother_miscarriages_number;
        $created_by = 1;
        
        // Insert data into Users table in DB
        Student_mother_profile::create([
            'mother_name' => $mother_name,
            'mother_dob' => $mother_dob,
            'mother_nationality' => $mother_nationality,
            'mother_national_number' => $mother_national_number,
            'mother_degree_of_kinship' => $mother_degree_of_kinship,
            'mother_address' => $mother_address,
            'mother_city' => $mother_city,
            'mother_state' => $mother_state,
            'mother_country' => $mother_country,
            'mother_landmark' => $mother_landmark,
            'mother_job' => $mother_job,
            'mother_image' => $mother_image,
            'mother_email' => $mother_email,
            'mother_marital_status' => $mother_marital_status,
            'mother_phone' => $mother_phone,
            'mother_alternative_phone' => $mother_alternative_phone,
            'mother_fb_link' => $mother_fb_link,
            'mother_twitter_link' => $mother_twitter_link,
            'mother_social_media_1' => $mother_social_media_1,
            'mother_social_media_2' => $mother_social_media_2,
            'mother_qualification' => $mother_qualification,
            'mother_qualification_other' => $mother_qualification_other,
            'mother_wedding_date' => $mother_wedding_date,
            'mother_interests' => $mother_interests,
            'mother_pregnancy_number' => $mother_pregnancy_number,
            'mother_miscarriages_number' => $mother_miscarriages_number,
            'mother_created_by' => $created_by
        ]);

        return redirect( route('allMothers') )->with('message',"New Mother has been created");
        
    }

    // Edit specific Mother Data
    // get this specific Mother data and return it at the form
    public function edit($id){
        $student_mother_profile =Student_mother_profile::find($id);
        
        return view('mothers.edit', [
            'student_mother_profile' => $student_mother_profile
        ]);
    }
    
    public function update(Request $request , $id){
        
        $student_mother_profile = Student_mother_profile::find($id);
        $request->validate([
            'mother_name'=>'required|string',
            'mother_dob'=>'nullable|date',
            'mother_nationality'=>'nullable|string',
            'mother_national_number'=>'nullable|string',
            'mother_degree_of_kinship'=>'nullable|string',
            'mother_address'=>'nullable|string',
            'mother_city'=>'nullable|string',
            'mother_state'=>'nullable|string',
            'mother_country'=>'nullable|string',
            'mother_landmark'=>'nullable|string',
            'mother_job'=>'nullable|string',
            'mother_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'mother_email'=>'required|string|email|unique:users,email,'.$student_mother_profile->id,
            'mother_marital_status'=>'nullable|string',
            'mother_phone'=>'nullable|string',
            'mother_alternative_phone'=>'nullable|string',
            'mother_fb_link'=>'nullable|url',
            'mother_twitter_link'=>'nullable|url',
            'mother_social_media_1'=>'nullable|url',
            'mother_social_media_2'=>'nullable|url',
            'mother_qualification'=>'nullable|string',
            'mother_qualification_other'=>'nullable|string',
            'mother_wedding_date'=>'nullable|string',
            'mother_interests'=>'nullable|string',
            'mother_age_at_student_birth'=>'nullable|string',
            'mother_relation_with_child'=>'nullable|string',
            'mother_attitudes_towards_parent'=>'nullable|string',
            'mother_pregnancy_number'=>'nullable|string',
            'mother_miscarriages_number'=>'nullable|string'
        ]);
        
        if ($request->hasFile('mother_image')) {
            
            if ( $student_mother_profile->mother_image !== null) {
                $old_image = $student_mother_profile->mother_image;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->mother_image ;
            $ext = $image->getClientOriginalExtension();
            $newImageName = "mother-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $imageName = $newImageName;
        }
        else
        {
            $imageName = $student_mother_profile->mother_image;
        }

        $mother_name = $request->mother_name;
        $mother_dob = $request->mother_dob;
        $mother_nationality = $request->mother_nationality;
        $mother_national_number = $request->mother_national_number;
        $mother_degree_of_kinship = $request->mother_degree_of_kinship;
        $mother_address = $request->mother_address;
        $mother_city = $request->mother_city;
        $mother_state = $request->mother_state;
        $mother_country = $request->mother_country;
        $mother_landmark = $request->mother_landmark;
        $mother_job = $request->mother_job;
        $mother_image = $imageName;
        $mother_email = $request->mother_email;
        $mother_marital_status = $request->mother_marital_status;
        $mother_phone = $request->mother_phone;
        $mother_alternative_phone = $request->mother_alternative_phone;
        $mother_fb_link = $request->mother_fb_link;
        $mother_twitter_link = $request->mother_twitter_link;
        $mother_social_media_1 = $request->mother_social_media_1;
        $mother_social_media_2 = $request->mother_social_media_2;
        $mother_qualification = $request->mother_qualification;
        $mother_qualification_other = $request->mother_qualification_other;
        $mother_wedding_date = $request->mother_wedding_date;
        $mother_interests = $request->mother_interests;
        $mother_age_at_student_birth = $request->mother_age_at_student_birth;
        $mother_relation_with_child = $request->mother_relation_with_child;
        $mother_attitudes_towards_parent = $request->mother_attitudes_towards_parent;
        $mother_pregnancy_number = $request->mother_pregnancy_number;
        $mother_miscarriages_number = $request->mother_miscarriages_number;
        

        $student_mother_profile->update([
            'mother_name' => $mother_name,
            'mother_dob' => $mother_dob,
            'mother_nationality' => $mother_nationality,
            'mother_national_number' => $mother_national_number,
            'mother_degree_of_kinship' => $mother_degree_of_kinship,
            'mother_address' => $mother_address,
            'mother_city' => $mother_city,
            'mother_state' => $mother_state,
            'mother_country' => $mother_country,
            'mother_landmark' => $mother_landmark,
            'mother_job' => $mother_job,
            'mother_image' => $mother_image,
            'mother_email' => $mother_email,
            'mother_marital_status' => $mother_marital_status,
            'mother_phone' => $mother_phone,
            'mother_alternative_phone' => $mother_alternative_phone,
            'mother_fb_link' => $mother_fb_link,
            'mother_twitter_link' => $mother_twitter_link,
            'mother_social_media_1' => $mother_social_media_1,
            'mother_social_media_2' => $mother_social_media_2,
            'mother_qualification' => $mother_qualification,
            'mother_qualification_other' => $mother_qualification_other,
            'mother_wedding_date' => $mother_wedding_date,
            'mother_interests' => $mother_interests,
            'mother_age_at_student_birth' => $mother_age_at_student_birth,
            'mother_relation_with_child' => $mother_relation_with_child,
            'mother_attitudes_towards_parent' => $mother_attitudes_towards_parent,
            'mother_pregnancy_number' => $mother_pregnancy_number,
            'mother_miscarriages_number' => $mother_miscarriages_number,
        ]);

        return redirect( route('allMothers') )->with('message',"Mother data has been updated succesffuly");
    }

    
    public function delete($id){
        $deleted_by = 1;   // will use user
        $student_mother_profile = Student_mother_profile::find($id);
        $student_mother_profile -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $student_mother_profile -> delete();


        return redirect( route('allMothers') )->with('message',"Mother data has been deleted succesffuly");
    }

}
