<?php

namespace App\Http\Controllers;

use App\Models\Student;
use App\Models\Student_superior_profile;
use Illuminate\Http\Request;

class StudentSuperiorProfileController extends Controller
{
    // Show list of Superiors in descenting according to ID with pagination
    public function list(){
        $student_superior_profiles = Student_superior_profile::select('id' , 'superior_name' , 'superior_nationality' , 'superior_phone' , 'superior_email' , 'superior_image' , 'superior_gender' , 'superior_created_by')
        ->orderBy('id', 'desc')
        // ->paginate(1);
        ->get();
        return view('superiors.list' , [
            'student_superior_profiles' => $student_superior_profiles
        ]);
    }
    
    // View specific Superior
    public function view($id){
        
        $student_superior_profile =Student_superior_profile::find($id);
        $students = Student::select('id' , 'student_name' , 'phone', 'gender' , 'dob' )
        ->where('superior_id' , '=' , $id)
        ->get();

        return view('superiors.view' , [
            'student_superior_profile' => $student_superior_profile,
            'students' => $students,

        ]);
    }
    
    // Search in Superiors
    public function search($word){
        
        $student_superior_profiles = Student_superior_profile::select('id' , 'superior_name' , 'superior_nationality' , 'superior_phone' , 'superior_email' , 'superior_image' , 'superior_gender' ,  'superior_created_by')
        ->where('superior_name', 'like' , '%'.$word.'%')
        // ->paginate(25);
        ->get();
        return view('superiors.search' , [
            'student_superior_profiles' => $student_superior_profiles
        ]);
    }
    
    // Create Superior
    public function create(){
        return view('superiors.create');
    }


    // Store data to Superior table at DB
    public function store(Request $request){
        // Make validation on entered data 
        $request->validate([
            'superior_name'=>'required|string',
            'superior_dob'=>'nullable|date',
            'superior_nationality'=>'required|string',
            'superior_national_number'=>'required|string|unique:student_superior_profiles,superior_national_number',
            'superior_degree_of_kinship'=>'nullable|string',
            'superior_address'=>'nullable|string',
            'superior_city'=>'nullable|string',
            'superior_state'=>'nullable|string',
            'superior_country'=>'nullable|string',
            'superior_landmark'=>'nullable|string',
            'superior_job'=>'nullable|string',
            'superior_gender'=>'nullable|string',
            'superior_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'superior_email'=>'required|string|email|unique:student_superior_profiles,superior_email',
            'superior_marital_status'=>'nullable|string',
            'superior_phone'=>'nullable|string',
            'superior_alternative_phone'=>'nullable|string',
            'superior_fb_link'=>'nullable|url',
            'superior_twitter_link'=>'nullable|url',
            'superior_social_media_1'=>'nullable|url',
            'superior_social_media_2'=>'nullable|url',
            'superior_qualification'=>'nullable|string',
            'superior_qualification_other'=>'nullable|string',
            'superior_wedding_date'=>'nullable|string',
            'superior_interests'=>'nullable|string',
        ]);
        
        // Check if user upload image or no 
        if ($request->hasFile('superior_image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->superior_image ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "superior-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        $superior_name = $request->superior_name;
        $superior_dob = $request->superior_dob;
        $superior_nationality = $request->superior_nationality;
        $superior_national_number = $request->superior_national_number;
        $superior_degree_of_kinship = $request->superior_degree_of_kinship;
        $superior_address = $request->superior_address;
        $superior_city = $request->superior_city;
        $superior_state = $request->superior_state;
        $superior_country = $request->superior_country;
        $superior_landmark = $request->superior_landmark;
        $superior_job = $request->superior_job;
        $superior_gender = $request->superior_gender;
        $superior_image = $imageName;
        $superior_email = $request->superior_email;
        $superior_marital_status = $request->superior_marital_status;
        $superior_phone = $request->superior_phone;
        $superior_alternative_phone = $request->superior_alternative_phone;
        $superior_fb_link = $request->superior_fb_link;
        $superior_twitter_link = $request->superior_twitter_link;
        $superior_social_media_1 = $request->superior_social_media_1;
        $superior_social_media_2 = $request->superior_social_media_2;
        $superior_qualification = $request->superior_qualification;
        $superior_qualification_other = $request->superior_qualification_other;
        $superior_wedding_date = $request->superior_wedding_date;
        $superior_interests = $request->superior_interests;
        $created_by = 1;
        
        // Insert data into Superiors table in DB
        Student_superior_profile::create([
            'superior_name' => $superior_name,
            'superior_dob' => $superior_dob,
            'superior_nationality' => $superior_nationality,
            'superior_national_number' => $superior_national_number,
            'superior_degree_of_kinship' => $superior_degree_of_kinship,
            'superior_address' => $superior_address,
            'superior_city' => $superior_city,
            'superior_state' => $superior_state,
            'superior_country' => $superior_country,
            'superior_landmark' => $superior_landmark,
            'superior_job' => $superior_job,
            'superior_gender' => $superior_gender,
            'superior_image' => $superior_image,
            'superior_email' => $superior_email,
            'superior_marital_status' => $superior_marital_status,
            'superior_phone' => $superior_phone,
            'superior_alternative_phone' => $superior_alternative_phone,
            'superior_fb_link' => $superior_fb_link,
            'superior_twitter_link' => $superior_twitter_link,
            'superior_social_media_1' => $superior_social_media_1,
            'superior_social_media_2' => $superior_social_media_2,
            'superior_qualification' => $superior_qualification,
            'superior_qualification_other' => $superior_qualification_other,
            'superior_wedding_date' => $superior_wedding_date,
            'superior_interests' => $superior_interests,
            'superior_created_by' => $created_by
        ]);

        return redirect( route('allSuperiors') )->with('message',"New Superior has been created");
        
    }

    // Edit specific Superior Data
    // get this specific Superior data and return it at the form
    public function edit($id){
        $student_superior_profile =Student_superior_profile::find($id);
        
        return view('superiors.edit', [
            'student_superior_profile' => $student_superior_profile
        ]);
    }
    
    public function update(Request $request , $id){
        
        $student_superior_profile = Student_superior_profile::find($id);
        $request->validate([
            'superior_name'=>'required|string',
            'superior_dob'=>'nullable|date',
            'superior_nationality'=>'nullable|string',
            'superior_national_number'=>'nullable|string',
            'superior_degree_of_kinship'=>'nullable|string',
            'superior_address'=>'nullable|string',
            'superior_city'=>'nullable|string',
            'superior_state'=>'nullable|string',
            'superior_country'=>'nullable|string',
            'superior_landmark'=>'nullable|string',
            'superior_job'=>'nullable|string',
            'superior_gender'=>'nullable|string',
            'superior_image'=>'nullable|image|mimes:jpg,jpeg,png',
            'superior_email'=>'required|string|email|unique:users,email,'.$student_superior_profile->id,
            'superior_marital_status'=>'nullable|string',
            'superior_phone'=>'nullable|string',
            'superior_alternative_phone'=>'nullable|string',
            'superior_fb_link'=>'nullable|url',
            'superior_twitter_link'=>'nullable|url',
            'superior_social_media_1'=>'nullable|url',
            'superior_social_media_2'=>'nullable|url',
            'superior_qualification'=>'nullable|string',
            'superior_qualification_other'=>'nullable|string',
            'superior_wedding_date'=>'nullable|string',
            'superior_interests'=>'nullable|string',
            'superior_age_at_student_birth'=>'nullable|string',
            'superior_relation_with_child'=>'nullable|string',
            'superior_attitudes_towards_parent'=>'nullable|string',
            'superior_pregnancy_number'=>'nullable|string',
            'superior_miscarriages_number'=>'nullable|string'
        ]);
        
        if ($request->hasFile('superior_image')) {
            
            if ( $student_superior_profile->superior_image !== null) {
                $old_image = $student_superior_profile->superior_image;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->superior_image ;
            $ext = $image->getClientOriginalExtension();
            $newImageName = "superior-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $imageName = $newImageName;
        }
        else
        {
            $imageName = $student_superior_profile->superior_image;
        }

        $superior_name = $request->superior_name;
        $superior_dob = $request->superior_dob;
        $superior_nationality = $request->superior_nationality;
        $superior_national_number = $request->superior_national_number;
        $superior_degree_of_kinship = $request->superior_degree_of_kinship;
        $superior_address = $request->superior_address;
        $superior_city = $request->superior_city;
        $superior_state = $request->superior_state;
        $superior_country = $request->superior_country;
        $superior_landmark = $request->superior_landmark;
        $superior_job = $request->superior_job;
        $superior_gender = $request->superior_gender;
        $superior_image = $imageName;
        
        $superior_email = $request->superior_email;
        $superior_marital_status = $request->superior_marital_status;
        $superior_phone = $request->superior_phone;
        $superior_alternative_phone = $request->superior_alternative_phone;
        $superior_fb_link = $request->superior_fb_link;
        $superior_twitter_link = $request->superior_twitter_link;
        $superior_social_media_1 = $request->superior_social_media_1;
        $superior_social_media_2 = $request->superior_social_media_2;
        $superior_qualification = $request->superior_qualification;
        $superior_qualification_other = $request->superior_qualification_other;
        $superior_wedding_date = $request->superior_wedding_date;
        $superior_interests = $request->superior_interests;
        $superior_age_at_student_birth = $request->superior_age_at_student_birth;
        $superior_relation_with_child = $request->superior_relation_with_child;
        $superior_attitudes_towards_parent = $request->superior_attitudes_towards_parent;
        $superior_pregnancy_number = $request->superior_pregnancy_number;
        $superior_miscarriages_number = $request->superior_miscarriages_number;
        

        $student_superior_profile->update([
            'superior_name' => $superior_name,
            'superior_dob' => $superior_dob,
            'superior_nationality' => $superior_nationality,
            'superior_national_number' => $superior_national_number,
            'superior_degree_of_kinship' => $superior_degree_of_kinship,
            'superior_address' => $superior_address,
            'superior_city' => $superior_city,
            'superior_state' => $superior_state,
            'superior_country' => $superior_country,
            'superior_landmark' => $superior_landmark,
            'superior_job' => $superior_job,
            'superior_gender' => $superior_gender,
            'superior_image' => $superior_image,
            'superior_email' => $superior_email,
            'superior_marital_status' => $superior_marital_status,
            'superior_phone' => $superior_phone,
            'superior_alternative_phone' => $superior_alternative_phone,
            'superior_fb_link' => $superior_fb_link,
            'superior_twitter_link' => $superior_twitter_link,
            'superior_social_media_1' => $superior_social_media_1,
            'superior_social_media_2' => $superior_social_media_2,
            'superior_qualification' => $superior_qualification,
            'superior_qualification_other' => $superior_qualification_other,
            'superior_wedding_date' => $superior_wedding_date,
            'superior_interests' => $superior_interests,
            'superior_age_at_student_birth' => $superior_age_at_student_birth,
            'superior_relation_with_child' => $superior_relation_with_child,
            'superior_attitudes_towards_parent' => $superior_attitudes_towards_parent,
            'superior_pregnancy_number' => $superior_pregnancy_number,
            'superior_miscarriages_number' => $superior_miscarriages_number,
        ]);

        return redirect( route('allSuperiors') )->with('message',"Superior data has been updated succesffuly");
    }

    
    public function delete($id){
        $deleted_by = 1;   // will use user
        $student_superior_profile = Student_superior_profile::find($id);
        $student_superior_profile -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $student_superior_profile -> delete();


        return redirect( route('allSuperiors') )->with('message',"Superior data has been deleted succesffuly");
    }

}
