<?php

namespace App\Http\Controllers;

use App\Models\Business_location;
use App\Models\Submission;
use Illuminate\Http\Request;

class SubmissionController extends Controller
{
    // Show list of Submissions in descenting according to ID with pagination
    public function list(){
        $submissions = Submission::orderBy('id', 'desc')
        ->get();
        return view('submissions.list' , [
            'submissions' => $submissions
        ]);
    }
  
    // View specific Submission
    public function view($id){
        
        $submission =Submission::find($id);
        dd($submission);
        return view('submissions.view' , [
            'submission' => $submission
        ]);
    }
     
    // Search in Submissions
    public function search($word){
        
        $submissions =Submission::where('assignment_title', 'like' , '%'.$word.'%')
        ->paginate(25);
        return view('submissions.search' , [
            'submissions' => $submissions
        ]);
    }

/*
    // Create Submissions
    public function create(){
        // Get Business Locations data
        // $business_locations = Business_location::select('id' , 'business_name')->get();

        // return view('submissions.create' , [
        //     'business_locations' => $business_locations
        // ]);
        return view('submissions.create');
    }

    // Store data to Submissions table at DB
    public function store(Request $request){
        // Make validation on entered data 
        $request->validate([
            'answer'=>'required|string',
            // 'assignment_note'=>'nullable|string',
            // 'assignment_structure'=>'nullable|string',
            // 'business_id'=>'required|exists:business_locations,id',
            
            // 'logo'=>'nullable|image|mimes:jpg,jpeg,png',
            

        ]);

        // Check if user upload image or no 
        if ($request->hasFile('logo')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->logo ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "business_location-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        $answer = $request->answer;
        $student_id = 1;
        $assignment_id = 1;
        $business_id = 1;
        $trainer_id = 1;

        // $assignment_note = $request->assignment_note;
        // $assignment_structure = $request->assignment_structure;
        // $created_by = 1;
        // $business_id = $request->business_id;
        // $logo = $imageName;

        
        // Insert data into Submissions table in DB
        Submission::create([
            'answer' => $answer,
            'student_id' => $student_id,
            'assignment_id' => $assignment_id,
            'business_id' => $business_id,
            'trainer_id' => $trainer_id,
            // 'assignment_note' => $assignment_note,
            // 'assignment_structure' => $assignment_structure,
            // 'business_id' => $business_id,
            // 'created_by' => $created_by,
            // 'logo' => $logo,

        ]);

        return redirect( route('allSubmissions') )->with('message',"New Submission has been created");
        
    }

    // Edit specifi Submission Data
    // get this specific Submission data and return it at the form
    public function edit($id){
        $submission =Submission::find($id);
        // $business_locations = Business_location::select('id' , 'business_name')->get();
        // $authors = Author::select('id' , 'name')->get();
        // dd($book);
        return view('submissions.edit', [
            'submission' => $submission,
        ]);
    }
    
    public function update(Request $request , $id){
        
        $request->validate([
            'answer'=>'required|string',
            // 'assignment_title'=>'required|string',
            // 'assignment_note'=>'nullable|string',
            // 'assignment_structure'=>'nullable|string',
            // 'business_id'=>'required|exists:business_locations,id',
        ]);
        
        $submission = Submission::find($id);

        if ($request->hasFile('logo')) {
            
            if ( $business_location->logo !== null) {
                $old_image = $business_location->logo;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->logo ;
            $ext = $image->getClientOriginalExtension();
            $newImageName = "business_location-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $imageName = $newImageName;
        }
        else
        {
            $imageName = $business_location->logo;
        }

        $answer = $request->answer;
        $student_id = 1;
        $assignment_id = 1;
        $business_id = 1;
        $trainer_id = 1;
        // $assignment_title = $request->assignment_title;
        // $assignment_note = $request->assignment_note;
        // $assignment_structure = $request->assignment_structure;
        // $created_by = 1;
        // $business_id = $request->business_id;
        // $logo = $imageName;

        $submission->update([
            'answer' => $answer,
            'student_id' => $student_id,
            'assignment_id' => $assignment_id,
            'business_id' => $business_id,
            'trainer_id' => $trainer_id,
            // 'assignment_title' => $assignment_title,
            // 'assignment_note' => $assignment_note,
            // 'assignment_structure' => $assignment_structure,
            // 'business_id' => $business_id,
            // 'created_by' => $created_by,
            // 'logo' => $logo,
        ]);

        return redirect( route('allSubmissions') )->with('message',"Submission data has been updated succesffuly");
    }
*/

    public function delete($id){
        $deleted_by = 1;   // will use suer
        $submission = Submission::find($id);
        $submission -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $submission -> delete();


        return redirect( route('allSubmissions') )->with('message',"Submission data has been deleted succesffuly");
    }

}
