<?php

namespace App\Http\Controllers;

use App\Models\Business_location;
use App\Models\Trainer;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class TrainerController extends Controller
{
    // Show list of Trainers in descenting according to ID with pagination
    public function list(){

        if (Auth::user()->role != 'super_admin') {
            $trainers = Trainer::select('id' , 'user_id' , 'business_id' , 'created_by')
            ->where('business_id' , Auth::user()->business_id )
            ->orderBy('id', 'desc')
            // ->paginate(1);
            ->get();
        }
        else
        {
            $trainers = Trainer::select('id' , 'user_id' , 'business_id' , 'created_by')
            ->orderBy('id', 'desc')
            // ->paginate(1);
            ->get();
        }

        return view('trainers.list' , [
            'trainers' => $trainers
        ]);
    }
    
    // View specific Trainer
    public function view($id){
        
        $trainer =Trainer::find($id);

        if ($trainer->business_id == Auth::user()->business_id) {
            
            return view('trainers.view' , [
                'trainer' => $trainer
            ]);

        } else {

            return redirect( route('notAuth') );

        }
        
        
    }
    
    // Search in Business Locations
    // public function search($word){
        
    //     $trainers = Trainer::select('id' , 'user_id' , 'business_id' , 'created_by')
    //     ->where('full_name', 'like' , '%'.$word.'%')
    //     // ->paginate(25);
    //     ->get();
    //     return view('trainers.search' , [
    //         'trainers' => $trainers
    //     ]);
    // }
    
    // Create Trainer
    public function create(){
        // Get Business Location Data
        if (Auth::user()->role != 'super_admin') {
            $business_locations = Business_location::select('id' , 'business_name')
            ->where('id' , Auth::user()->business_id )
            ->get();
        }
        else
        {
            $business_locations = Business_location::select('id' , 'business_name')
            ->get();
        }

        return view('trainers.create' , [
            'business_locations' => $business_locations
        ]);
    }

    // Store data to Trainer table at DB
    public function store(Request $request){
        // Make validation on entered data 
        $request->validate([
            'user_name'=>'required|string|unique:users,user_name',
            'full_name'=>'required|string',
            'password'=>'required|string',
            'email'=>'required|string|email|unique:users,email',
            'address'=>'nullable|string',
            'city'=>'nullable|string',
            'state'=>'nullable|string',
            'country'=>'nullable|string',
            'landmark'=>'nullable|string',            
            'phone'=>'nullable|integer',
            'alternative_phone'=>'nullable|integer',
            'nationality'=>'nullable|string',
            'national_number'=>'nullable|string',
            'dob'=>'nullable|date',
            'image'=>'nullable|image|mimes:jpg,jpeg,png',
            'gender'=>'nullable|string',
            'marital_status'=>'nullable|string',
            'blood_group'=>'nullable|string',
            'fb_link'=>'nullable|url',
            'twitter_link'=>'nullable|url',
            'social_media_1'=>'nullable|url',
            'social_media_2'=>'nullable|url',
            'website'=>'nullable|url',
            'specialization'=>'nullable|string',
            'university'=>'nullable|string',
            'graduation_date'=>'nullable|string',
            'expereience'=>'nullable|string',
            'qualification'=>'nullable|string',
            'qualification_other'=>'nullable|string',
            'membership'=>'nullable|string',
            'previous_job'=>'nullable|string',
            'previous_job_address'=>'nullable|string',
            'previous_job_country'=>'nullable|string',
            'business_id'=>'required|exists:business_locations,id',
            'join_job_date'=>'nullable|string',
            'is_active'=>'required|string',
            // 'allow_login'=>'required|string'

        ]);
        
        // Check if user upload image or no 
        if ($request->hasFile('image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->image ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "trainer-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        $user_name = $request->user_name;
        $full_name = $request->full_name;
        $password = $request->password;
        $address = $request->address;
        $city = $request->city;
        $state = $request->state;
        $country = $request->country;
        $landmark = $request->landmark;
        $nationality = $request->nationality;
        $dob = $request->dob;
        $gender = $request->gender;
        $national_number = $request->national_number;
        $image = $imageName;
        $marital_status = $request->marital_status;
        $email = $request->email;
        $phone = $request->phone;
        $alternative_phone = $request->alternative_phone;
        $website = $request->website;
        $specialization = $request->specialization;
        $university = $request->university;
        $graduation_date = $request->graduation_date;
        $expereience = $request->expereience;
        $qualification = $request->qualification;
        $qualification_other = $request->qualification_other;
        $membership = $request->membership;
        $previous_job = $request->previous_job;
        $previous_job_address = $request->previous_job_address;
        $previous_job_country = $request->previous_job_country;
        $business_id = $request->business_id;
        $join_job_date = $request->join_job_date;
        $blood_group = $request->blood_group;
        $fb_link = $request->fb_link;
        $twitter_link = $request->twitter_link;
        $social_media_1 = $request->social_media_1;
        $social_media_2 = $request->social_media_2;
        $is_active = $request->is_active;
        // $allow_login = $request->allow_login;
        $created_by = Auth::user()->id;
        $role = "trainer";
        
        // Insert data into Users table in DB
        $new_user = User::create([
            'user_name' => $user_name,
            'full_name' => $full_name,
            'password' => Hash::make($password),
            'email' => $email,
            'address' => $address,
            'phone' => $phone,
            'alternative_phone' => $alternative_phone,
            'city' => $city,
            'state' => $state,
            'country' => $country,
            'landmark' => $landmark,
            'nationality' => $nationality,
            'dob' => $dob,
            'gender' => $gender,
            'national_number' => $national_number,
            'image' => $image,
            'marital_status' => $marital_status,
            'blood_group' => $blood_group,
            'fb_link' => $fb_link,
            'twitter_link' => $twitter_link,
            'social_media_1' => $social_media_1,
            'social_media_2' => $social_media_2,
            'business_id' => $business_id,
            'is_active' => $is_active,
            'created_by' => $created_by,
            'role' => $role
        ]);

        Trainer::create([
            'user_id' => $new_user->id,
            'website' => $website,
            'specialization' => $specialization,
            'university' => $university,
            'graduation_date' => $graduation_date,
            'expereience' => $expereience,
            'qualification' => $qualification,
            'qualification_other' => $qualification_other,
            'membership' => $membership,
            'previous_job' => $previous_job,
            'previous_job_address' => $previous_job_address,
            'previous_job_country' => $previous_job_country,
            'business_id' => $business_id,
            'join_job_date' => $join_job_date,
            'created_by' => $created_by
        ]);

        return redirect( route('allTrainers') )->with('message',"New Trainer has been created");
        
    }

    // Edit specifi Trainer Data
    // get this specific Trainer data and return it at the form
    public function edit($id){
        // Get Business Location Data
        if (Auth::user()->role != 'super_admin') {
            $business_locations = Business_location::select('id' , 'business_name')
            ->where('id' , Auth::user()->business_id )
            ->get();
        }
        else
        {
            $business_locations = Business_location::select('id' , 'business_name')
            ->get();
        }
        $trainer =Trainer::find($id);

        return view('trainers.edit', [
            'business_locations' => $business_locations,
            'trainer' => $trainer
        ]);
    }
    
    public function update(Request $request , $id){
        
        $trainer = Trainer::find($id);
        $user = User::find($trainer->user_id);
        $request->validate([
            'user_name'=>'required|string|unique:users,user_name,'.$user->id,
            'full_name'=>'required|string',
            'address'=>'nullable|string',
            'city'=>'nullable|string',
            'state'=>'nullable|string',
            'country'=>'nullable|string',
            'landmark'=>'nullable|string',
            'nationality'=>'nullable|string',
            'dob'=>'nullable|string',
            'gender'=>'nullable|string',
            'national_number'=>'nullable|string',
            'image'=>'nullable|image|mimes:jpg,jpeg,png',
            'marital_status'=>'nullable|string',
            'email'=>'required|string|email|unique:users,email,'.$user->id,
            'phone'=>'nullable|integer',
            'alternative_phone'=>'nullable|integer',
            'website'=>'nullable|url',
            'specialization'=>'nullable|string',
            'university'=>'nullable|string',
            'graduation_date'=>'nullable|string',
            'expereience'=>'nullable|string',
            'qualification'=>'nullable|string',
            'qualification_other'=>'nullable|string',
            'membership'=>'nullable|string',
            'previous_job'=>'nullable|string',
            'previous_job_address'=>'nullable|string',
            'previous_job_country'=>'nullable|string',
            'business_id'=>'required|exists:business_locations,id',
            'join_job_date'=>'nullable|string',
            'blood_group'=>'nullable|string',
            'fb_link'=>'nullable|url',
            'twitter_link'=>'nullable|url',
            'social_media_1'=>'nullable|url',
            'social_media_2'=>'nullable|url',
            'is_active'=>'required|string',
        ]);
        
        if ($request->hasFile('image')) {
            
            if ( $trainer->image !== null) {
                $old_image = $trainer->image;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->image ;
            $ext = $image->getClientOriginalExtension();
            $newImageName = "trainer-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $imageName = $newImageName;
        }
        else
        {
            $imageName = $trainer->image;
        }

        $user_name = $request->user_name;
        $full_name = $request->full_name;
        $address = $request->address;
        $city = $request->city;
        $state = $request->state;
        $country = $request->country;
        $landmark = $request->landmark;
        $nationality = $request->nationality;
        $dob = $request->dob;
        $gender = $request->gender;
        $national_number = $request->national_number;
        $image = $imageName;
        $marital_status = $request->marital_status;
        $email = $request->email;
        $phone = $request->phone;
        $alternative_phone = $request->alternative_phone;
        $website = $request->website;
        $specialization = $request->specialization;
        $university = $request->university;
        $graduation_date = $request->graduation_date;
        $expereience = $request->expereience;
        $qualification = $request->qualification;
        $qualification_other = $request->qualification_other;
        $membership = $request->membership;
        $previous_job = $request->previous_job;
        $previous_job_address = $request->previous_job_address;
        $previous_job_country = $request->previous_job_country;
        $business_id = $request->business_id;
        $join_job_date = $request->join_job_date;
        $blood_group = $request->blood_group;
        $fb_link = $request->fb_link;
        $twitter_link = $request->twitter_link;
        $social_media_1 = $request->social_media_1;
        $social_media_2 = $request->social_media_2;
        $is_active = $request->is_active;

        $user->update([
            'user_name' => $user_name,
            'full_name' => $full_name,
            'email' => $email,
            'address' => $address,
            'phone' => $phone,
            'alternative_phone' => $alternative_phone,
            'city' => $city,
            'state' => $state,
            'country' => $country,
            'landmark' => $landmark,
            'nationality' => $nationality,
            'dob' => $dob,
            'gender' => $gender,
            'national_number' => $national_number,
            'image' => $image,
            'marital_status' => $marital_status,
            'business_id' => $business_id,
            'blood_group' => $blood_group,
            'fb_link' => $fb_link,
            'twitter_link' => $twitter_link,
            'social_media_1' => $social_media_1,
            'social_media_2' => $social_media_2,
            'is_active' => $is_active,

        ]);
        $trainer->update([
            'website' => $website,
            'specialization' => $specialization,
            'university' => $university,
            'graduation_date' => $graduation_date,
            'expereience' => $expereience,
            'qualification' => $qualification,
            'qualification_other' => $qualification_other,
            'membership' => $membership,
            'previous_job' => $previous_job,
            'previous_job_address' => $previous_job_address,
            'previous_job_country' => $previous_job_country,
            'business_id' => $business_id,
            'join_job_date' => $join_job_date,
        ]);

        return redirect( route('allTrainers') )->with('message',"Trainer data has been updated succesffuly");
    }

    // public function updatePassword(Request $request , $id){
    //     $trainer =Trainer::find($id);
    //     $user = User::find($trainer->user_id);
        
    //     $request->validate([
    //         'password'=>'required|string',
    //     ]);
        

    //     $password = $request->password;

    //     $user->update([
    //         'password' => Hash::make($password),
    //     ]);

    //     return back()->with('message',"Trainer password has been updated succesffuly");
    // }


    public function delete($id){
        $deleted_by = Auth::user()->id;   
        $trainer = Trainer::find($id);
        $user = User::find($trainer->user_id);
        $user -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $trainer -> delete();
        $user -> delete();


        return redirect( route('allTrainers') )->with('message',"Trainer data has been deleted succesffuly");
    }

}
