<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Business_location;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserController extends Controller
{
    // Show list of users in descenting according to ID with pagination
    public function list(){
        

        if (Auth::user()->role != 'super_admin') {
            $users = User::select('id' , 'full_name' , 'email' , 'image' , 'phone' , 'nationality' , 'gender' , 'business_id' , 'is_active')
            ->where('business_id' , Auth::user()->business_id )
            ->orderBy('id', 'desc')
            // ->paginate(1);
            ->get();
        }
        else
        {
            $users = User::select('id' , 'full_name' , 'email' , 'image' , 'phone' , 'nationality' , 'gender' , 'business_id' , 'is_active')
            ->orderBy('id', 'desc')
            // ->paginate(1);
            ->get();
        }

        // $users = User::orderBy('id', 'desc')
        // ->paginate(15);
        // ->get();
        // $userslist = User::orderBy('id', 'desc')
        // ->paginate(15);
        // ->get();
        return view('users.list' , [
            'users' => $users,
            // 'userslist' => $userslist
        ]);
    }

    // public function test(){
    //     return view('users.test');
    // }
    
    // View specific user
    public function view($id){
        
        $user =User::find($id);

        if ($user->business_id == Auth::user()->business_id) {
            
            return view('users.view' , [
                'user' => $user
            ]);

        } else {
            return redirect( route('notAuth') );
        }
        
        
    }
    
    // Search in users
    public function search($word){
        
        if (Auth::user()->role != 'super_admin') {
            $users = User::select('id' , 'full_name' , 'email' , 'image' , 'phone' , 'nationality' , 'gender' , 'business_id' , 'is_active')
            ->where('user_name', 'like' , '%'.$word.'%')
            ->where('business_id' , Auth::user()->business_id )
            ->orderBy('id', 'desc')
            // ->paginate(1);
            ->get();
        }
        else
        {
            $users = User::select('id' , 'full_name' , 'email' , 'image' , 'phone' , 'nationality' , 'gender' , 'business_id' , 'is_active')
            ->where('user_name', 'like' , '%'.$word.'%')
            ->orderBy('id', 'desc')
            ->get();
        }

        return view('users.search' , [
            'users' => $users
        ]);
    }
    
    // Create user
    public function create(){
        // Get Business Location Data
        if (Auth::user()->role != 'super_admin') {
            $business_locations = Business_location::select('id' , 'business_name')
            ->where('id' , Auth::user()->business_id )
            ->get();
        }
        else
        {
            $business_locations = Business_location::select('id' , 'business_name')
            ->get();
        }

        return view('users.create' , [
            'business_locations' => $business_locations
        ]);
    }

    // Store data to Users table at DB
    public function store(Request $request){
        // Make validation on entered data 
        $request->validate([
            'user_name'=>'required|string|unique:users,user_name',
            'full_name'=>'required|string',
            'password'=>'required|string',
            'email'=>'required|string|email|unique:users,email',
            'address'=>'nullable|string',
            'city'=>'nullable|string',
            'state'=>'nullable|string',
            'country'=>'nullable|string',
            'landmark'=>'nullable|string',
            'phone'=>'nullable|integer',
            'alternative_phone'=>'nullable|integer',
            'contact_number'=>'nullable|integer',
            'language'=>'nullable|string',
            'nationality'=>'nullable|string',
            'national_number'=>'nullable|string',
            'dob'=>'nullable|date',
            'image'=>'nullable|image|mimes:jpg,jpeg,png',
            'gender'=>'nullable|string',
            'marital_status'=>'nullable|string',
            'blood_group'=>'nullable|string',
            'fb_link'=>'nullable|url',
            'twitter_link'=>'nullable|url',
            'social_media_1'=>'nullable|url',
            'social_media_2'=>'nullable|url',
            'business_id'=>'nullable|exists:business_locations,id',
            'is_active'=>'required|string',
            // 'allow_login'=>'required|string'

        ]);
        
        // Check if user upload image or no 
        if ($request->hasFile('image')) {
            // Rename image and save it in case of image has been uploaded
            $img = $request->image ;
            $ext = $img->getClientOriginalExtension();
            $imageName = "user-" . uniqid() . ".$ext";
            $img->move( public_path('uploads') , $imageName);

        } else {
            // If user doesn't upload image
            $imageName = null;
        }

        $user_name = $request->user_name;
        $full_name = $request->full_name;
        $email = $request->email;
        $password = $request->password;
        $address = $request->address;
        $city = $request->city;
        $state = $request->state;
        $country = $request->country;
        $landmark = $request->landmark;
        $phone = $request->phone;
        $alternative_phone = $request->alternative_phone;
        $language = $request->language;
        $nationality = $request->nationality;
        $national_number = $request->national_number;
        $marital_status = $request->marital_status;
        $image = $imageName;
        $dob = $request->dob;
        $gender = $request->gender;
        $blood_group = $request->blood_group;
        $contact_number = $request->contact_number;
        $fb_link = $request->fb_link;
        $twitter_link = $request->twitter_link;
        $social_media_1 = $request->social_media_1;
        $social_media_2 = $request->social_media_2;
        // $allow_login = $request->allow_login;
        $is_active = $request->is_active;
        $business_id = $request->business_id;
        $created_by = Auth::user()->id;
        
        // Insert data into Users table in DB
        User::create([
            'user_name' => $user_name,
            'full_name' => $full_name,
            'email' => $email,
            'password' => Hash::make($password),
            'address' => $address,
            'city' => $city,
            'state' => $state,
            'country' => $country,
            'landmark' => $landmark,
            'phone' => $phone,
            'alternative_phone' => $alternative_phone,
            'language' => $language,
            'nationality' => $nationality,
            'national_number' => $national_number,
            'marital_status' => $marital_status,
            'dob' => $dob,
            'gender' => $gender,
            'blood_group' => $blood_group,
            'contact_number' => $contact_number,
            'image' => $image,
            'fb_link' => $fb_link,
            'twitter_link' => $twitter_link,
            'social_media_1' => $social_media_1,
            'social_media_2' => $social_media_2,
            // 'allow_login' => $allow_login,
            'is_active' => $is_active,
            'business_id' => $business_id,
            'created_by' => $created_by
        ]);

        return redirect( route('allUsers') )->with('message',"New user has been created");
        
    }

    // Edit specifi user
    // get this specifi user data and return it at the form
    public function edit($id){
        $user =User::find($id);

        if (Auth::user()->role != 'super_admin') {
            $business_locations = Business_location::select('id' , 'business_name')
            ->where('id' , Auth::user()->business_id )
            ->get();
        }
        else
        {
            $business_locations = Business_location::select('id' , 'business_name')
            ->get();
        }

        return view('users.edit', [
            'business_locations' => $business_locations,
            'user' => $user,
        ]);
    }
    
    public function update(Request $request , $id){
        $user =User::find($id);
        
        $request->validate([
            'user_name'=>'required|string|unique:users,user_name,'.$user->id,
            'full_name'=>'required|string',
            'email'=>'required|string|email|unique:users,email,'.$user->id,
            'address'=>'nullable|string',
            'city'=>'nullable|string',
            'state'=>'nullable|string',
            'country'=>'nullable|string',
            'landmark'=>'nullable|string',
            'phone'=>'nullable|integer',
            'alternative_phone'=>'nullable|integer',
            'contact_number'=>'nullable|integer',
            'language'=>'nullable|string',
            'nationality'=>'nullable|string',
            'national_number'=>'nullable|string',
            'dob'=>'nullable|date',
            'image'=>'nullable|image|mimes:jpg,jpeg,png',
            'gender'=>'nullable|string',
            'marital_status'=>'nullable|string',
            'blood_group'=>'nullable|string',
            'fb_link'=>'nullable|url',
            'twitter_link'=>'nullable|url',
            'social_media_1'=>'nullable|url',
            'social_media_2'=>'nullable|url',
            'business_id'=>'nullable|exists:business_locations,id',
            'is_active'=>'required|string',
            // 'allow_login'=>'required|string'

        ]);
        
        
        if ($request->hasFile('image')) {
            
            if ( $user->image !== null) {
                $old_image = $user->image;
                unlink( public_path("uploads/$old_image") );
            }
            
            $image = $request->image ;
            $ext = $image->getClientOriginalExtension();
            $newImageName = "user-" . uniqid() . ".$ext";
            $image->move( public_path('uploads') , $newImageName);
            $imageName = $newImageName;
        }
        else
        {
            $imageName = $user->image;
        }

        $user_name = $request->user_name;
        $full_name = $request->full_name;
        $email = $request->email;
        $address = $request->address;
        $city = $request->city;
        $state = $request->state;
        $country = $request->country;
        $landmark = $request->landmark;
        $phone = $request->phone;
        $alternative_phone = $request->alternative_phone;
        $language = $request->language;
        $nationality = $request->nationality;
        $national_number = $request->national_number;
        $marital_status = $request->marital_status;
        $image = $imageName;
        $dob = $request->dob;
        $gender = $request->gender;
        $blood_group = $request->blood_group;
        $contact_number = $request->contact_number;
        $fb_link = $request->fb_link;
        $twitter_link = $request->twitter_link;
        $social_media_1 = $request->social_media_1;
        $social_media_2 = $request->social_media_2;
        // $allow_login = $request->allow_login;
        $is_active = $request->is_active;
        $business_id = $request->business_id;

        $user->update([
            'user_name' => $user_name,
            'full_name' => $full_name,
            'email' => $email,
            'address' => $address,
            'city' => $city,
            'state' => $state,
            'country' => $country,
            'landmark' => $landmark,
            'phone' => $phone,
            'alternative_phone' => $alternative_phone,
            'language' => $language,
            'nationality' => $nationality,
            'national_number' => $national_number,
            'marital_status' => $marital_status,
            'dob' => $dob,
            'gender' => $gender,
            'blood_group' => $blood_group,
            'contact_number' => $contact_number,
            'image' => $image,
            'fb_link' => $fb_link,
            'twitter_link' => $twitter_link,
            'social_media_1' => $social_media_1,
            'social_media_2' => $social_media_2,
            // 'allow_login' => $allow_login,
            'is_active' => $is_active,
            'business_id' => $business_id
        ]);

        return redirect( route('allUsers') )->with('message',"User data has been updated succesffuly");
    }
    
    public function updatePassword(Request $request , $id){
        $user =User::find($id);
        
        $request->validate([
            'password'=>'required|string',
        ]);
        

        $password = $request->password;

        $user->update([
            'password' => Hash::make($password),
        ]);

        return back()->with('message',"User password has been updated succesffuly");
    }
   

    public function delete($id){
        $deleted_by = Auth::user()->id;
        $user = User::find($id);
        $user -> update([
            'deleted_by' => $deleted_by
        ]);
        
        $user -> delete();


        return redirect( route('allUsers') )->with('message',"User data has been deleted succesffuly");
    }

}
