<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Assignment extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'assignment_title',
        'assignment_title_ar',
        'assignment_shortname',
        'assignment_note',
        'assignment_note_ar',
        'assignment_instructions',
        'assignment_instructions_ar',
        'assignment_structure',
        'assignment_questions',
        'assignment_condition',
        // 'business_id',
        'created_by',
        'deleted_by'
    ];

    // Model Relations
    public function createdPerson()
    {
        return $this->belongsTo(User::class , 'created_by');
    }

    public function businessLocation()
    {
        return $this->belongsTo(Business_location::class , 'business_id');
    }

    // public function submission()
    // {
    //     return $this->belongsTo(Submission::class);
    // }
}
