<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Business_location extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'business_name', 
        'address', 
        'phone', 
        'alternative_phone', 
        'email', 
        'image', 
        'owner_id', 
        'license_start_date', 
        'license_end_date', 
        'max_students', 
        'max_assignments', 
        'max_submissions', 
        'max_admins', 
        'max_trainers', 
        'theme_color', 
        'is_active',
        'technical_supervisor',
        'created_by',
        'deleted_by' 
    ];

    // Model Relations
    // public function user()
    // {
    //     return $this->hasOne(User::class , 'owner_id');
    // }
    
    public function owner()
    {
        return $this->belongsTo(User::class , 'owner_id');
    }
    
    public function createdPerson()
    {
        return $this->belongsTo(User::class , 'created_by');
    }
    
    public function trainer()
    {
        return $this->hasOne(Trainer::class);
    }
}
