<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Contact_form extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'first_name', 
        'middle_name', 
        'last_name', 
        'phone', 
        'alternative_phone', 
        'email', 
        'subject', 
        'message', 
        'deleted_by' 
    ];

    // Model Relations
    public function users()
    {
        return $this->hasOne(User::class);
    }
}
