<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Question extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'question_title',
        'question_note',
        'question_title_ar',
        'question_note_ar',
        'answers',
        'business_id',
        'created_by',
        'deleted_by'
    ];

    // Model Relations
    public function createdPerson()
    {
        return $this->belongsTo(User::class , 'created_by');
    }

    public function businessLocation()
    {
        return $this->belongsTo(Business_location::class , 'business_id');
    }
}
