<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Report extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'assignment_ids' ,
        'report_title' ,
        'report_file' ,
        'deleted_by'
    ];
    
    // Model Relations
    public function student()
    {
        return $this->belongsTo(Student::class , 'student_id');
    }

    public function trainer()
    {
        return $this->belongsTo(Trainer::class , 'trainer_id');
    }
    
}
