<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Student extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'student_name' ,
        'dob' ,
        'birth_address' ,
        'height' ,
        'weight' ,
        'address' ,
        'city' ,
        'state' ,
        'country' ,
        'landmark' ,
        'home_phone' ,
        'phone' ,
        'alternative_phone' ,
        'image' ,
        'gender' ,
        'school_name' ,
        'blood_group' ,
        'contact_number' ,
        'fb_link' ,
        'twitter_link' ,
        'social_media_1' ,
        'social_media_2' ,
        'nationality' ,
        'national_number' ,        
        'father_id' ,        
        'mother_id' ,        
        'superior' ,        
        'superior_id' ,        
        'created_by' ,        
        'deleted_by'
    ];

    // Model Relations
    public function createdPerson()
    {
        return $this->belongsTo(User::class , 'created_by');
    }

    public function students_group1_profiles()
    {
        return $this->hasOne(Students_group1_profile::class);
    }

    public function students_group2_profiles()
    {
        return $this->hasOne(Students_group2_profile::class);
    }

    public function students_group3_profiles()
    {
        return $this->hasOne(Students_group3_profile::class);
    }

    public function students_group4_profiles()
    {
        return $this->hasOne(Students_group4_profile::class);
    }

    public function studentFatherProfile()
    {
        return $this->hasOne(Student_father_profile::class);
    }

    public function studentMotherProfile()
    {
        return $this->hasOne(Student_mother_profile::class);
    }

    public function studentSuperiorProfile()
    {
        return $this->hasOne(Student_superior_profile::class);
    }

}
