<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student_father_profile extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'father_name', 
        'father_dob', 
        'father_nationality', 
        'father_national_number', 
        'father_degree_of_kinship', 
        'father_address', 
        'father_city', 
        'father_state', 
        'father_country', 
        'father_landmark', 
        'father_job', 
        'father_image', 
        'father_phone', 
        'father_alternative_phone', 
        'father_email', 
        'father_marital_status', 
        'father_fb_link',
        'father_twitter_link',
        'father_social_media_1',
        'father_social_media_2',
        'father_qualification',
        'father_qualification_other',
        'father_wedding_date',
        'father_interests',
        'father_created_by',
        'deleted_by'
    ];

    // Model Relations
    public function createdPerson()
    {
        return $this->belongsTo(User::class , 'father_created_by');
    }
}
