<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student_mother_profile extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'mother_name', 
        'mother_dob', 
        'mother_nationality', 
        'mother_national_number', 
        'mother_degree_of_kinship', 
        'mother_address', 
        'mother_city', 
        'mother_state', 
        'mother_country', 
        'mother_landmark', 
        'mother_job', 
        'mother_image', 
        'mother_phone', 
        'mother_alternative_phone', 
        'mother_email', 
        'mother_marital_status', 
        'mother_fb_link',
        'mother_twitter_link',
        'mother_social_media_1',
        'mother_social_media_2',
        'mother_qualification',
        'mother_qualification_other',
        'mother_wedding_date',
        'mother_interests',
        'mother_pregnancy_number',
        'mother_miscarriages_number',
        'mother_created_by',
        'deleted_by'
    ];

    // Model Relations
    public function createdPerson()
    {
        return $this->belongsTo(User::class , 'mother_created_by');
    }
}
