<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Student_parent extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'name',
        'gender',
        'dob',
        'national_id',
        'degree_of_kinship',
        'address',
        'city',
        'state',
        'country',
        'landmark',
        'job',
        'phone',
        'alternative_phone',
        'email',
        'qualification',
        'qualification_other',
        'wedding_date',
        'interests',
        'age_at_student_birth',
        'relation_with_child',
        'attitudes_towards_parent',
        'pregnancy_number',
        'miscarriages_number',
        'father_id',
        'fb_link',
        'twitter_link',
        'social_media_1',
        'social_media_2',
        'deleted_by'
    ];

    // Model Relations
    public function users()
    {
        return $this->hasOne(User::class);
    }

    public function students()
    {
        return $this->hasOne(User::class);
    }
}
