<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Student_superior_profile extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'superior_name', 
        'superior_dob', 
        'superior_nationality', 
        'superior_national_number', 
        'superior_degree_of_kinship', 
        'superior_address', 
        'superior_city', 
        'superior_state', 
        'superior_country', 
        'superior_landmark', 
        'superior_job', 
        'superior_image', 
        'superior_phone', 
        'superior_gender', 
        'superior_marital_status', 
        'superior_alternative_phone', 
        'superior_email', 
        'superior_fb_link',
        'superior_twitter_link',
        'superior_social_media_1',
        'superior_social_media_2',
        'superior_qualification',
        'superior_qualification_other',
        'superior_wedding_date',
        'superior_interests',
        'superior_created_by',
        'deleted_by'
    ];

    // Model Relations
    public function createdPerson()
    {
        return $this->belongsTo(User::class , 'superior_created_by');
    }
}
