<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Students_group1_profile extends Model
{
    use HasFactory;
    protected $fillable =[
        'student_id' ,
        'main_complaint' ,
        'problem_start_at' ,
        'time_of_increasing_problem_feeling' ,
        'time_of_decreasing_problem_feeling' ,
        'problem_as_child_view' ,
        'problem_as_father_view' ,
        'problem_as_mother_view' ,
        'problem_reasons' ,
        'student_diseases' ,
        'previous_treatment_efforts' ,
        'genetic_diseases' ,
        'injuries_and_wounds' ,

        'father_age_when_applying' ,
        'father_age_at_student_birth' ,
        'father_relation_with_child' ,
        'child_attitudes_towards_father' ,
        'mother_age_when_applying' ,
        'mother_age_at_student_birth' ,
        'mother_relation_with_child' ,
        'child_attitudes_towards_mother' ,
        'superior_age_when_applying' ,
        'superior_age_at_student_birth' ,
        'superior_relation_with_child' ,
        'child_attitudes_towards_superior' ,


        'relation_between_parents' ,
        'main_problems_between_parents' ,
        'child_attitude_towards_family_problems' ,
        'brothers_and_sisters' ,
        'brothers_and_sisters_notes' ,
        'are_relatives' ,
        'other_relatives' ,
        'other_relatives_notes' ,
        'economic_situation' ,
        'monthly_average_income' ,
        'monthly_average_expenses' ,
        'family_economic_problems' ,
        'family_child_acceptance' ,
        'home_type' ,
        'no_persons_in_room' ,
        'has_child_individual_room' ,
        'no_father_married' ,
        'no_mother_married' ,
        'family_divorce_cases' ,
        'family_stress_source' ,
        'family_entertainment_source' ,
        'family_entertainment_source_child_involve' ,
        'psychological_social_conditions_affect_child' 
    ];

    // Model Relations
    public function students()
    {
        return $this->hasOne(Student::class);
    }
}
