<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Submission extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'student_id', 
        'assignment_id', 
        'assignment_information_provider', 
        'answer', 
        'final_report', 
        'assignment_shortname', 
        'business_id', 
        'trainer_id', 
        'deleted_by' 
    ];

    // Model Relations
    public function student()
    {
        return $this->belongsTo(Student::class, 'student_id');
    }

    public function assignment()
    {
        return $this->belongsTo(Assignment::class, 'assignment_id');
    }

    public function trainer()
    {
        return $this->belongsTo(Trainer::class, 'trainer_id');
    }

    public function businessLocation()
    {
        return $this->belongsTo(Business_location::class, 'business_id');
    }

}
