<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;

class Trainer extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable =[
        'user_id', 
        // 'user_name', 
        // 'full_name', 
        // 'address', 
        // 'city', 
        // 'state', 
        // 'country', 
        // 'landmark', 
        // 'nationality', 
        // 'dob', 
        // 'gender', 
        // 'national_number', 
        // 'image', 
        // 'phone', 
        // 'alternative_phone', 
        // 'email', 
        // 'password', 
        'website', 
        'specialization', 
        'university', 
        'graduation_date', 
        'expereience', 
        'qualification', 
        'qualification_other', 
        'membership', 
        'previous_job', 
        'previous_job_address', 
        'previous_job_country', 
        // 'language', 
        'business_id', 
        'join_job_date', 
        // 'marital_status', 
        // 'blood_group', 
        // 'fb_link', 
        // 'twitter_link', 
        // 'social_media_1', 
        // 'social_media_2', 
        // 'allow_login', 
        // 'is_active', 
        'created_by', 
        'deleted_by'
    ];

    // Model Relations
    public function users()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function businessLocation()
    {
        return $this->belongsTo(Business_location::class, 'business_id');
    }
}
