<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\SoftDeletes;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable, SoftDeletes;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_name',
        'full_name',
        'email',
        'password',
        'address',
        'city',
        'state',
        'country',
        'landmark',
        'phone',
        'alternative_phone',
        'language',
        'image',
        'business_id',
        'dob',
        'nationality',
        'national_number',
        'gender',
        'marital_status',
        'blood_group',
        'contact_number',
        'fb_link',
        'twitter_link',
        'social_media_1',
        'social_media_2',
        // 'allow_login',
        'created_by',
        'is_active',
        'role',
        'api_token',
        'deleted_by'
    ];

    // Model Relations
    public function business_location()
    {
        return $this->belongsTo(Business_location::class , 'business_id');
    }

    public function students()
    {
        return $this->hasOne(Student::class);
    }


    public function trainers()
    {
        return $this->hasOne(Trainer::class);
    }

    // public function questions()
    // {
    //     return $this->hasOne(Question::class);
    // }

    public function assignments()
    {
        return $this->hasOne(Assignment::class);
    }

    public function contact_form()
    {
        return $this->hasOne(Contact_form::class);
    }

    public function submissions()
    {
        return $this->hasOne(Submission::class);
    }

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        // 'remember_token',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    // protected $casts = [
    //     'email_verified_at' => 'datetime',
    // ];
}
