<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('user_name')->unique();
            $table->string('full_name');
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable();
            $table->string('landmark')->nullable();
            $table->string('phone')->nullable();
            $table->string('alternative_phone')->nullable();
            $table->string('nationality')->nullable();
            $table->string('national_number')->nullable();
            $table->string('language')->nullable();
            $table->string('image')->nullable();
            // $table->foreignId('business_id')->constrained('business_locations')->nullable();
            $table->date('dob')->nullable();
            $table->string('gender')->nullable();   // ('male', 'female')
            // $table->enum('gender', ['male', 'female'])->nullable();
            $table->string('marital_status')->nullable();  //('single', 'married', 'unmarried', 'divorced')
            // $table->enum('marital_status', ['single', 'married', 'unmarried', 'divorced'])->nullable();
            $table->string('blood_group')->nullable();
            $table->string('contact_number')->nullable();
            $table->string('fb_link')->nullable();
            $table->string('twitter_link')->nullable();
            $table->string('social_media_1')->nullable();
            $table->string('social_media_2')->nullable();
            $table->string('allow_login')->default('Allowable');
            $table->string('is_active')->default('Active');
            $table->string('deleted_by')->nullable();
            $table->enum('role' , ['super_admin' , 'owner' , 'admin' , 'trainer'])->default('trainer');
            $table->string('api_token' , 64)->nullable();
            $table->string('created_by')->nullable();
            // $table->foreignId('deleted_by')->constrained('users')->nullable();
            $table->softDeletes();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
}
