<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBusinessLocationsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('business_locations', function (Blueprint $table) {
            $table->id();
            $table->string('business_name');
            $table->string('address');
            $table->string('phone');
            $table->string('alternative_phone');
            $table->string('email')->unique();
            $table->string('image')->nullable();
            $table->foreignId('owner_id')->nullable()->constrained('users');
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->date('license_start_date')->default();
            $table->date('license_end_date')->default();
            $table->bigInteger('max_students')->default('0');
            $table->bigInteger('max_assignments')->default('0');
            $table->bigInteger('max_submissions')->default('0');
            $table->bigInteger('max_admins')->default('0');
            $table->bigInteger('max_trainers')->default('0');
            $table->text('theme_color')->default("#006492");
            $table->string('is_active')->default('Active');
            $table->string('technical_supervisor');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('business_locations');
    }
}
