<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTrainersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('trainers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->nullable()->constrained('users');
            $table->string('website')->nullable();
        
            // Education INfo
            $table->string('specialization')->nullable();
            $table->string('university')->nullable();
            $table->date('graduation_date')->nullable();
            $table->string('expereience')->nullable();
            $table->string('qualification')->nullable();  //('bachelor', 'diploma', 'master', 'phd' , 'other')
            $table->string('qualification_other')->nullable();
            $table->string('membership')->nullable();  //American Board , Canadian Board , British Board , HELP Center Membership
            
            // Experience Ifno
            $table->string('previous_job')->nullable();
            $table->string('previous_job_address')->nullable();
            $table->string('previous_job_country')->nullable();
            
            // Business Info
            $table->foreignId('business_id')->nullable()->constrained('business_locations');
            $table->date('join_job_date')->nullable();

            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('trainers');
    }
}
