<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateAssignmentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('assignments', function (Blueprint $table) {
            $table->id();
            $table->longText('assignment_title');
            $table->longText('assignment_title_ar')->nullable();
            $table->string('assignment_shortname')->nullable();
            $table->longText('assignment_note')->nullable();
            $table->longText('assignment_note_ar')->nullable();
            $table->longText('assignment_instructions')->nullable();
            $table->longText('assignment_instructions_ar')->nullable();
            $table->longText('assignment_structure');
            $table->longText('assignment_questions');
            $table->longText('assignment_condition')->nullable();
            // $table->foreignId('business_id')->nullable()->constrained('business_locations');
            $table->foreignId('created_by')->nullable()->constrained('users');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('assignments');
    }
}
