<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateSubmissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('submissions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->nullable()->constrained('students');
            $table->foreignId('assignment_id')->nullable()->constrained('assignments');
            $table->string('assignment_information_provider')->nullable();
            $table->longText('answer')->nullable();
            $table->longText('final_report')->nullable();
            $table->string('assignment_shortname')->nullable();
            $table->foreignId('business_id')->nullable()->constrained('business_locations');
            $table->foreignId('trainer_id')->nullable()->constrained('trainers');
            $table->foreignId('deleted_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('submissions');
    }
}
