<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentParentsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_parents', function (Blueprint $table) {
            $table->id();
            // Parent Info
            $table->string('name');
            $table->string('gender')->nullable();   // ('male', 'female')
            // $table->enum('gender', ['male', 'female'])->nullable();
            $table->date('dob')->nullable();
            $table->integer('national_id')->nullable();
            $table->string('degree_of_kinship')->nullable();
            $table->string('address')->nullable();
            $table->string('city')->nullable();
            $table->string('state')->nullable();
            $table->string('country')->nullable();
            $table->string('landmark')->nullable();
            $table->string('job')->nullable();
            $table->string('img')->nullable();

            // Contact Info
            $table->integer('phone')->nullable();
            $table->integer('alternative_phone')->nullable();
            $table->string('email')->unique();
            $table->string('fb_link')->nullable();
            $table->string('twitter_link')->nullable();
            $table->string('social_media_1')->nullable();
            $table->string('social_media_2')->nullable();
            
            // Education INfo
            $table->string('qualification')->nullable();  //('bachelor', 'diploma', 'master', 'phd' , 'other')
            // $table->enum('qualification', ['bachelor', 'diploma', 'master', 'phd' , 'other'])->nullable();
            $table->string('qualification_other')->nullable();
            
            // Wedding Date
            $table->date('wedding_date')->nullable();
            
            // Information about family history
            $table->string('interests')->nullable();
            $table->string('age_at_student_birth')->nullable();
            $table->string('relation_with_child')->nullable();
            $table->string('attitudes_towards_parent')->nullable();
            $table->integer('pregnancy_number')->nullable();    //For Female
            $table->integer('miscarriages_number')->nullable();    //For Female
            


            $table->foreignId('deleted_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_parents');
    }
}
