<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateForeignKeysTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('business_location_id')->nullable()->constrained('business_locations');
            
        });

        Schema::table('students', function (Blueprint $table) {
            // Father Info
            $table->foreignId('father_id')->nullable()->constrained('student_father_profiles');
            
            // Mother Info
            $table->foreignId('mother_id')->nullable()->constrained('student_mother_profiles');
            
            // Superior
            $table->string('superior')->nullable();  // ('0' , '1')
            $table->foreignId('superior_id')->nullable()->constrained('student_superior_profiles');
            
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('foreign_keys');
    }
}
