<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentsGroup1ProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students_group1_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->nullable();
            
            // Main Problem
            $table->string('main_complaint')->nullable();
            $table->date('problem_start_at')->nullable();
            $table->text('time_of_increasing_problem_feeling')->nullable();
            $table->text('time_of_decreasing_problem_feeling')->nullable();
            $table->text('problem_as_child_view')->nullable();
            $table->text('problem_as_father_view')->nullable();
            $table->text('problem_as_mother_view')->nullable();
            $table->text('problem_reasons')->nullable();
            
            // Student diseases which has a realtion with the problem
            $table->text('student_diseases')->nullable();  //array of object with diseases (disease , age_at_injury , disease_duration , disease_degree)
            
            // Previous treatment efforts
            $table->text('previous_treatment_efforts')->nullable();  //array of object with Previous treatment efforts (medical_institution , provided_service , provided_service_effects (possitive or negative) , notes)
            
            // Genetic diseases in the family
            $table->text('genetic_diseases')->nullable();  //array of object with Genetic diseases in the family (name , age_at_injury , degree_of_kinship , disease , notes)
            
            // Injuries and wounds
            $table->text('injuries_and_wounds')->nullable();  //array of object with Genetic diseases in the family (injury , age_at_injury , provided_service , result , notes)
                    
            // Father Info
            $table->string('father_age_when_applying')->nullable();
            $table->string('father_age_at_student_birth')->nullable();
            $table->string('father_relation_with_child')->nullable();
            $table->string('child_attitudes_towards_father')->nullable();
                    
            // Mother Info
            $table->string('mother_age_when_applying')->nullable();
            $table->string('mother_age_at_student_birth')->nullable();
            $table->string('mother_relation_with_child')->nullable();
            $table->string('child_attitudes_towards_mother')->nullable();
                    
            // Superior Info
            $table->string('superior_age_when_applying')->nullable();
            $table->string('superior_age_at_student_birth')->nullable();
            $table->string('superior_relation_with_child')->nullable();
            $table->string('child_attitudes_towards_superior')->nullable();
                    
            // Relation Between Parents
            $table->string('relation_between_parents')->nullable();   //('good', 'normal' , 'not_stable' , 'divorce')
            // $table->enum('relation_between_parents', ['good', 'normal' , 'not_stable' , 'divorce'])->nullable();   
            $table->text('main_problems_between_parents')->nullable();   
            $table->text('child_attitude_towards_family_problems')->nullable();   
            
            // Brothers and sisters in order 
            $table->text('brothers_and_sisters')->nullable();   //Array of objects  (name , dob , relationship , gender , job , status , education level , relation with student , student relation)
            $table->text('brothers_and_sisters_notes')->nullable();   
            
            // Relatives living with the family
            $table->string('are_relatives')->nullable();   //yes , no
            $table->text('other_relatives')->nullable();   //Array of objects  (name , dob , relationship , gender , job , status , education level , relation with student , student relation)
            $table->text('other_relatives_notes')->nullable();   
            
            // The standard of living for the family
            $table->text('economic_situation')->nullable();   
            $table->text('monthly_average_income')->nullable();   
            $table->text('monthly_average_expenses')->nullable();   
            $table->text('family_economic_problems')->nullable();   
            $table->text('family_child_acceptance')->nullable();   
            $table->text('home_type')->nullable();   
            $table->text('no_persons_in_room')->nullable();   
            $table->string('has_child_individual_room')->nullable();   //yes , no
            $table->integer('no_father_married')->nullable();   
            $table->integer('no_mother_married')->nullable();   
            $table->text('family_divorce_cases')->nullable();   
            $table->text('family_stress_source')->nullable();   
            $table->text('family_entertainment_source')->nullable();   
            $table->text('family_entertainment_source_child_involve')->nullable();   
            $table->text('psychological_social_conditions_affect_child')->nullable();   

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students_group1_profiles');
    }
}
