<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentsGroup2ProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students_group2_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->nullable();
            
            // Member Growth history
            $table->text('mother_diseases_during_pregnancy')->nullable();   
            $table->text('mother_pregnancy_type')->nullable();   
            $table->text('disturbances_during_childbirth')->nullable();   
            $table->text('mother_pregnancy_injuries')->nullable();   
            $table->text('child_weight_at_birth')->nullable();   
            $table->string('breastfeeding_type')->nullable();   //Noraml , Not Normal
            $table->text('breastfeeding_type_note')->nullable();   
            $table->integer('child_age_on_weaning')->nullable();  
            $table->text('weaning_problems')->nullable();  
            
            // Child Age Info 
            $table->integer('child_age_on_first_tooth')->nullable();   
            $table->integer('child_age_on_sitting')->nullable();   
            $table->integer('child_age_on_crawls')->nullable();   
            $table->integer('child_age_on_stand_up')->nullable();   
            $table->integer('child_age_on_walking')->nullable();   
            $table->integer('child_age_on_first_word')->nullable();   
            $table->integer('child_age_on_open_door')->nullable();   
            $table->integer('child_age_on_use_spoon')->nullable();   
            $table->integer('child_age_on_adjust_output_process')->nullable();  
            
            // Child current health problems
            $table->string('does_health_problems')->nullable();  //yes , no
            $table->text('current_health_problems')->nullable();   
            
            // Child regularly medicines 
            $table->string('does_regularly_medicines')->nullable();  //yes , no
            $table->text('regularly_medicines')->nullable();   
            
            // Child complex disabilities
            $table->string('does_complex_disabilities')->nullable();  //No disabilities , Mentality, kinetics , Audio , Visual , other
            $table->text('complex_disabilities_other')->nullable();  
            $table->string('does_prosthetic_devices')->nullable();  //yes , no
            $table->text('prosthetic_devices')->nullable();   
            
            // Personality traits
            $table->string('personality_traits')->nullable();  //introvert , diastolic
            $table->text('personality_traits_details')->nullable();   
            $table->string('relation_with_friends')->nullable();  //submission , Engagement , Get away
            $table->string('relation_with_relatives')->nullable();  //submission , Engagement , Get away
            $table->string('relation_with_neighbour')->nullable();  //submission , Engagement , Get away
            $table->string('relation_with_other_gender')->nullable();  //submission , Engagement , Get away
            $table->string('upbringing_style')->nullable();  //intensity , soft , Overprotection , neglect , complacency , Other methods
            
            // Physical or mental reinforcements
            $table->text('reinforcements')->nullable();  
            // $table->string('first_reinforcements')->nullable();  
            // $table->string('second_reinforcements')->nullable();  
            // $table->string('third_reinforcements')->nullable();  
            // $table->string('fourth_reinforcements')->nullable();  
            
            // Is the child subjected to punishment?
            $table->string('is_punishment')->nullable();  //yes , no , maybe
            $table->text('punishment_reasons')->nullable();   
            $table->text('child_behavior_notes')->nullable();   
            $table->string('source_of_authority')->nullable();  //father , mother
            $table->text('source_of_authority_notes')->nullable();   
            
            // Child behavior
            $table->string('crying')->nullable();  //always , Sometimes , no
            $table->string('talkative')->nullable();  //always , Sometimes , no
            $table->string('lots_of_movement')->nullable();  //always , Sometimes , no
            $table->string('orderly_plan')->nullable();  //always , Sometimes , no
            $table->string('damages')->nullable();  //always , Sometimes , no
            $table->string('find_around_place')->nullable();  //always , Sometimes , no
            $table->string('grieves_with_specialist')->nullable();  //always , Sometimes , no
            $table->string('afraid')->nullable();  //always , Sometimes , no
            $table->string('enjoys')->nullable();  //always , Sometimes , no
            $table->string('runs_randomly')->nullable();  //always , Sometimes , no
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students_group2_profiles');
    }
}
