<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentsGroup3ProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students_group3_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->nullable();
            
            // The main neurological and behavioral symptoms
            $table->string('outbursts_of_anger')->nullable();  //always , Sometimes , no
            $table->string('outbursts_of_anger_time')->nullable();  
            $table->string('outbursts_of_anger_degree')->nullable();  
            $table->string('finger_sucking')->nullable();  //always , Sometimes , no
            $table->string('finger_sucking_time')->nullable();  
            $table->string('finger_sucking_degree')->nullable();  
            $table->string('wetting_bed')->nullable();  //always , Sometimes , no
            $table->string('wetting_bed_time')->nullable();  
            $table->string('wetting_bed_degree')->nullable();  
            $table->string('night_screams_of_terror')->nullable();  //always , Sometimes , no
            $table->string('night_screams_of_terror_time')->nullable();
            $table->string('night_screams_of_terror_degree')->nullable();
            $table->string('sleep_walking')->nullable();  //always , Sometimes , no
            $table->string('sleep_walking_time')->nullable(); 
            $table->string('sleep_walking_degree')->nullable(); 
            $table->string('excessive_fears')->nullable();  //always , Sometimes , no
            $table->string('excessive_fears_time')->nullable();  
            $table->string('excessive_fears_degree')->nullable();  
            $table->string('nervous_crises')->nullable();  //always , Sometimes , no
            $table->string('nervous_crises_time')->nullable();  
            $table->string('nervous_crises_degree')->nullable();  
            $table->string('cramps')->nullable();  //always , Sometimes , no
            $table->string('cramps_time')->nullable();
            $table->string('cramps_degree')->nullable();
            $table->string('biting_nails')->nullable();  //always , Sometimes , no
            $table->string('biting_nails_time')->nullable(); 
            $table->string('biting_nails_degree')->nullable(); 
            $table->string('smash_clothes')->nullable();  //always , Sometimes , no
            $table->string('smash_clothes_time')->nullable();  
            $table->string('smash_clothes_degree')->nullable();  
            $table->string('stereotyped_movements')->nullable();  //always , Sometimes , no
            $table->string('stereotyped_movements_time')->nullable();  
            $table->string('stereotyped_movements_degree')->nullable();  
            $table->string('baby_gets_nervous_from_loud_noises')->nullable();  //always , Sometimes , no
            $table->string('baby_gets_nervous_from_loud_noises_time')->nullable(); 
            $table->string('baby_gets_nervous_from_loud_noises_degree')->nullable(); 
            $table->string('baby_gets_nervous_from_bright_lights')->nullable();  //always , Sometimes , no
            $table->string('baby_gets_nervous_from_bright_lights_time')->nullable();  
            $table->string('baby_gets_nervous_from_bright_lights_degree')->nullable();  
            $table->string('sexual_behaviors')->nullable();  //always , Sometimes , no
            $table->string('sexual_behaviors_time')->nullable(); 
            $table->string('sexual_behaviors_degree')->nullable(); 
            $table->string('epileptic_seizures')->nullable();  //always , Sometimes , no
            $table->string('epileptic_seizures_time')->nullable();  
            $table->string('epileptic_seizures_degree')->nullable();  
            
            // Child's social problems
            $table->string('difficulty_interacting_with_peers')->nullable();  //always , Sometimes , no
            $table->text('difficulty_interacting_with_peers_desc')->nullable();  
            $table->string('extra_activity')->nullable();  //always , Sometimes , no
            $table->text('extra_activity_desc')->nullable();  
            $table->string('make_fun_of_others')->nullable();  //always , Sometimes , no
            $table->text('make_fun_of_others_desc')->nullable();  
            $table->string('can_not_wait')->nullable();  //always , Sometimes , no
            $table->text('can_not_wait_desc')->nullable();  
            $table->string('curses_and_says_inappropriate_words')->nullable();  //always , Sometimes , no
            $table->text('curses_and_says_inappropriate_words_desc')->nullable();  
            $table->string('acts_inappropriately')->nullable();  //always , Sometimes , no
            $table->text('acts_inappropriately_desc')->nullable();  
            $table->string('very_shy')->nullable();  //always , Sometimes , no
            $table->text('very_shy_desc')->nullable();  
            $table->string('speaks_low_voice')->nullable();  //always , Sometimes , no
            $table->text('speaks_low_voice_desc')->nullable();  
            $table->string('not_defend_himself')->nullable();  //always , Sometimes , no
            $table->text('not_defend_himself_desc')->nullable();  
            $table->string('afraid_of_animals')->nullable();  //always , Sometimes , no
            $table->text('afraid_of_animals_desc')->nullable();  
            $table->string('hesitant_and_confused')->nullable();  //always , Sometimes , no
            $table->text('hesitant_and_confused_desc')->nullable();  
            $table->string('feeling_powerless_and_lacking_in_self_confidence')->nullable();  //always , Sometimes , no
            $table->text('feeling_powerless_and_lacking_in_self_confidence_desc')->nullable();  
            $table->string('feeling_tense_and_refuses_to_hug')->nullable();  //always , Sometimes , no
            $table->text('feeling_tense_and_refuses_to_hug_desc')->nullable();  
            $table->text('other_social_problems')->nullable();  

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students_group3_profiles');
    }
}
