<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentsGroup4ProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('students_group4_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('student_id')->constrained()->nullable();
            
            // Previous psychological examinations
            $table->string('last_psychological_examination_name')->nullable();
            $table->date('last_psychological_examination_date')->nullable();
            
            // Previous mental disorders
            $table->text('previous_mental_disorders')->nullable();  //turbulence , age , duration , healer , results(positive or negative)
            
            // Intelligence and previous ability tests
            $table->string('first_intelligence_and_ability_test_name')->nullable();
            $table->string('first_intelligence_and_ability_test_date')->nullable();
            $table->string('first_intelligence_and_ability_test_reason')->nullable();
            $table->string('first_intelligence_and_ability_test_result')->nullable();
            $table->string('first_intelligence_and_ability_test_who_recommended_it')->nullable();
            $table->text('first_intelligence_and_ability_test_explan')->nullable();
            $table->text('first_intelligence_and_ability_test_recommendations')->nullable();
            $table->string('second_intelligence_and_ability_test_name')->nullable();
            $table->string('second_intelligence_and_ability_test_date')->nullable();
            $table->string('second_intelligence_and_ability_test_reason')->nullable();
            $table->string('second_intelligence_and_ability_test_result')->nullable();
            $table->string('second_intelligence_and_ability_test_who_recommended_it')->nullable();
            $table->text('second_intelligence_and_ability_test_explan')->nullable();
            $table->text('second_intelligence_and_ability_test_recommendations')->nullable();
            $table->string('third_intelligence_and_ability_test_name')->nullable();
            $table->string('third_intelligence_and_ability_test_date')->nullable();
            $table->string('third_intelligence_and_ability_test_reason')->nullable();
            $table->string('third_intelligence_and_ability_test_result')->nullable();
            $table->string('third_intelligence_and_ability_test_who_recommended_it')->nullable();
            $table->text('third_intelligence_and_ability_test_explan')->nullable();
            $table->text('third_intelligence_and_ability_test_recommendations')->nullable();
            $table->string('fourth_intelligence_and_ability_test_name')->nullable();
            $table->string('fourth_intelligence_and_ability_test_date')->nullable();
            $table->string('fourth_intelligence_and_ability_test_reason')->nullable();
            $table->string('fourth_intelligence_and_ability_test_result')->nullable();
            $table->string('fourth_intelligence_and_ability_test_who_recommended_it')->nullable();
            $table->text('fourth_intelligence_and_ability_test_explan')->nullable();
            $table->text('fourth_intelligence_and_ability_test_recommendations')->nullable();
            
            // The independence side
            $table->string('eats_alone_without_help')->nullable();  //always , Sometimes , no
            $table->string('gets_dressed_without_help')->nullable();  //always , Sometimes , no
            $table->string('asking_to_go_to_the_bathroom')->nullable();  //always , Sometimes , no
            $table->string('takes_care_of_himself_in_bathroom')->nullable();  //always , Sometimes , no
            
            // Linguistic side
            $table->string('use_of_yelling_to_express')->nullable();  //yes , no
            $table->string('pay_attention_to_sounds')->nullable();  //yes , no
            $table->string('distinguish_mother_and_father_voice')->nullable();  //yes , no
            $table->string('distinguish_family_members_voice')->nullable();  //yes , no
            $table->string('using_audio_clips')->nullable();  //yes , no
            $table->string('pronounces_word_understandable')->nullable();  //yes , no
            $table->string('turns_around_when_he_hears_his_name')->nullable();  //yes , no
            $table->string('looking_the_person_speaking_during_conversation')->nullable();  //yes , no
            $table->string('uses_two_words_sentence')->nullable();  //yes , no
            $table->string('needs_encouragement_to_speak')->nullable();  //yes , no
            $table->string('uses_expressive_language_to_express_his_needs')->nullable();  //yes , no
            $table->string('stutters_while_speaking')->nullable();  //yes , no
            $table->string('remove_letters_from_words')->nullable();  //yes , no
            $table->string('add_letters_to_words')->nullable();  //yes , no
            $table->string('turns_some_letters_in_word')->nullable();  //yes , no
            $table->string('changes_some_letters_when_saying_word')->nullable();  //yes , no
            $table->string('speaks_but_the_words_are_distorted_and_incomprehensible')->nullable();  //yes , no
            $table->string('understands_what_is_asked_of_him')->nullable();  //yes , no
            
            // Child's language problems
            $table->string('language_level')->nullable();  //very weak , weak , acceptable , good
            $table->string('level_of_expression_of_his_needs_linguistically')->nullable();  //very weak , weak , acceptable , good
            $table->string('level_of_coherence_of_ideas')->nullable();  //very weak , weak , acceptable , good
            $table->string('speed_level')->nullable();  //very weak , weak , acceptable , good
            $table->string('response')->nullable();  //very weak , weak , acceptable , good

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('students_group4_profiles');
    }
}
