<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentFatherProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_father_profiles', function (Blueprint $table) {
            $table->id();
            // Parent Info
            $table->string('father_name');
            $table->date('father_dob')->nullable();
            $table->string('father_nationality')->nullable();
            $table->string('father_national_number')->nullable();
            $table->string('father_degree_of_kinship')->nullable();
            $table->string('father_address')->nullable();
            $table->string('father_city')->nullable();
            $table->string('father_state')->nullable();
            $table->string('father_country')->nullable();
            $table->string('father_landmark')->nullable();
            $table->string('father_job')->nullable();
            $table->string('father_image')->nullable();
            $table->string('father_marital_status')->nullable();

            // Contact Info
            $table->bigInteger('father_phone')->nullable();
            $table->bigInteger('father_alternative_phone')->nullable();
            $table->string('father_email')->unique();
            $table->string('father_fb_link')->nullable();
            $table->string('father_twitter_link')->nullable();
            $table->string('father_social_media_1')->nullable();
            $table->string('father_social_media_2')->nullable();
            
            // Education INfo
            $table->string('father_qualification')->nullable();  //('bachelor', 'diploma', 'master', 'phd' , 'other')
            // $table->enum('qualification', ['bachelor', 'diploma', 'master', 'phd' , 'other'])->nullable();
            $table->string('father_qualification_other')->nullable();
            
            // Wedding Date
            $table->date('father_wedding_date')->nullable();
            
            // Information about family history
            $table->string('father_interests')->nullable();
            


            $table->foreignId('father_created_by')->nullable()->constrained('users');      

            $table->foreignId('deleted_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_father_profiles');
    }
}
