<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentMotherProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_mother_profiles', function (Blueprint $table) {
            $table->id();
            // Parent Info
            $table->string('mother_name');
            $table->date('mother_dob')->nullable();
            $table->string('mother_nationality')->nullable();
            $table->string('mother_national_number')->nullable();
            $table->string('mother_degree_of_kinship')->nullable();
            $table->string('mother_address')->nullable();
            $table->string('mother_city')->nullable();
            $table->string('mother_state')->nullable();
            $table->string('mother_country')->nullable();
            $table->string('mother_landmark')->nullable();
            $table->string('mother_job')->nullable();
            $table->string('mother_image')->nullable();
            $table->string('mother_marital_status')->nullable();

            // Contact Info
            $table->integer('mother_phone')->nullable();
            $table->integer('mother_alternative_phone')->nullable();
            $table->string('mother_email')->unique();
            $table->string('mother_fb_link')->nullable();
            $table->string('mother_twitter_link')->nullable();
            $table->string('mother_social_media_1')->nullable();
            $table->string('mother_social_media_2')->nullable();
            
            // Education INfo
            $table->string('mother_qualification')->nullable();  //('bachelor', 'diploma', 'master', 'phd' , 'other')
            // $table->enum('qualification', ['bachelor', 'diploma', 'master', 'phd' , 'other'])->nullable();
            $table->string('mother_qualification_other')->nullable();
            
            // Wedding Date
            $table->date('mother_wedding_date')->nullable();
            
            // Information about family history
            $table->string('mother_interests')->nullable();
            $table->integer('mother_pregnancy_number')->nullable();    //For Female
            $table->integer('mother_miscarriages_number')->nullable();    //For Female

            $table->foreignId('mother_created_by')->nullable()->constrained('users');      

            $table->foreignId('deleted_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_mother_profiles');
    }
}
