<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateStudentSuperiorProfilesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('student_superior_profiles', function (Blueprint $table) {
            $table->id();
            // Parent Info
            $table->string('superior_name');
            $table->date('superior_dob')->nullable();
            $table->string('superior_nationality')->nullable();
            $table->string('superior_national_number')->nullable();
            $table->string('superior_degree_of_kinship')->nullable();
            $table->string('superior_address')->nullable();
            $table->string('superior_city')->nullable();
            $table->string('superior_state')->nullable();
            $table->string('superior_country')->nullable();
            $table->string('superior_landmark')->nullable();
            $table->string('superior_job')->nullable();
            $table->string('superior_image')->nullable();
            $table->string('superior_gender')->nullable();   // ('male', 'female')
            $table->string('superior_marital_status')->nullable();

            // Contact Info
            $table->integer('superior_phone')->nullable();
            $table->integer('superior_alternative_phone')->nullable();
            $table->string('superior_email')->unique();
            $table->string('superior_fb_link')->nullable();
            $table->string('superior_twitter_link')->nullable();
            $table->string('superior_social_media_1')->nullable();
            $table->string('superior_social_media_2')->nullable();
            
            // Education INfo
            $table->string('superior_qualification')->nullable();  //('bachelor', 'diploma', 'master', 'phd' , 'other')
            // $table->enum('qualification', ['bachelor', 'diploma', 'master', 'phd' , 'other'])->nullable();
            $table->string('superior_qualification_other')->nullable();
            
            // Wedding Date
            $table->date('superior_wedding_date')->nullable();
            
            // Information about family history
            $table->string('superior_interests')->nullable();
    

            $table->foreignId('superior_created_by')->nullable()->constrained('users');      

            $table->foreignId('deleted_by')->nullable()->constrained('users');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('student_superior_profiles');
    }
}
