@extends('layouts.app_layout')

@section('title')
    View Submission - {{ $report->report_title }}
@endsection

@section('content')
    <i class="fa-solid fa-print text-custome fs-3 float-end" onclick="printData()"></i>
    <div class="clearfix"></div>
    <div class="container" id="dataPrint">

        <div class="shadow rounded bg-white my-2  mx-auto pt-5 px-3 ">

            <h4 class="bg-gradient bg-title text-center w-75  m-auto rounded-pill text-white p-2">{{ $report->report_title }}</h4>
            <div class="row my-2">
                <div class="col-md">
                    <div class="border rounded-pill d-flex justify-content-between p-2">
                        <span>name</span>
                        <span class="text-custome">{{ $submissions[0]->student->student_name }}</span>
                        <span>الاسم</span>
                    </div>
                </div>
                <div class="col-md">
                    <div class="border rounded-pill  d-flex justify-content-between p-2">
                        <span>case id number</span>
                        <span class="text-custome">{{ $submissions[0]->student->national_number }}</span>
                        <span>رقم هويه الحاله</span>
                    </div>
                </div>

            </div>
            <div class="row my-2">
                <div class="col-md">
                    <div class="border rounded-pill d-flex justify-content-between p-2">
                        <span>gender</span>
                        <span class="text-custome">{{ $submissions[0]->student->gender }}</span>
                        <span>النوع</span>
                    </div>
                </div>
                <div class="col-md">
                    <div class="border rounded-pill  d-flex justify-content-between p-2">
                        <span>Ethnic background</span>
                        <span class="text-custome">..........</span>
                        <span>الخلفيه العرقيه</span>
                    </div>
                </div>
                <div class="col-md">
                    <div class="border rounded-pill  d-flex justify-content-between p-2">
                        <span>test Date</span>
                        <span class="text-custome">{{ $submissions[0]->created_at }}</span>
                        <span>تاريخ الفحص</span>
                    </div>
                </div>

            </div>
            <div class="row my-2">
                <div class="col-md">
                    <div class="border rounded-pill d-flex justify-content-between p-2">
                        <span>based on information from</span>
                        <span class="text-custome">..........</span>
                        <span>استنادا الى معلومات المقدمه من</span>
                    </div>
                </div>
                <div class="col-md">
                    <div class="border rounded-pill  d-flex justify-content-between p-2">
                        <span>rater's Name</span>
                        <span class="text-custome">{{ $submissions[0]->trainer->full_name }}</span>
                        <span>اسم الفاحص</span>
                    </div>
                </div>

            </div>
            <div class="row my-2">



                <div class="col-md">
                    <div class="border rounded-pill  d-flex justify-content-between p-2">
                        <span>Date of Birth</span>
                        <span class="text-custome">{{ $submissions[0]->student->dob }}</span>
                        <span>تاريخ الميلاد</span>
                    </div>
                </div>
                <div class="col-md">
                    <div class="border rounded-pill  d-flex justify-content-between p-2">
                        <span>Years</span>
                        {{-- <span class="text-custome">{{\Carbon\Carbon::parse($submissions[0]->student->dob)->diff(\Carbon\Carbon::now())->format('%y years, %m months and %d days');}}</span> --}}
                        <span
                            class="text-custome">{{ \Carbon\Carbon::parse($submissions[0]->student->dob)->diff(\Carbon\Carbon::parse($submissions[0]->created_at))->format('%y years') }}</span>
                        <span>السنوات</span>
                    </div>
                </div>
                <div class="col-md">
                    <div class="border rounded-pill  d-flex justify-content-between p-2">
                        <span>months</span>
                        <span
                            class="text-custome">{{ \Carbon\Carbon::parse($submissions[0]->student->dob)->diff(\Carbon\Carbon::parse($submissions[0]->created_at))->format('%m months') }}</span>
                        <span>الشهور</span>
                    </div>
                </div>
                <div class="col-md">
                    <div class="border rounded-pill d-flex justify-content-between p-2">
                        <span>days</span>
                        <span
                            class="text-custome">{{ \Carbon\Carbon::parse($submissions[0]->student->dob)->diff(\Carbon\Carbon::parse($submissions[0]->created_at))->format('%d days') }}</span>
                        <span>الأيام</span>
                    </div>
                </div>

            </div>
            <div class="row my-2">

                <div class="col-md">
                    <p class="text-center text-muted mb-1">Note: Years , Months and Days formula is difference between test
                        date and student date of birth</p>
                    <p class="text-center text-muted ">ملاحظة : يتم حساب السنوات والشهور والأيام بايجاد الفرق بين تاريخ
                        الفحص وتاريخ الميلاد</p>
                </div>

            </div>
        </div>
        <div class="shadow rounded bg-white my-2  mx-auto py-5 px-3  text-center">


            <h4 class="bg-gradient bg-title mb-2 text-center w-75  m-auto rounded-pill text-white">
                <span>ملخص</span>
                <br>
                <span>summary</span>
            </h4>


            <table class="table table-striped text-end table-bordered">
                <thead>
                    <th>بنود</th>
                    <th>درجه</th>
                </thead>
                <tbody class="Degree">

                    <tr>

                        <td>3</td>
                        <td>
                            <span>Relating To People</span>/
                            <span>الإتصال بالناس</span>
                        </td>
                    </tr>
                    <tr>
                        <td>5</td>
                        <td>
                            <span>imitate</span>/
                            <span>التقليد</span>
                        </td>

                    </tr>
                    <tr>
                        <td>7</td>
                        <td>
                            <span>Emotional response</span>/
                            <span>الاستجابة العاطفية</span>
                        </td>

                    </tr>
                    <tr>
                        <td>4</td>
                        <td>
                            <span>Body use</span>/
                            <span>استخدام الجسم</span>
                        </td>

                    </tr>
                    <tr>
                        <td>3</td>
                        <td>
                            <span>Object use</span>/
                            <span>استخدام الأشياء</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span>Adaptation to change</span>/
                            <span>التكيف مع التغيير</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span>Visual responses</span>/
                            <span>الاستجابات البصرية</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span> Listening response</span>/
                            <span>الاستجابة السمعيه</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span>Results and use of taste, smell and touch</span>/
                            <span>استجابات واستخدام التذوق، الشم واللمس</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span>Fear or nervousness</span>/
                            <span>الخوف أو العصبية</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span>Verbal communication</span>/
                            <span>التواصل اللفظي</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span>The non -verbal communication</span>/
                            <span>التواصل غير اللفظي</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span> Level of activity</span>/
                            <span>مستوى النشاط</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span>Level and Consistency of Intellectual Response</span>/
                            <span>مستوى واتساق الاستجابة الفكرية</span>
                        </td>

                    </tr>
                    <tr>
                        <td>10</td>
                        <td>
                            <span>General impressions</span>/
                            <span>الإنطباع العام</span>
                        </td>

                    </tr>
                    <tr class="table-danger">
                        <td id="totalDegree">10</td>
                        <td>
                            <span class="m-0">total</span>/
                            <span class="m-0">اجمالي الدرجات</span>
                        </td>

                    </tr>
                </tbody>
            </table>
        </div>
        <div class="shadow rounded bg-white my-2  mx-auto py-5 px-3  text-center">

            <h4 class="bg-gradient bg-title mb-2 text-center w-75  m-auto rounded-pill text-white">التحليل العلمي ماعدا الانطباع العام
            </h4>
            <table class="table table-bordered text-end table-striped ">

                <tbody>
                    <tr>
                        <th>التقييم بــ 4</th>
                    </tr>
                    <tr>
                        <td id="result4">
                            لايوجد
                        </td>
                    </tr>
                    <tr>
                        <th>التقييم بــ 3.5</th>
                    </tr>
                    <tr>
                        <td id="result3.5">
                            لايوجد
                        </td>
                    </tr>
                    <tr>
                        <th>التقييم بــ 3</th>
                    </tr>
                    <tr>
                        <td id="result3">
                            لايوجد
                        </td>
                    </tr>
                    <tr>
                        <th>التقييم بــ 2.5</th>
                    </tr>
                    <tr>
                        <td id="result2.5">
                            لايوجد
                        </td>
                    </tr>
                    <tr>
                        <th>التقييم بــ 2</th>
                    </tr>
                    <tr>
                        <td id="result2">
                            لايوجد
                        </td>
                    </tr>
                    <tr>
                        <th>التقييم بــ 1.5</th>
                    </tr>
                    <tr>
                        <td id="result1.5">
                            لايوجد
                        </td>
                    </tr>
                    <tr>
                        <th>التقييم بــ 1</th>
                    </tr>
                    <tr>
                        <td id="result1">
                            لايوجد
                        </td>
                    </tr>
                </tbody>

            </table>
        </div>
        <div class="shadow d-none rounded bg-white my-2  mx-auto py-5 px-3  text-center">

            <h4 class="bg-gradient bg-title mb-2 text-center w-75  m-auto rounded-pill text-white">تحـليــل النتــائـــج</h4>
            <table class="table table-bordered text-end table-striped ">

                <tbody>
                    <tr>
                        <td></td>
                    </tr>
                    <tr>
                        <td></td>
                    </tr>
                    <tr>
                        <td></td>
                    </tr>

                </tbody>

            </table>
        </div>
        <div class="shadow rounded bg-white my-2  mx-auto py-5 px-3  text-end">

            <h4 class="bg-gradient bg-title mb-2 text-center w-75  m-auto rounded-pill text-white">تقسيم المؤشرات الرئيسيه للمقياس
            </h4>
            <div class="row align-items-center my-4">
                <div class="col-4">
                    <h5 class="text-center">مجموع درجات مؤشر التفاعل
                        االجتماعي</h5>
                    <p class="bg-danger  bg-gradient  rounded-3 py-3 text-center " id="total1">300</p>
                </div>
                <div class="col-8">
                    <h3 class="text-success">التفاعل االجتماعي</h3>
                    <p class="text-danger">المؤشرات الفرعية البنود:(1/2/3/7/8/11/12)</p>
                    <table class="table table-bordered text-end table-striped  table-middle">

                        <tbody>
                            <tr>
                                <td class="Bnod1">2</td>
                                <td>
                                    <span>Relating To People</span>/
                                    <span>الإتصال بالناس</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod2">5</td>
                                <td>
                                    <span>imitate</span>/
                                    <span>التقليد</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod3">7</td>
                                <td>
                                    <span>Emotional response</span>/
                                    <span>الاستجابة العاطفية</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod7">10</td>
                                <td>
                                    <span>Visual responses</span>/
                                    <span>الاستجابات البصرية</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod8">10</td>
                                <td>
                                    <span> Listening response</span>/
                                    <span>الاستجابة السمعيه</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod11">10</td>
                                <td>
                                    <span>Verbal communication</span>/
                                    <span>التواصل اللفظي</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod12">10</td>
                                <td>
                                    <span>The non -verbal communication</span>/
                                    <span>التواصل غير اللفظي</span>
                                </td>

                            </tr>
                        </tbody>

                    </table>
                </div>
            </div>


            <div class="row align-items-center my-4">
                <div class="col-4">
                    <h5 class="text-center">مجموع درجات مؤشر
                        التواصل
                    </h5>
                    <p class="bg-danger  bg-gradient  rounded-3 py-3 text-center" id="total2">300</p>
                </div>
                <div class="col-8">
                    <h3 class="text-success">التواصل</h3>
                    <p class="text-danger">المؤشرات الفرعية البنود:(5/6/11/12)</p>
                    <table class="table table-bordered text-end table-striped  table-middle">

                        <tbody>
                            <tr>
                                <td class="Bnod5">3</td>
                                <td>
                                    <span>Object use</span>/
                                    <span>استخدام الأشياء</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod6">10</td>
                                <td>
                                    <span>Adaptation to change</span>/
                                    <span>التكيف مع التغيير</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod11">10</td>
                                <td>
                                    <span>Verbal communication</span>/
                                    <span>التواصل اللفظي</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod12">10</td>
                                <td>
                                    <span>The non-verbal communication</span>/
                                    <span>التواصل غير اللفظي</span>
                                </td>

                            </tr>
                        </tbody>

                    </table>
                </div>
            </div>

            <div class="row align-items-center my-4">
                <div class="col-4">
                    <h5 class="text-center">مجموع درجات مؤشر الحركات
                        النمطية والسلوك التكراري
                    </h5>
                    <p class="bg-danger  bg-gradient  rounded-3 py-3 text-center" id="total3">300</p>
                </div>
                <div class="col-8">
                    <h3 class="text-success">الحركات النمطية والسلوك التكراري</h3>
                    <p class="text-danger">المؤشرات الفرعية البنود:(4/5/6/11/13)</p>
                    <table class="table table-bordered text-end table-striped  table-middle">

                        <tbody>
                            <tr>
                                <td class="Bnod4">4</td>
                                <td>
                                    <span>Body use</span>/
                                    <span>استخدام الجسم</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod5">3</td>
                                <td>
                                    <span>Object use</span>/
                                    <span>استخدام الأشياء</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod6">10</td>
                                <td>
                                    <span>Adaptation to change</span>/
                                    <span>التكيف مع التغيير</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod11">10</td>
                                <td>
                                    <span>Verbal communication</span>/
                                    <span>التواصل اللفظي</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod13">10</td>
                                <td>
                                    <span> Level of activity</span>/
                                    <span>مستوى النشاط</span>
                                </td>

                            </tr>
                        </tbody>

                    </table>
                </div>
            </div>
            <div class="row align-items-center my-4">
                <div class="col-4">
                    <h5 class="text-center">مجموع درجات مؤشر المظاهر
                        الحسية </h5>
                    <p class="bg-danger  bg-gradient  rounded-3 py-3 text-center " id="total4">300</p>
                </div>
                <div class="col-8">
                    <h3 class="text-success">المظاهر الحسية</h3>
                    <p class="text-danger">المؤشرات الفرعية البنود:(3/4/5/7/8/9/10/13)</p>
                    <table class="table table-bordered text-end table-striped  table-middle">

                        <tbody>

                            <tr>
                                <td class="Bnod3">7</td>
                                <td>
                                    <span>Emotional response</span>/
                                    <span>الاستجابة العاطفية</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod4">4</td>
                                <td>
                                    <span>Body use</span>/
                                    <span>استخدام الجسم</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod5">3</td>
                                <td>
                                    <span>Object use</span>/
                                    <span>استخدام الأشياء</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod7">10</td>
                                <td>
                                    <span>Visual responses</span>/
                                    <span>الاستجابات البصرية</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod8">10</td>
                                <td>
                                    <span> Listening response</span>/
                                    <span>الاستجابة السمعيه</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod9">10</td>
                                <td>
                                    <span>Results and use of taste, smell and touch</span>/
                                    <span>استجابات واستخدام التذوق، الشم واللمس</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod10">10</td>
                                <td>
                                    <span>Fear or nervousness</span>/
                                    <span>الخوف أو العصبية</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod13">10</td>
                                <td>
                                    <span> Level of activity</span>/
                                    <span>مستوى النشاط</span>
                                </td>

                            </tr>
                        </tbody>

                    </table>
                </div>
            </div>

            <div class="row align-items-center my-4">
                <div class="col-4">
                    <h5 class="text-center">مجموع درجات مؤشر الإدراك وأسلوب التفكير</h5>
                    <p class="bg-danger  bg-gradient  rounded-3 py-3 text-center " id="total5">300</p>
                </div>
                <div class="col-8">
                    <h3 class="text-success">الإدراك وأسلوب التفكر</h3>
                    <p class="text-danger">المؤشرات الفرعية البنود:(1/2/7/10/14)</p>
                    <table class="table table-bordered text-end table-striped  table-middle">

                        <tbody>
                            <tr>
                                <td class="Bnod1">2</td>
                                <td>
                                    <span>Relating To People</span>/
                                    <span>الإتصال بالناس</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod2">5</td>
                                <td>
                                    <span>imitate</span>/
                                    <span>التقليد</span>
                                </td>

                            </tr>

                            <tr>
                                <td class="Bnod7">10</td>
                                <td>
                                    <span>Visual responses</span>/
                                    <span>الاستجابات البصرية</span>
                                </td>

                            </tr>

                            <tr>
                                <td class="Bnod10">10</td>
                                <td>
                                    <span>Fear or nervousness</span>/
                                    <span>الخوف أو العصبية</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="Bnod14">10</td>
                                <td>
                                    <span>Level and Consistency of Intellectual Response</span>/
                                    <span>مستوى واتساق الاستجابة الفكرية</span>
                                </td>

                            </tr>
                        </tbody>

                    </table>
                </div>
            </div>

            <div class="row align-items-center my-4">

                <div class="col-md-12">
                    <h3 class="text-success">النسبة المئوية للمؤشرات الرئيسية</h3>

                    <table class="table table-bordered text-end table-striped  table-middle">

                        <tbody>
                            <tr>
                                <td class="table-danger" id="preceding1">10</td>
                                <td>

                                    <span>التفاعل االجتماعي</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="table-danger" id="preceding2">8</td>
                                <td>

                                    <span> التواصل
                                    </span>
                                </td>

                            </tr>

                            <tr>
                                <td class="table-danger" id="preceding3">7</td>
                                <td>

                                    <span> الحركات النمطية والاسلوك التكراري
                                    </span>
                                </td>

                            </tr>

                            <tr>
                                <td class="table-danger" id="preceding4">6</td>
                                <td>

                                    <span>المظاهر الحسية</span>
                                </td>

                            </tr>
                            <tr>
                                <td class="table-danger" id="preceding5">5</td>
                                <td>
                                    <span>Level and Consistency of Intellectual Response</span>/
                                    <span>الإدراك واتساق الاستجابة التعليمه</span>
                                </td>

                            </tr>
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
        <div class="shadow rounded bg-white my-2  mx-auto py-5 px-3  text-end">

            <h4 class="bg-gradient bg-title mb-2 text-center w-75  m-auto rounded-pill text-white">
                الرسم البياني للنسب المئوية
            </h4>
            <canvas id="oilChart" width="300" height="300"></canvas>
        </div>
        <div class="shadow rounded bg-white my-2  mx-auto py-5 px-3  text-end titlDescription">

            <h4 class="bg-gradient bg-title mb-2 text-center w-75  m-auto rounded-pill text-white">
                ملخص التقييم
            </h4>



            <h2 class="summary">
                الحركات النمطية والسلوك التكراري 
            </h2>
            <ol class="py-5"></ol>
            <h2 class="summary">التواصل </h2>

            <ol class="py-5"></ol>
            <h2 class="summary">
                المظاهر الحسية
            </h2>
            <ol class="py-5"></ol>
            <h2 class="summary">التفاعل الإجتماعي  </h2>

            <ol class="py-5"></ol>
            <h2 class="summary">الإدراك وإتساق الإستجابة التعليمية</h2>
            <ol class="py-5"></ol>



        </div>
        <div class="shadow rounded bg-white my-2  mx-auto py-5 px-3  text-end">

            <h4 class="bg-gradient bg-title mb-2 text-center w-75  m-auto rounded-pill text-white">
                التـوصيـــات
            </h4>
            <ol id="recommendation">

            </ol>

            <div class="my-5">
                <h4 class="bg-gradient bg-title mb-2 text-center w-75  m-auto rounded-pill text-white"> Final Report</h4>
                <h6 class="my-4">
                    {{ $submissions[0]->final_report }}
                </h6>
            </div>

            <div class="row  g-4 justify-content-end text-end">
                <div class="col d-flex align-items-baseline justify-content-around">
                    <p>{{ $submissions[0]->created_at }}</p>
                    <h5 class="text-custome">التاريخ</h5>
                </div>
                <div class="col d-flex  align-items-baseline justify-content-around">
                    <p>{{ $submissions[0]->trainer->full_name  }}</p>
                    <h5 class="text-custome">معد التقرير</h5>
                </div>
                <div class="col d-flex align-items-baseline justify-content-around">
                    <p>{{ $business_location->technical_supervisor }}</p>
                    <h5 class="text-custome">المشرف الفني</h5>
                </div>
                <div class="col d-flex  align-items-baseline justify-content-around">
                    <p>{{ $business_location->full_name }}</p>
                    <h5 class="text-custome">مدير المركز</h5>
                </div>
            </div>

        </div>
    </div>

    {{-- <a href="{{ route('allSubmissions') }}" class="btn btn-outline-primary mt-3">Back To All Assignments</a> --}}
    <a href="{{ route('allStudents') }}" class="btn  btn-outline-primary mt-3">Back To All Students</a>
@endsection
<script>
    var answers = <?php  echo $submissions[0]->answer;  ?>;
</script>

@section('scripts')
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/2.5.0/Chart.min.js"></script>
    <script src="{{ asset('js/report.js') }}"></script>
    <script src="{{ asset('js/reportPrint.js') }}"></script>
@endsection
