
$(document).ready(function () {


    $('.fa', '#example,#questions').toggleClass(['fa-table', 'fa-id-badge']);


    var dataTable = $('#example,#questions').DataTable({
        aLengthMenu: [[10, 25, 50, 75, -1], [10, 25, 50, 75, "All"]],
        iDisplayLength: 10,
        pagingType: 'full_numbers',
        dom: "<'row align-items-center'<'col-sm-12 col-md-3'l><'col-sm-12 col-md-6'B><'col-sm-12 col-md-3'f>>" +
            "<'row'<'col-sm-12'tr>>" +
            "<'row'<'col-sm-12 col-md-12'i><'col-sm-12 col-md-12'p>>",
        responsive: true,


        buttons: [

            {
                extend: 'csv',
                'text': '<i class="fa fa-id-badge fa-fw" aria-hidden="true"></i>',
                'action': function (e, dt, node) {
                    console.log(dt.table().node());
                    $(dt.table().node()).toggleClass('cards');
                    $(dt.table().node()).toggleClass(' table-borderless');
                    $(dt.table().node()).toggleClass(' table-bordered');
                    $(dt.table().node()).toggleClass('table-striped');
                    $('.fa', node).toggleClass(['fa-table', 'fa-id-badge']);

                    dt.draw('page');
                },
                'className': 'btn-sm',
                'attr': {
                    'title': 'Change views',
                }
            },
            {
                extend: 'excel',
                text: '<i class="fa fa-file-excel" aria-hidden="true"></i> ' + "Export to Excel",
                className: 'btn-sm',
                // exportOptions: {
                //     columns: ':visible',

                // },
                footer: true,
            },
            {
                extend: 'print',
                text: '<i class="fa fa-print" aria-hidden="true"></i> ' + "Export to Print",
                className: 'btn-sm',
                // exportOptions: {
                //     columns: ':visible',
                //     stripHtml: true,
                // },
                footer: true,
                customize: function (win) {
                    if ($('.print_table_part').length > 0) {
                        $($('.print_table_part').html()).insertBefore($(win.document.body).find('table'));
                    }
                    if ($(win.document.body).find('table.hide-footer').length) {
                        $(win.document.body).find('table.hide-footer tfoot').remove();
                    }
                    __currency_convert_recursively($(win.document.body).find('table'));
                }
            },

        ],
        select: 'single',
        language: {
            search: "_INPUT_",
            searchPlaceholder: "Search...",
            "paginate": {
                "first": '<i class="fa fa-angle-double-left"></i>',
                "previous": '<i class="fa fa-angle-left"></i>',
                "next": '<i class="fa fa-angle-right"></i>',
                "last": '<i class="fa fa-angle-double-right"></i>'
            },
        },
        "columnDefs": [{
            "searchable": false,
            "orderable": false,
            "targets": 0
        }],
        "order": [[0, 'asc']]
        ,
    });
    dataTable.on('order.dt search.dt', function () {
        dataTable.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
    dataTable.on('select', function (e, dt, type, indexes) {
        var rowData = table.rows(indexes).data().toArray()
        $('#row-data').html(JSON.stringify(rowData));
    })
    dataTable.on('deselect', function () {
        $('#row-data').empty();
    })



    $(".export-button .print").on("click", function (e) {
        e.preventDefault(); dataTable.button(0).trigger()
    });

    $(".export-button .copy").on("click", function (e) {
        e.preventDefault(); dataTable.button(1).trigger()
    });

    $(".export-button .excel").on("click", function (e) {
        e.preventDefault(); dataTable.button(2).trigger()
    });

    $(".export-button .csv").on("click", function (e) {
        e.preventDefault(); dataTable.button(3).trigger()
    });

    $(".export-button .pdf").on("click", function (e) {
        e.preventDefault(); dataTable.button(4).trigger()
    });
    $(".switchParent").click((event) => {
        if (event.target.checked) {
            $(event.target).parents('.switchParent').siblings(".noParents").addClass("d-block").removeClass("d-none")
        }
        else {
            $(event.target).parents('.switchParent').siblings(".noParents").addClass("d-none").removeClass("d-block")
        }
    })


    // $(".nav-item").click((e) => {
    //     console.log($(e.target));
    //     $(e.target).addClass("active text-custome fw-bolder").parent().siblings().find(".nav-link").removeClass("active text-custome fw-bolder")
    //     console.log();
    // })

    $('#questions tbody').on('click', 'tr', function () {
        $(this).toggleClass(`selected ${$("#GroupUl .nav-link.active").attr("aria-controls")}`);
    });

});

if ($(window).width() <= 767) {
    $(".sidebar").addClass("hiddenMenu")
    $(".navbar-brand").addClass("d-none").removeClass("d-block")
    $("#minmus").find(".fa-hand-point-left").addClass("fa-hand-point-right").removeClass("fa-hand-point-left")
    $(".content").addClass("col-12").removeClass("offset-2").removeClass("col-10")
    $(".navbar").css("left", $(".sidebar").width())
}

// if ($(window).width() >= 768) {
//     $(".sidebar").removeClass("hiddenMenu")
//     $(".navbar-brand").removeClass("d-none").addClass("d-block")
//     $("#minmus").find(".fa-hand-point-right").addClass("fa-hand-point-left").removeClass("fa-hand-point-right")
//     $(".content").removeClass("col-md-12").addClass("offset-2").addClass("col-md-10")
//     $(".navbar").css("left", $(".sidebar").width())
// }
$("#minmus").click(() => {
    if ($("#minmus").find(".fa-hand-point-left").length > 0) {
        $(".sidebar").addClass("hiddenMenu")
        $(".navbar-brand").addClass("d-none").removeClass("d-block")
        $("#minmus").find(".fa-hand-point-left").addClass("fa-hand-point-right").removeClass("fa-hand-point-left")
        $(".content").addClass("col-12").removeClass("offset-2").removeClass("col-10")
        // $(".navbar").css("left", $(".sidebar").width())
        $(".navbar").addClass("ms-5").removeClass("offset-2")
    }
    else {
        $(".sidebar").removeClass("hiddenMenu")
        $(".navbar-brand").removeClass("d-none").addClass("d-block")
        $("#minmus").find(".fa-hand-point-right").addClass("fa-hand-point-left").removeClass("fa-hand-point-right")
        $(".content").removeClass("col-12").addClass("offset-2").addClass("col-10")
        // $(".navbar").css("left", $(".sidebar").width())
        $(".navbar").addClass("offset-2").removeClass("ms-5")
    }

})
function launchIntoFullscreen(element) {
    if (document.fullscreenElement === null) {
        element.requestFullscreen();
    } else if (element.mozRequestFullScreen) {
        element.mozRequestFullScreen();
    } else if (element.webkitRequestFullscreen) {
        element.webkitRequestFullscreen();
    } else if (element.msRequestFullscreen) {
        element.msRequestFullscreen();
    }
}
function exitFullscreen() {
    if (document.exitFullscreen) {
        document.exitFullscreen();
    } else if (document.mozCancelFullScreen) {
        document.mozCancelFullScreen();
    } else if (document.webkitExitFullscreen) {
        document.webkitExitFullscreen();
    }
}
$('body').on('click', '.fullScreen', function () {
    var ele = $(this), target_ele = ele.find('a .fa-expand');
    if (target_ele.length > 0) {
        launchIntoFullscreen(document.documentElement);
        target_ele.addClass('fa-compress');
        target_ele.removeClass('fa-expand');
    } else {
        exitFullscreen();
        ele.find('a i').addClass('fa-expand');
        ele.find('a i').removeClass('fa-compress');
    }
});



// $("#submit").click(() => {
//     let answers = [];
//     var indexs = $("input[name='index']")
//     var answersInps = $("input[name='answers']")
//     var image = $("input[name='image']")


//     for (let i = 0; i < indexs.length; i++) {


//         let answersObject = {
//             id: indexs[i].value,
//             answer_text: answersInps[i].value,
//             answer_image_url: image[i].value
//         }
//         answers.push(answersObject)

//     }

//     $("input[name='answersValue']").val(answers)
//     console.log(answers);
// })




function texteara(id){
    
    tinymce.init({
        selector:id,
        menubar: false,
        statusbar: false,
        plugins: 'autoresize anchor autolink charmap code codesample directionality fullpage help hr image imagetools insertdatetime link lists media nonbreaking pagebreak preview print searchreplace table template textpattern toc visualblocks visualchars',
        toolbar: 'h1 h2 bold italic strikethrough blockquote bullist numlist backcolor forecolor  | link image media | removeformat help fullscreen ',
        skin: 'bootstrap',
        toolbar_drawer: 'floating',
        min_height: 200,           
        autoresize_bottom_margin: 16,
        toolbar_mode: 'floating',
        tinycomments_mode: 'embedded',
        tinycomments_author: 'Author name',
        setup: (editor) => {
            editor.on('init', () => {
                editor.getContainer().style.transition="border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out"
            });
            editor.on('focus', () => {
                editor.getContainer().style.boxShadow="0 0 0 .2rem rgba(0, 123, 255, .25)",
                editor.getContainer().style.borderColor="#80bdff"
            });
            editor.on('blur', () => {
                editor.getContainer().style.boxShadow="",
                editor.getContainer().style.borderColor=""
            });
        }
    });
}

$(document).ready(function () {

    texteara("#assignment_note")
    texteara("#assignment_instructions")
    texteara("#assignment_note_ar")
    texteara("#assignment_instructions_ar")
    $("div.bhoechie-tab-menu>div.list-group>a").click(function (e) {
        e.preventDefault();
        $(this).siblings('a.active').removeClass("active");
        $(this).addClass("active");
        var index = $(this).index();
        $("div.bhoechie-tab>div.bhoechie-tab-content").removeClass("active");
        $("div.bhoechie-tab>div.bhoechie-tab-content").eq(index).addClass("active");
    });
    $(".outBox").css("right", `-${$('.innerBox').outerWidth()}px`)
    $(".cog").click(function () {

        if ($(".outBox").css("right") == '0px') {
            $(".outBox").animate({ right: `-${$('.innerBox').outerWidth()}px` }, 2000)
        }
        else {
            $(".outBox").animate({ right: `0px` }, 2000)
        }
    })
    $(".box").click(function () {

        localStorage.setItem("color", `${$(this).css("background-color")}`)
        $(":root").css({ "--mainColor": $(this).css("background-color") });
    })

});

if (localStorage.getItem("color") != null) {
    $(":root").css({ "--mainColor": localStorage.getItem("color") });
}

window.addEventListener("DOMContentLoaded", () => {
    const emojiRating = new EmojiRating(".emoji")
});

class EmojiRating {
    constructor(qs) {
        this.input = document.querySelectorAll(qs);

        if (this.input) {
            this.input.forEach((element) => {
                element.addEventListener("input", this.refreshValue.bind(this));
                element.value = element.min;
            })

        }
    }
    refreshValue(e) {

        e.target.defaultValue = e.target.value;
    }
}


function CheckPassword(data) {
    let password = $("input[data-password='myPass']")[0]
    if (password.value != data.value)
    {
        $(".invalid-Password").addClass("d-block")
        $('#submit').prop("disabled", true)
    }
    else{
        $(".invalid-Password").removeClass("d-block")
        $('#submit').prop("disabled", false)
    }
}