@extends('layouts.list')

@section('title')
    All Assignments
@endsection

@section('list-title')
    {{__('assignments.assignments')}}
@endsection

@section('list-navigation')
    <li>{{__('assignments.assignments')}}</li>
@endsection

@section('list-new-button')
@if (Auth::user()->role == "super_admin" || Auth::user()->role == "owner" || Auth::user()->role == "admin")
<a href="{{ route('createAssignment') }}" class="btn btn-outline-primary btn-sm me-2">
    <i class="fa-solid fa-plus me-2"></i>{{__('assignments.new_assignments')}}
</a>
@endif
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">{{__('assignments.assignment_title')}}</th>
    <th scope="col">{{__('assignments.business_location')}}</th>
    <th scope="col">{{__('assignments.created_by')}}</th>
    <th scope="col">{{__('assignments.actions')}}</th>
@endsection

@section('list-table-body')
    @foreach ($assignments as $assignment)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td class="Zindex">
                <h6 class="col-6">{{__('assignments.assignment_title')}}</h6>
                <a class="text-decoration-none col-6" href="{{ route('viewAssignment', $assignment->id) }}">
                    <p class="text-custome m-0 ">{{ $assignment->assignment_title }}</p>
                </a>
            </td>
        
            <td class="Zindex">
                <h6 class="col-6">{{__('assignments.created_by')}}</h6>
                <a class="text-decoration-none col-6" href="{{ route('viewUser', $assignment->created_by) }}">
                    <p class="text-custome m-0 ">{{ $assignment->createdPerson->full_name }}</p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('viewAssignment', $assignment->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                {{__('assignments.view')}}
                            </a>
                        </li>
                        @if (Auth::user()->role == "super_admin" || Auth::user()->role == "owner")
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('editAssignment', $assignment->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                {{__('assignments.edit')}}
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 "
                                href="{{ route('deleteAssignment', $assignment->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                {{__('assignments.delete')}}
                            </a>
                        </li>
                        @endif
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $assignments->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $assignments->links() }} --}}
@endsection
