@extends('layouts.app_layout')

@section('title')
All Assignments
@endsection

@section('content')

@if(session('message'))
    <h6 class="alert alert-success">
        {{ session('message') }}
    </h6>
@endif


<table id="example" class="table table-striped cell-border" style="width:100%">
    <thead>
      <tr>
        <th scope="col">Assignment Title</th>
        <th scope="col">Business Location</th>
        <th scope="col">Created By</th>
        <th scope="col">Actions</th>
      </tr>
    </thead>
    <tbody>
        @foreach ($assignments as $assignment)
      <tr>
        <td>
            <a href="{{route('viewAssignment' , $assignment->id )}}"><p>{{ $assignment->assignment_title }}</p></a>
        </td>
        <td>
            <a href="{{route('viewBusinessLocation' , $assignment->business_id )}}"><p>{{ $assignment->businessLocation->business_name }}</p></a>
        </td>
        <td>
            <a href="{{route('viewUser' , $assignment->created_by )}}"><p>{{ $assignment->createdPerson->full_name }}</p></a>
        </td>
        <td>
            <a href="{{ route('viewAssignment' , $assignment->id ) }}" class="btn btn-outline-primary mt-3">View</a>
            <a href="{{ route('editAssignment' , $assignment->id ) }}" class="btn btn-outline-primary mt-3">Edit</a>
            <a href="{{ route('deleteAssignment' , $assignment->id) }}" class="btn btn-outline-primary mt-3">Delete</a>
        </td>
      </tr>
      @endforeach
      
    </tbody>
</table>

{{ $assignments->links() }}



@endsection


