@extends('layouts.list')

@section('title')
    Search Assignments
@endsection

@section('list-title')
    Assignments
@endsection

@section('list-navigation')
    <li><a class="text-decoration-none" href="{{ route('allAssignments') }}">List Assignments </a></li>
    <li>Search Assignments</li>
@endsection

@section('list-new-button')
    <a href="{{ route('createAssignment') }}" class="btn btn-outline-primary btn-sm me-2">
        <i class="fa-solid fa-plus me-2"></i> New Assignments
    </a>
@endsection

@section('list-table-header')
    <th scope="col">#</th>
    <th scope="col">Assignment Title</th>
    <th scope="col">Business Location</th>
    <th scope="col">Created By</th>
    <th scope="col">Actions</th>
@endsection

@section('list-table-body')
    @foreach ($assignments as $assignment)
        <tr>
            <td>
                <p class="m-0 px-3">1</p>
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewAssignment', $assignment->id) }}">
                    <p class="text-custome m-0 px-3">{{ $assignment->assignment_title }}</p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewBusinessLocation', $assignment->business_id) }}">
                    <p class="text-custome m-0 px-3">{{ $assignment->businessLocation->business_name }}</p>
                </a>
            </td>
            <td>
                <a class="text-decoration-none" href="{{ route('viewUser', $assignment->created_by) }}">
                    <p class="text-custome m-0 px-3">{{ $assignment->createdPerson->full_name }}</p>
                </a>
            </td>
            <td>
                <div class="btn-group">

                    <i data-bs-toggle="dropdown" aria-expanded="false"
                        class="fa-solid fa-ellipsis  dropdown-toggle mx-3 opacity-75"></i>

                    <ul class="dropdown-menu px-2 py-3 shadow bg-white bg-gradient border-0">
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('viewAssignment', $assignment->id) }}">
                                <i class="fa-solid fa-eye me-2 text-custome"></i>
                                View
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('editAssignment', $assignment->id) }}">
                                <i class="fa-solid fa-pen-to-square me-2 text-warning"></i>
                                Edit
                            </a>
                        </li>
                        <li>
                            <a class="dropdown-item opacity-75 " href="{{ route('deleteAssignment', $assignment->id) }}">
                                <i class="fa-solid fa-trash-can me-2 text-danger"></i>
                                Delete
                            </a>
                        </li>
                    </ul>
                </div>
            </td>
        </tr>
    @endforeach
@endsection

@section('list-table-inside-pagination')
    {{-- <div class="d-flex">
    {!! $assignments->links() !!}
</div> --}}
@endsection

@section('list-pagination')
    {{-- {{ $assignments->links() }} --}}
@endsection
