@extends('layouts.app_layout')

@section('title')
View Assignment - {{ $assignment->assignment_title }}
@endsection

@section('content')
<div class="px-3">

    <div class="row align-items-center">
        <div class="col-sm-8">
            <h5 class="page-title-text d-inline-block">View Assignment - {{ $assignment->assignment_title }}</h5>
        </div>
        <div class="col-sm-4 text-right">
            <div class=" text-end mb-3">
                <a href="{{ route('editAssignment' , $assignment->id) }}" class="btn btn-outline-warning btn-sm me-2">
                    <i class="fa-solid fa-pen-to-square me-2"></i> Edit Assignment
                </a>  
            </div>
        </div>
    </div>
    <div class="row align-items-center">
        <div class="col-sm-12">
            <div class="breadcrumbs d-inline-block">
                <ul>
                    <li><a class="text-decoration-none" href="{{ route('dashboardIndex') }}">{{__('common.home')}}</a></li>
                    <li><a class="text-decoration-none" href="{{ route('allAssignments') }}">List Assignments </a></li>
                    <li>View Assignment</li>
                </ul>
            </div>
        </div>
    </div>

<div class="bg-white rounded shadow p-4">

    <h2 class="text-center"> {{ $assignment->assignment_title }}
        <span class="text-muted d-block fs-6 mt-2">{{ $assignment->assignment_note }}</span>
    </h2>


    <div class="bhoechie-tab-container container row m-0 my-4">

        <div class="col-lg-3 col-md-3 col-sm-3 col-xs-3 bhoechie-tab-menu">
            <div class="list-group">
                @foreach (json_decode($assignment->assignment_structure) as $assignments)
                <a href="#" {!! $loop->first ? 'class="list-group-item active text-center py-3"':'class="list-group-item text-center py-3"' !!}>

                    {{$assignments->name}}
                </a>

                @endforeach

            </div>
        </div>
        <div class="col-lg-9 col-md-9 col-sm-9 col-xs-9 bhoechie-tab text-center">
            <!-- flight section -->
            @foreach (json_decode($assignment->assignment_structure) as $index => $assignments)


            <div {!! $loop->first ? 'class="bhoechie-tab-content active "':'class="bhoechie-tab-content"' !!}>
                @foreach ($assignments->questions as $questionindx => $question)
                <div class="bhoechie">
                    <div id="rowAnswer" class="row px-2">
                        <h6 class="">{{ $question->question_title }} </h6>
                        <h6 id="question" class="text-muted ">{{ $question->question_note }}</h6>
                        @foreach ( $question->answers as $Answerindex=>$Answer)

                        <div class="form-check d-flex justify-content-center col-md-3">
                            <label class="form-check-label text-center">
                                <!-- {{ $loop->index}} -->
                                <input type="radio" disabled class="form-check-input d-block m-auto my-2" name="answer" id="q1" value="value">


                                @if ($Answer->answer_image !== null)
                                <img class="image-fload img-thumbnail" src='{{ asset("uploads/$Answer->answer_image") }}' alt="{{ $Answer->answer_text }}">
                                @endif

                                <p class="my-2 Qtitle bg-gradient"> {{ $Answer->answer_text}}</p>
                                <p class="my-2"> {{ $Answer->degree}}</p>
                                <p class="my-2"> {{ $Answer->answers_redirection_group_index}}</p>
                                {{-- <p class="my-2"> {{ $Answer->answers_redirection_group_question}}</p> --}}
                            </label>
                        </div>

                        @endforeach
                    </div>

                </div>
                @endforeach
            </div>



            @endforeach






        </div>

        
    </div>
    <div class="row mb-3 border-bottom text-capitalize">
        <div class="col-md-6">
            <h5>Business Location: 
                <span class="text-muted fs-6">
                    <a class="text-decoration-none" href="{{route('viewBusinessLocation' , $assignment->business_id )}}">
                        {{ $assignment->businessLocation->business_name }}
                    </a>
                </span>
            </h5>
        </div>
        <div class="col-md-6 text-end">
            <h5>Created By: 
                <span class="text-muted fs-6">
                    <a class="text-decoration-none" href="{{route('viewUser' , $assignment->created_by )}}">
                        {{ $assignment->createdPerson->full_name }}
                    </a>
                </span>
            </h5>
        </div>

    </div>
</div>



@endsection

@section('scripts')
<Script src="{{asset('js/assignment.js')}}"></Script>
@endsection