@extends('layouts.form')

@section('title')
{{__('business_location.add_business_location')}}
@endsection

@section('styles')
<link rel="stylesheet" href="{{ asset('css/color_picker.css') }}">
@endsection

@section('form-title')
{{__('business_location.add_business_location')}}
@endsection

@section('form-navigation')
<li><a class="text-decoration-none" href="{{ route('allBusinessLocations') }}">{{__('business_location.list_business_location')}}</a></li>
<li>{{__('business_location.add_business_location')}}</li>
@endsection

@section('form-tabs-li')
<li class="nav-item" role="presentation">
    <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-basic-primary" type="button" role="tab" aria-controls="pills-basic-primary" aria-selected="true">{{__('business_location.business_location_info')}}</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-owner-info-tab" data-bs-toggle="pill" data-bs-target="#pills-owner-info" type="button" role="tab" aria-controls="pills-owner-info" aria-selected="true">{{__('business_location.owner_info')}}</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-owner-address-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-owner-address-primary" type="button" role="tab" aria-controls="pills-owner-address-primary" aria-selected="false">{{__('business_location.owner_address_info')}}</button>
</li>
<li class="nav-item" role="presentation">
    <button class="nav-link" id="pills-owner-social-links-tab" data-bs-toggle="pill" data-bs-target="#pills-owner-social-links" type="button" role="tab" aria-controls="pills-owner-social-links" aria-selected="false">{{__('business_location.owner_social_links')}}</button>
</li>
@endsection

@section('form-tabs-content')
<form class="needs-validation" method="POST" action="{{ route('storeBusinessLocation') }}" enctype="multipart/form-data">
    @csrf
    <div class="tab-content" id="pills-tabContent">
        {{-- Basic Info Group --}}
        <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel" aria-labelledby="pills-basic-primary-tab">


            <div class="row">

                {{-- Business Location Name --}}
                <div class="col-md-4 mt-4">
                    <label for="business_name" class="form-label">{{__('business_location.business_location_name')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-location-crosshairs"></i>
                        </span>
                        <input type="text" class="form-control text-start text-start" id="business_name" aria-describedby="nameHelp" placeholder="{{__('business_location.enter')}} {{__('business_location.business_location_name')}} ..." name="business_name" value="{{ old('business_name') }}" required>
                    </div>
                </div>

                {{-- Email --}}
                <div class="col-md-4 mt-4">
                    <label for="email" class="form-label">{{__('business_location.email')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-envelope"></i>
                        </span>
                        <input type="text" class="form-control text-start text-start" id="email" aria-describedby="email" placeholder="{{__('business_location.enter')}} {{__('business_location.email')}} ..." name="email" value="{{ old('email') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Mobile Number --}}
                <div class="col-md-4 mt-4">
                    <label for="phone" class="form-label">{{__('business_location.phone')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="number" class="form-control text-start" id="phone" placeholder="{{__('business_location.enter')}} {{__('business_location.phone')}} . . ." name="phone" value="{{ old('phone') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Alternative Mobile Number --}}
                <div class="col-md-4 mt-4">
                    <label for="alternative_phone" class="form-label">{{__('business_location.alternative_phone')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="number" class="form-control text-start text-start" id="alternative_phone" placeholder="{{__('business_location.enter')}} {{__('business_location.alternative_phone')}} . . ." name="alternative_phone" value="{{ old('alternative_phone') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Address --}}
                <div class="col-md-4 mt-4">
                    <label for="address" class="form-label">{{__('business_location.address')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-location-arrow"></i>
                        </span>
                        <input type="text" class="form-control text-start text-start" id="address" aria-describedby="address" placeholder="{{__('business_location.enter')}} {{__('business_location.address')}} ..." name="address" value="{{ old('address') }}">
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>


                {{-- License Start Date --}}
                <div class="col-md-4 mt-4">
                    <label for="license_start_date" class="form-label">{{__('business_location.license_start_date')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-calendar-days"></i>
                        </span>
                        <input type="date" class="form-control text-start" id="license_start_date" placeholder="{{__('business_location.enter')}} {{__('business_location.license_start_date')}} . . ." name="license_start_date" value="{{ old('license_start_date') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- License End Date --}}
                <div class="col-md-4 mt-4">
                    <label for="license_end_date" class="form-label">{{__('business_location.license_end_date')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-calendar-days"></i>
                        </span>
                        <input type="date" class="form-control text-start" id="license_end_date" placeholder="{{__('business_location.enter')}} {{__('business_location.license_end_date')}} . . ." name="license_end_date" value="{{ old('license_end_date') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Max. No. Of Students --}}
                <div class="col-md-4 mt-4">
                    <label for="max_students" class="form-label">{{__('business_location.max_no_of_students')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="max_students" placeholder="{{__('business_location.enter')}} {{__('business_location.max_no_of_students')}} . . ." name="max_students" value="{{ old('max_students') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Max. No. Of Assignments --}}
                <div class="col-md-4 mt-4">
                    <label for="max_assignments" class="form-label">{{__('business_location.max_no_of_assignments')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="max_assignments" placeholder="{{__('business_location.enter')}} {{__('business_location.max_no_of_assignments')}} . . ." name="max_assignments" value="{{ old('max_assignments') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Max. No. Of Submissions --}}
                <div class="col-md-4 mt-4">
                    <label for="max_submissions" class="form-label">{{__('business_location.max_no_of_submissions')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="max_submissions" placeholder="{{__('business_location.enter')}} {{__('business_location.max_no_of_submissions')}} . . ." name="max_submissions" value="{{ old('max_submissions') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Max. No. Of Admins --}}
                <div class="col-md-4 mt-4">
                    <label for="max_admins" class="form-label">{{__('business_location.max_no_of_admins')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="max_admins" placeholder="{{__('business_location.enter')}} {{__('business_location.max_no_of_admins')}} . . ." name="max_admins" value="{{ old('max_admins') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Max. No. Of Trainers --}}
                <div class="col-md-4 mt-4">
                    <label for="max_trainers" class="form-label">{{__('business_location.max_no_of_trainers')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="max_trainers" placeholder="{{__('business_location.enter')}} {{__('business_location.max_no_of_trainers')}} . . ." name="max_trainers" value="{{ old('max_trainers') }}" required>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Is Active --}}
                <div class="col-md-4 mt-4">
                    <label for="is_active" class="form-label">{{__('business_location.status')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="is_active" name="is_active" required>
                            <option value="Active" {{ old('is_active') == 'Active' ? 'selected' : '' }}>{{__('business_location.active')}}
                            </option>
                            <option value="InActive" {{ old('is_active') == 'InActive' ? 'selected' : '' }}>{{__('business_location.in_active')}}
                            </option>
                        </select>
                        {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                    </div>
                </div>

                {{-- Upload Image --}}
                <div class="col-md-4 mt-4">
                    <label for="image_input" class="form-label filelabel">
                        <i class="fa fa-paperclip">
                        </i>
                        <span class="title">
                            {{__('business_location.upload_logo')}}
                        </span>
                        <input class="FileUpload1 form-control" id="image_input" name="image" type="file" />
                    </label>
                    {{-- <input type="file" name="image" id="image"> --}}
                    {{-- <div class="invalid-feedback">
                        Please choose a student_name.
                    </div> --}}
                </div>


                {{-- Technical Supervisor --}}
                <div class="col-md-4 mt-4">
                    <label for="Technical Supervisor" class="form-label">{{__('business_location.technical_supervisor')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <input type="text" class="form-control text-start text-start" id="technical_supervisor" aria-describedby="technical_supervisor" placeholder="{{__('business_location.enter')}} Technical Supervisor Name ..." name="technical_supervisor" value="{{ old('technical_supervisor') }}" required>
                    </div>
                </div>

                {{-- Business Location Color Picker --}}
                <div class="col-md-4 mt-4">
                    <label for="Business Location Color Picker" class="form-label">{{__('business_location.business_location_color_picker')}}</label>
                    <div class="input-group has-validation">
                        {{-- <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span> --}}
                        <input type="color" class="form-control text-start text-start" id="colorPicker" aria-describedby="theme_color" placeholder="{{__('business_location.select_business_location_color_picker')}} ..." name="theme_color" value="{{ old('theme_color') ?? "#006492" }}" required>
                    </div>
                </div>

            </div>

        </div>



        {{-- Owner Info Group --}}
        <div class="tab-pane fade show px-3" id="pills-owner-info" role="tabpanel" aria-labelledby="pills-owner-info-tab">


            <div class="row">

                {{-- Full Name --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_full_name" class="form-label">{{__('business_location.full_name')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-regular fa-user"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_full_name" aria-describedby="nameHelp" placeholder="{{__('business_location.enter')}} {{__('business_location.full_name')}} ..." name="owner_full_name" value="{{ old('owner_full_name') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Email --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_email" class="form-label">{{__('business_location.email')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-envelope"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_email" aria-describedby="email" placeholder="{{__('business_location.enter')}} {{__('business_location.email')}} ..." name="owner_email" value="{{ old('owner_email') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Is Active --}}
                <div class="col-md-2 mt-4">
                    <label for="owner_is_active" class="form-label">{{__('business_location.status')}}</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="owner_is_active" name="owner_is_active" required>
                            <option value="Active" {{ old('owner_is_active') == 'Active' ? 'selected' : '' }}>{{__('business_location.active')}}</option>
                            <option value="InActive" {{ old('owner_is_active') == 'InActive' ? 'selected' : '' }}>{{__('business_location.in_active')}}</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                <?php /*
                    {{-- Allow Login --}}
                    <div class="col-md-2 mt-4">
                        <label for="allow_login" class="form-label">Allow Login</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="allow_login" name="allow_login" required>
                                <option value="Allowable" {{ old('allow_login') == 'Allowable' ? 'selected' : '' }}>Allowable
                                </option>
                                <option value="Not Allowable" {{ old('allow_login') == 'Not Allowable' ? 'selected' : '' }}>
                                    Not Allowable</option>
                            </select>
                            {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                        </div>
                    </div>
                    */ ?>

                {{-- Mobile Number --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_phone" class="form-label">Mobile Number</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="number" class="form-control text-start" id="owner_phone" placeholder="{{__('business_location.enter')}} Owner Mobile Number . . ." name="owner_phone" value="{{ old('owner_phone') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Alternative Mobile Number --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_alternative_phone" class="form-label">Alternative Mobile Number</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="number" class="form-control text-start" id="owner_alternative_phone" placeholder="{{__('business_location.enter')}} Owner Alternative Mobile Number . . ." name="owner_alternative_phone" value="{{ old('owner_alternative_phone') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Contact Number --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_contact_number" class="form-label">Contact Number</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-mobile-screen-button"></i>
                        </span>
                        <input type="number" class="form-control text-start" id="owner_contact_number" placeholder="{{__('business_location.enter')}} Owner Contact Number . . ." name="owner_contact_number" value="{{ old('owner_contact_number') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Nationality --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_nationality" class="form-label">Nationality</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-building"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_nationality" placeholder="{{__('business_location.enter')}} Owner Nationality . . ." name="owner_nationality" value="{{ old('owner_nationality') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- National Number --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_national_number" class="form-label">National Number</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-id-card"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_national_number" placeholder="{{__('business_location.enter')}} Owner National Number . . ." name="owner_national_number" value="{{ old('owner_national_number') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>


                {{-- Date of Birth --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_dob" class="form-label">Date Of Birth</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-calendar-minus"></i>
                        </span>
                        <input type="date" class="form-control text-start" id="owner_dob" placeholder="{{__('business_location.enter')}} Owner Date of Birth . . ." name="owner_dob" value="{{ old('owner_dob') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Gender --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_gender" class="form-label">Gender</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-user-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="owner_gender" name="owner_gender" required>
                            <option value="" disabled>-- Please choose an option --</option>
                            <option value="Male" {{ old('owner_gender') == 'Male' ? 'selected' : '' }}>Male</option>
                            <option value="Female" {{ old('owner_gender') == 'Female' ? 'selected' : '' }}>Female</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Blood Group --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_blood_group" class="form-label">Blood Group</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-heart-pulse"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="owner_blood_group" name="owner_blood_group">
                            <option value="">-- Please choose an option --</option>
                            <option value="A+" {{ old('owner_blood_group') == 'A+' ? 'selected' : '' }}>A+</option>
                            <option value="A-" {{ old('owner_blood_group') == 'A-' ? 'selected' : '' }}>A-</option>
                            <option value="B+" {{ old('owner_blood_group') == 'B+' ? 'selected' : '' }}>B+</option>
                            <option value="B-" {{ old('owner_blood_group') == 'B-' ? 'selected' : '' }}>B-</option>
                            <option value="O+" {{ old('owner_blood_group') == 'O+' ? 'selected' : '' }}>O+</option>
                            <option value="O-" {{ old('owner_blood_group') == 'O-' ? 'selected' : '' }}>O-</option>
                            <option value="AB+" {{ old('owner_blood_group') == 'AB+' ? 'selected' : '' }}>AB+</option>
                            <option value="AB-" {{ old('owner_blood_group') == 'AB-' ? 'selected' : '' }}>AB-</option>
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>

                {{-- Mother Language --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_language" class="form-label">Mother Language</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-regular fa-user"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_language" placeholder="{{__('business_location.enter')}} Owner Mother Language . . ." name="owner_language" value="{{ old('owner_language') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Marital Status --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_marital_status" class="form-label">Marital Status</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-check"></i>
                        </span>
                        <select class="form-control text-start custom-select" id="owner_marital_status" name="owner_marital_status" required>
                            <option value="">-- Please choose an option --</option>
                            <option value="Single" {{ old('owner_marital_status') == 'Single' ? 'selected' : '' }}>Single
                            </option>
                            <option value="Married" {{ old('owner_marital_status') == 'Married' ? 'selected' : '' }}>Married
                            </option>
                            <option value="Divorced" {{ old('owner_marital_status') == 'Divorced' ? 'selected' : '' }}>Divorced
                            </option>
                        </select>
                        {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                    </div>
                </div>
                {{-- Upload Image --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_image_input" class="form-label filelabel">
                        <i class="fa fa-paperclip">
                        </i>
                        <span class="title">
                            Upload Image
                        </span>
                        <input class="FileUpload1 form-control" id="owner_image_input" name="owner_image" type="file" />
                    </label>
                    {{-- <input type="file" name="image" id="image"> --}}
                    {{-- <div class="invalid-feedback">
                            Please choose a student_name.
                        </div> --}}
                </div>


            </div>

            <div class="dotted-seprator mt-4 "></div>

            <div class="row">

                {{-- User Name --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_user_name" class="form-label">User Name</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-regular fa-user"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_user_name" aria-describedby="owner_user_name" placeholder="{{__('business_location.enter')}} owner User Name ..." name="owner_user_name" value="{{ old('owner_user_name') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Password --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_password" class="form-label">Password</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-lock"></i>
                        </span>
                        <input type="text" class="form-control text-start" data-password="myPass" id="owner_password" aria-describedby="owner_password" placeholder="{{__('business_location.enter')}} Owner Password ..." name="owner_password" value="{{ old('owner_password') }}" required>
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Confirm Password --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_confirm_password" class="form-label">Confirm Password</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-lock"></i>
                        </span>
                        <input type="text" class="form-control text-start" onblur="CheckPassword(this)" id="owner_confirm_password" aria-describedby="owner_confirm_password" placeholder="Re-Enter Password Again ..." name="owner_confirm_password" value="{{ old('owner_confirm_password') }}" required>
                        <div class="invalid-feedback invalid-Password">
                             confirm password "doesn't match" 
                        </div>
                    </div>
                </div>

            </div>

        </div>



        {{-- Owner Address Info --}}
        <div class="tab-pane fade show px-3" id="pills-owner-address-primary" role="tabpanel" aria-labelledby="pills-owner-address-primary-tab">

            <div class="row">

                {{-- Owner Address --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_address" class="form-label">Address</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-location-dot"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_address" aria-describedby="owner_address" placeholder="{{__('business_location.enter')}} Owner Address ..." name="owner_address" value="{{ old('owner_address') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Owner City --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_city" class="form-label">City</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-map-location"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_city" aria-describedby="owner_city" placeholder="{{__('business_location.enter')}} Owner City ..." name="owner_city" value="{{ old('owner_city') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Owner State --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_state" class="form-label">State</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-map"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_state" aria-describedby="owner_state" placeholder="{{__('business_location.enter')}} Owner State ..." name="owner_state" value="{{ old('owner_state') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Owner Country --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_country" class="form-label">Country</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-map-pin"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_country" aria-describedby="owner_country" placeholder="{{__('business_location.enter')}} Owner Country ..." name="owner_country" value="{{ old('owner_country') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Owner Landmark --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_landmark" class="form-label">Landmark</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-landmark"></i>
                        </span>
                        <input type="text" class="form-control text-start" id="owner_landmark" aria-describedby="owner_landmark" placeholder="{{__('business_location.enter')}} Owner Landmark ..." name="owner_landmark" value="{{ old('owner_landmark') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>


            </div>
        </div>



        {{-- Owner Socail Links --}}
        <div class="tab-pane fade show px-3" id="pills-owner-social-links" role="tabpanel" aria-labelledby="pills-owner-social-links-tab">

            <div class="row">

                {{-- FaceBook Link --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_fb_link" class="form-label">FaceBook Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-brands fa-facebook-f"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="owner_fb_link" placeholder="{{__('business_location.enter')}} Owner FaceBook Link ..." name="owner_fb_link" value="{{ old('owner_fb_link') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Twitter Link --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_twitter_link" class="form-label">Twitter Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-brands fa-twitter"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="owner_twitter_link" placeholder="{{__('business_location.enter')}} Owner Twitter Link ..." name="owner_twitter_link" value="{{ old('owner_twitter_link') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Social Media Link --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_social_media_1" class="form-label">Social Media Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="owner_social_media_1" placeholder="{{__('business_location.enter')}} Owner Social Media Link ..." name="owner_social_media_1" value="{{ old('owner_social_media_1') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>

                {{-- Social Media Link 2 --}}
                <div class="col-md-4 mt-4">
                    <label for="owner_social_media_2" class="form-label">Social Media Link</label>
                    <div class="input-group has-validation">
                        <span class="input-group-text" id="inputGroupPrepend">
                            <i class="fa-solid fa-hashtag"></i>
                        </span>
                        <input type="url" class="form-control text-start" id="owner_social_media_2" placeholder="{{__('business_location.enter')}} Owner Social Media Link ..." name="owner_social_media_2" value="{{ old('owner_social_media_2') }}">
                        {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                    </div>
                </div>


            </div>
        </div>

    </div>

    <div class="col-12 mt-3 text-center">
    <button class="btn btn-outline-primary py-2 px-5" id="submit" disabled type="submit">save</button>
    </div>

</form>
@endsection


@section('scripts')
<Script src="{{ asset('js/color_picker.js') }}"></Script>
@endsection