@extends('layouts.app_layout')

@section('title')
Add Business Location
@endsection

@section('content')

@include('inc.errors')

<form method="POST" action="{{ route('storeBusinessLocation') }}" enctype="multipart/form-data">
    @csrf
    <h2>Add Business Location</h2>
    <div class="form-group">
      <label for="business_name">Business Location Name</label>
      <input type="text" class="form-control" id="business_name" aria-describedby="nameHelp" placeholder="Business Location Name" name="business_name" value="{{old('business_name')}}" required>
      <small id="nameHelp" class="form-text text-muted">Please enter your first, second and last names.</small>
    </div>
    
    <div class="form-group">
      <label for="email">Email</label>
      <input type="text" class="form-control" id="email" aria-describedby="email" placeholder="email" name="email" value="{{old('email')}}" required>
    </div>
    
    <div class="form-group">
        <label for="phone">Phone</label>
        <input type="number" class="form-control" id="phone" placeholder="Phone" name="phone" value="{{old('phone')}}">
    </div>
    
    <div class="form-group">
        <label for="alternative_phone">Alternative Phone Number</label>
        <input type="number" class="form-control" id="alternative_phone" placeholder="Alternative Phone Number" name="alternative_phone" value="{{old('alternative_phone')}}">
    </div>
    
    <div class="form-group">
        <label for="address">Address</label>
        <input type="text" class="form-control" id="address" aria-describedby="address" placeholder="Address" name="address" value="{{old('address')}}" required>
    </div>
    
    <div class="form-group">
        <label for="logo">Upload Logo</label>
        <input type="file" name="logo" id="logo" >
    </div>
    
    <div class="form-group">
        <label for="owner_id">Owner Name</label>
        <select class="form-control" id="owner_id" name="owner_id" required>
            <option value="">Select Owner Name</option>
            @foreach ($users as $user)
            <option value="{{$user->id}}"  {{ old('owner_id') == $user->id ? 'selected' : '' }}>{{$user->full_name}}</option>
            @endforeach
        </select>
    </div>
    
    <div class="form-group">
        <label for="license_start_date">License Start Date</label>
        <input type="date" class="form-control" id="license_start_date" placeholder="License Start Date" name="license_start_date" value="{{old('license_start_date')}}" required>
    </div>
    
    <div class="form-group">
        <label for="license_end_date">License End Date</label>
        <input type="date" class="form-control" id="license_end_date" placeholder="License End Date" name="license_end_date" value="{{old('license_end_date')}}" required>
    </div>
    
    <div class="form-group">
        <label for="max_students">Max. No. Of Students</label>
        <input type="number" class="form-control" id="max_students" placeholder="Max. No. Of Students" name="max_students" value="{{old('max_students')}}" required>
    </div>
    
    <div class="form-group">
        <label for="max_assignments">Max. No. Of Assignments</label>
        <input type="number" class="form-control" id="max_assignments" placeholder="Max. No. Of Assignments" name="max_assignments" value="{{old('max_assignments')}}" required>
    </div>
    
    <div class="form-group">
        <label for="max_submissions">Max. No. Of Submissions</label>
        <input type="number" class="form-control" id="max_submissions" placeholder="Max. No. Of Submissions" name="max_submissions" value="{{old('max_submissions')}}" required>
    </div>    
    
    <div class="form-group ">
        <input class="form-check-input" type="hidden" name="is_active" value = 0 >
        <input class="form-check-input" type="checkbox" id="active" name="is_active" @if (old('is_active') == null) value = 1 checked @else {{(old('is_active') == 1) ? 'value = 1 checked' : ' value = 1 '}} @endif >
        <label class="form-check-label" for="active">Is Active ?</label>
    </div>


    <button type="submit" class="btn btn-outline-primary">Submit</button>
</form>

  <a href="{{ route('allBusinessLocations') }}" class="btn btn-outline-primary mt-3">Back To All Business Locations</a>


@endsection