@extends('layouts.form')

@section('title')
    Edit Business Location
@endsection

@section('form-title')
    Edit Business Location
@endsection

@section('form-navigation')
    <li><a class="text-decoration-none" href="{{ route('allBusinessLocations') }}">List Business Locations</a></li>
    <li>Edit Business Location - {{ $business_location->business_name }}</li>
@endsection

@section('form-tabs-li')
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="pills-basic-primary-tab" data-bs-toggle="pill" data-bs-target="#pills-basic-primary"
            type="button" role="tab" aria-controls="pills-basic-primary" aria-selected="true">Basic Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-owner-info-tab" data-bs-toggle="pill" data-bs-target="#pills-owner-info"
            type="button" role="tab" aria-controls="pills-owner-info" aria-selected="true">Owner Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-owner-address-primary-tab" data-bs-toggle="pill"
            data-bs-target="#pills-owner-address-primary" type="button" role="tab"
            aria-controls="pills-owner-address-primary" aria-selected="false">Owner Address Info</button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="pills-owner-social-links-tab" data-bs-toggle="pill"
            data-bs-target="#pills-owner-social-links" type="button" role="tab"
            aria-controls="pills-owner-social-links" aria-selected="false">Owner Social Links</button>
    </li>
@endsection

@section('form-tabs-content')
    <form class="needs-validation" method="POST" action="{{ route('updateBusinessLocation', $business_location->id) }}"
        enctype="multipart/form-data">
        @csrf

        <div class="tab-content" id="pills-tabContent">
            {{-- Basic Info Group --}}
            <div class="tab-pane fade show active px-3" id="pills-basic-primary" role="tabpanel"
                aria-labelledby="pills-basic-primary-tab">

                {{-- <form class="row g-3 needs-validation flex-row-reverse text-end" novalidate> --}}
                <div class="row">

                    {{-- Business Location Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="business_name" class="form-label">Business Location Name</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start text-start" id="business_name"
                                aria-describedby="nameHelp" placeholder="Enter Business Location Name ..."
                                name="business_name"
                                value="{{ old('business_name') ?? $business_location->business_name }}" required>

                        </div>
                    </div>

                    {{-- Email --}}
                    <div class="col-md-4 mt-4">
                        <label for="email" class="form-label">Email Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start text-start" id="email"
                                aria-describedby="email" placeholder="Enter Email Address ..." name="email"
                                value="{{ old('email') ?? $business_location->email }}" required>

                        </div>
                    </div>

                    {{-- Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="phone" class="form-label">Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="phone"
                                placeholder="Enter Mobile Number . . ." name="phone"
                                value="{{ old('phone') ?? $business_location->phone }}" required>

                        </div>
                    </div>

                    {{-- Alternative Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="alternative_phone" class="form-label">Alternative Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start text-start" id="alternative_phone"
                                placeholder="Enter Alternative Mobile Number . . ." name="alternative_phone"
                                value="{{ old('alternative_phone') ?? $business_location->alternative_phone }}">

                        </div>
                    </div>

                    {{-- Address --}}
                    <div class="col-md-4 mt-4">
                        <label for="address" class="form-label">Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start text-start" id="address"
                                aria-describedby="address" placeholder="Enter Address ..." name="address"
                                value="{{ old('address') ?? $business_location->address }}">

                        </div>
                    </div>

                    {{-- License Start Date --}}
                    <div class="col-md-4 mt-4">
                        <label for="license_start_date" class="form-label">License Start Date</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="license_start_date"
                                placeholder="Enter License Start Date . . ." name="license_start_date"
                                value="{{ old('license_start_date') ?? $business_location->license_start_date }}"
                                required>

                        </div>
                    </div>

                    {{-- License End Date --}}
                    <div class="col-md-4 mt-4">
                        <label for="license_end_date" class="form-label">License End Date</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="license_end_date"
                                placeholder="Enter License End Date . . ." name="license_end_date"
                                value="{{ old('license_end_date') ?? $business_location->license_end_date }}" required>

                        </div>
                    </div>

                    {{-- Max. No. Of Students --}}
                    <div class="col-md-4 mt-4">
                        <label for="max_students" class="form-label">Max. No. Of Students</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="max_students"
                                placeholder="Enter Max. No. Of Students . . ." name="max_students"
                                value="{{ old('max_students') ?? $business_location->max_students }}" required>

                        </div>
                    </div>

                    {{-- Max. No. Of Assignments --}}
                    <div class="col-md-4 mt-4">
                        <label for="max_assignments" class="form-label">Max. No. Of Assignments</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="max_assignments"
                                placeholder="Enter Max. No. Of Assignments . . ." name="max_assignments"
                                value="{{ old('max_assignments') ?? $business_location->max_assignments }}" required>

                        </div>
                    </div>

                    {{-- Max. No. Of Submissions --}}
                    <div class="col-md-4 mt-4">
                        <label for="max_submissions" class="form-label">Max. No. Of Submissions</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="max_submissions"
                                placeholder="Enter Max. No. Of Submissions . . ." name="max_submissions"
                                value="{{ old('max_submissions') ?? $business_location->max_submissions }}" required>

                        </div>
                    </div>

                    {{-- Max. No. Of Admins --}}
                    <div class="col-md-4 mt-4">
                        <label for="max_admins" class="form-label">Max. No. Of Admins</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="max_admins"
                                placeholder="Enter Max. No. Of admins . . ." name="max_admins"
                                value="{{ old('max_admins') ?? $business_location->max_admins }}" required>

                        </div>
                    </div>

                    {{-- Max. No. Of Trainers --}}
                    <div class="col-md-4 mt-4">
                        <label for="max_trainers" class="form-label">Max. No. Of Trainers</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="max_trainers"
                                placeholder="Enter Max. No. Of trainers . . ." name="max_trainers"
                                value="{{ old('max_trainers') ?? $business_location->max_trainers }}" required>

                        </div>
                    </div>

                    {{-- Is Active --}}
                    <div class="col-md-4 mt-4">
                        <label for="is_active" class="form-label">Is Active ?</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="is_active" name="is_active"
                                required>
                                <option value="Active"
                                    @if (old('is_active') == null) {{ $business_location->is_active == 'Active' ? 'selected' : '' }} @else {{ old('is_active') == 'Active' ? 'selected' : '' }} @endif>
                                    Active</option>
                                <option value="InActive"
                                    @if (old('is_active') == null) {{ $business_location->is_active == 'InActive' ? 'selected' : '' }} @else {{ old('is_active') == 'InActive' ? 'selected' : '' }} @endif>
                                    InActive</option>
                            </select>

                        </div>
                    </div>

                    {{-- Upload Image --}}
                    <div class="col-md-2 mt-4">
                        @if ($business_location->image !== null)
                            <div class="form-group">
                                <img class="image-fload" width="100%" height="100%"
                                    src='{{ asset("uploads/$business_location->image") }}'
                                    alt="{{ $business_location->business_name }}">
                            </div>
                        @else
                            <br>
                            <p class="filelabel">No Business Logo</p>
                        @endif
                    </div>
                    <div class="col-md-2 mt-4">
                        <label for="image_input" class="form-label filelabel">
                            <i class="fa fa-paperclip">
                            </i>
                            <span class="title">
                                Upload Logo
                            </span>
                            <input class="FileUpload1 form-control" id="image_input" name="image" type="file" />
                        </label>
                    </div>

                    {{-- Technical Supervisor --}}
                    <div class="col-md-4 mt-4">
                        <label for="Technical Supervisor" class="form-label">Technical Supervisor</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <input type="text" class="form-control text-start text-start" id="technical_supervisor"
                                aria-describedby="technical_supervisor" placeholder="Enter Technical Supervisor Name ..."
                                name="technical_supervisor"
                                value="{{ old('technical_supervisor') ?? $business_location->technical_supervisor }}"
                                required>
                        </div>
                    </div>

                    {{-- Business Location Color Picker --}}
                    <div class="col-md-4 mt-4">
                        <label for="Business Location Color Picker" class="form-label">Business Location Color
                            Picker</label>
                        <div class="input-group has-validation">
                            <input type="color" class="form-control text-start text-start" id="colorPicker"
                                aria-describedby="theme_color" placeholder="Select Business Location Color ..."
                                name="theme_color" value="{{ old('theme_color') ?? $business_location->theme_color }}"
                                required>
                        </div>
                    </div>


                </div>

            </div>


            {{-- Owner Info Group --}}
            <div class="tab-pane fade show px-3" id="pills-owner-info" role="tabpanel"
                aria-labelledby="pills-owner-info-tab">


                <div class="row">

                    {{-- Full Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_full_name" class="form-label">Full Name</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_full_name"
                                aria-describedby="nameHelp" placeholder="Enter Full Name ..." name="owner_full_name"
                                value="{{ old('owner_full_name') ?? $business_location->owner->full_name }}" required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Email --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_email" class="form-label">Email Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-envelope"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_email"
                                aria-describedby="email" placeholder="Enter Owner Email Address ..." name="owner_email"
                                value="{{ old('owner_email') ?? $business_location->owner->email }}" required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Is Active --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_is_active" class="form-label">Is Active ?</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="owner_is_active"
                                name="owner_is_active" required>
                                <option value="Active"
                                    @if (old('owner_is_active') == null) {{ $business_location->owner->is_active == 'Active' ? 'selected' : '' }} @else {{ old('owner_is_active') == 'Active' ? 'selected' : '' }} @endif>
                                    Active</option>
                                <option value="InActive"
                                    @if (old('owner_is_active') == null) {{ $business_location->owner->is_active == 'InActive' ? 'selected' : '' }} @else {{ old('owner_is_active') == 'InActive' ? 'selected' : '' }} @endif>
                                    InActive</option>
                            </select>

                        </div>
                    </div>

                    {{-- Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_phone" class="form-label">Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_phone"
                                placeholder="Enter Owner Mobile Number . . ." name="owner_phone"
                                value="{{ old('owner_phone') ?? $business_location->owner->phone }}" required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Alternative Mobile Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_alternative_phone" class="form-label">Alternative Mobile Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_alternative_phone"
                                placeholder="Enter Owner Alternative Mobile Number . . ." name="owner_alternative_phone"
                                value="{{ old('owner_alternative_phone') ?? $business_location->owner->alternative_phone }}"
                                required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Contact Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_contact_number" class="form-label">Contact Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-mobile-screen-button"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_contact_number"
                                placeholder="Enter Owner Contact Number . . ." name="owner_contact_number"
                                value="{{ old('owner_contact_number') ?? $business_location->owner->contact_number }}"
                                required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Nationality --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_nationality" class="form-label">Nationality</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-building"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_nationality"
                                placeholder="Enter Owner Nationality . . ." name="owner_nationality"
                                value="{{ old('owner_nationality') ?? $business_location->owner->nationality }}" required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- National Number --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_national_number" class="form-label">National Number</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-id-card"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_national_number"
                                placeholder="Enter Owner National Number . . ." name="owner_national_number"
                                value="{{ old('owner_national_number') ?? $business_location->owner->national_number }}"
                                required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>


                    {{-- Date of Birth . . . --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_dob" class="form-label">Date Of Birth</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="date" class="form-control text-start" id="owner_dob"
                                placeholder="Enter Date of Birth . . ." name="owner_dob"
                                value="{{ old('owner_dob') ?? $business_location->owner->dob }}" required>

                        </div>
                    </div>

                    {{-- Gender --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_gender" class="form-label">Gender</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="owner_gender" name="owner_gender" required>
                                <option value="" disabled>-- Please choose an option --</option>
                                <option value="Male"
                                    @if (old('owner_gender') == null) {{ $business_location->owner->gender == 'Male' ? 'selected' : '' }} @else {{ old('owner_gender') == 'Male' ? 'selected' : '' }} @endif>
                                    Male</option>
                                <option value="Female"
                                    @if (old('owner_gender') == null) {{ $business_location->owner->gender == 'Female' ? 'selected' : '' }} @else {{ old('owner_gender') == 'Female' ? 'selected' : '' }} @endif>
                                    Female</option>
                            </select>

                        </div>
                    </div>

                    {{-- Blood Group --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_blood_group" class="form-label">Blood Group</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="owner_blood_group" name="owner_blood_group">
                                <option value="">-- Please choose an option --</option>
                                <option value="A+"
                                    @if (old('owner_blood_group') == null) {{ $business_location->owner->blood_group == 'A+' ? 'selected' : '' }} @else {{ old('owner_blood_group') == 'A+' ? 'selected' : '' }} @endif>
                                    A+</option>
                                <option value="A-"
                                    @if (old('owner_blood_group') == null) {{ $business_location->owner->blood_group == 'A-' ? 'selected' : '' }} @else {{ old('owner_blood_group') == 'A-' ? 'selected' : '' }} @endif>
                                    A-</option>
                                <option value="B+"
                                    @if (old('owner_blood_group') == null) {{ $business_location->owner->blood_group == 'B+' ? 'selected' : '' }} @else {{ old('owner_blood_group') == 'B+' ? 'selected' : '' }} @endif>
                                    B+</option>
                                <option value="B-"
                                    @if (old('owner_blood_group') == null) {{ $business_location->owner->blood_group == 'B-' ? 'selected' : '' }} @else {{ old('owner_blood_group') == 'B-' ? 'selected' : '' }} @endif>
                                    B-</option>
                                <option value="O+"
                                    @if (old('owner_blood_group') == null) {{ $business_location->owner->blood_group == 'O+' ? 'selected' : '' }} @else {{ old('owner_blood_group') == 'A+' ? 'selected' : '' }} @endif>
                                    O+</option>
                                <option value="O-"
                                    @if (old('owner_blood_group') == null) {{ $business_location->owner->blood_group == 'O-' ? 'selected' : '' }} @else {{ old('owner_blood_group') == 'A-' ? 'selected' : '' }} @endif>
                                    O-</option>
                                <option value="AB+"
                                    @if (old('owner_blood_group') == null) {{ $business_location->owner->blood_group == 'AB+' ? 'selected' : '' }} @else {{ old('owner_blood_group') == 'A+' ? 'selected' : '' }} @endif>
                                    AB+</option>
                                <option value="AB-"
                                    @if (old('owner_blood_group') == null) {{ $business_location->owner->blood_group == 'AB-' ? 'selected' : '' }} @else {{ old('owner_blood_group') == 'A-' ? 'selected' : '' }} @endif>
                                    AB-</option>
                            </select>

                        </div>
                    </div>

                    {{-- Mother Language --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_language" class="form-label">Mother Language</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_language"
                                placeholder="Enter Owner Mother Language . . ." name="owner_language"
                                value="{{ old('owner_language') ?? $business_location->owner->full_name }}" required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Marital Status --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_marital_status" class="form-label">Marital Status</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-check"></i>
                            </span>
                            <select class="form-control text-start custom-select" id="owner_marital_status"
                                name="owner_marital_status" required>
                                <option value="">-- Please choose an option --</option>
                                <option value="Single"
                                    @if (old('owner_marital_status') == null) {{ $business_location->owner->marital_status == 'Single' ? 'selected' : '' }} @else {{ old('owner_marital_status') == 'Single' ? 'selected' : '' }} @endif>
                                    Single</option>
                                <option value="Married"
                                    @if (old('owner_marital_status') == null) {{ $business_location->owner->marital_status == 'Married' ? 'selected' : '' }} @else {{ old('owner_marital_status') == 'Married' ? 'selected' : '' }} @endif>
                                    Married</option>
                                <option value="Divorced"
                                    @if (old('owner_marital_status') == null) {{ $business_location->owner->marital_status == 'Divorced' ? 'selected' : '' }} @else {{ old('owner_marital_status') == 'Divorced' ? 'selected' : '' }} @endif>
                                    Divorced</option>
                            </select>

                        </div>
                    </div>


                    {{-- Upload Logo --}}
                <div class="col-md-2 mt-4">
                    @php
                            $image = $business_location->owner->image;
                        @endphp
                    @if ($business_location->owner->image !== null)
                        <div class="form-group">
                            <img class="image-fload" width="100%" height="100%"
                                src='{{ asset("uploads/$image") }}' alt="{{ $business_location->owner->full_name }}">
                        </div>
                    @else
                        <br>
                        <p class="filelabel">No User Image</p>
                    @endif
                </div>
                <div class="col-md-2 mt-4">
                    <label for="image_input" class="form-label filelabel">
                        <i class="fa fa-paperclip">
                        </i>
                        <span class="title">
                            Upload Image
                        </span>
                        <input class="FileUpload1 form-control" id="image_input" name="owner_image" type="file" />
                    </label>
                </div>


                </div>

                <div class="dotted-seprator mt-4 "></div>

                <div class="row">

                    {{-- User Name --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_user_name" class="form-label">User Name</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-regular fa-user"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_user_name"
                                aria-describedby="owner_user_name" placeholder="Enter owner User Name ..."
                                name="owner_user_name"
                                value="{{ old('owner_user_name') ?? $business_location->owner->user_name }}" required>
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Change Password --}}
                    <div class="col-md-4 mt-4">
                        <label for="user_name" class="form-label">Changing User Password</label>
                        <div class="input-group has-validation">
                            <a class="btn btn-outline-primary btn-sm me-2" data-bs-toggle="modal"
                                data-bs-target="#exampleModal">
                                <i class="fa-solid fa-plus me-2"></i> Change password
                            </a>
                        </div>
                    </div>

                </div>

            </div>



            {{-- Owner Address Info --}}
            <div class="tab-pane fade show px-3" id="pills-owner-address-primary" role="tabpanel"
                aria-labelledby="pills-owner-address-primary-tab">

                <div class="row">

                    {{-- Owner Address --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_address" class="form-label">Address</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-location-dot"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_address"
                                aria-describedby="owner_address" placeholder="Enter Owner Address ..."
                                name="owner_address"
                                value="{{ old('owner_address') ?? $business_location->owner->address }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Owner City --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_city" class="form-label">City</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map-location"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_city"
                                aria-describedby="owner_city" placeholder="Enter Owner City ..." name="owner_city"
                                value="{{ old('owner_city') ?? $business_location->owner->city }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Owner State --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_state" class="form-label">State</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_state"
                                aria-describedby="owner_state" placeholder="Enter Owner State ..." name="owner_state"
                                value="{{ old('owner_state') ?? $business_location->owner->state }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Owner Country --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_country" class="form-label">Country</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-map-pin"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_country"
                                aria-describedby="owner_country" placeholder="Enter Owner Country ..."
                                name="owner_country"
                                value="{{ old('owner_country') ?? $business_location->owner->country }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Owner Landmark --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_landmark" class="form-label">Landmark</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-landmark"></i>
                            </span>
                            <input type="text" class="form-control text-start" id="owner_landmark"
                                aria-describedby="owner_landmark" placeholder="Enter Owner Landmark ..."
                                name="owner_landmark"
                                value="{{ old('owner_landmark') ?? $business_location->owner->landmark }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>


                </div>
            </div>



            {{-- Owner Socail Links --}}
            <div class="tab-pane fade show px-3" id="pills-owner-social-links" role="tabpanel"
                aria-labelledby="pills-owner-social-links-tab">

                <div class="row">

                    {{-- FaceBook Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_fb_link" class="form-label">FaceBook Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-brands fa-facebook-f"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="owner_fb_link"
                                placeholder="Enter Owner FaceBook Link ..." name="owner_fb_link"
                                value="{{ old('owner_fb_link') ?? $business_location->owner->fb_link }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Twitter Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_twitter_link" class="form-label">Twitter Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-brands fa-twitter"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="owner_twitter_link"
                                placeholder="Enter Owner Twitter Link ..." name="owner_twitter_link"
                                value="{{ old('owner_twitter_link') ?? $business_location->owner->twitter_link }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Social Media Link --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_social_media_1" class="form-label">Social Media Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-hashtag"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="owner_social_media_1"
                                placeholder="Enter Owner Social Media Link ..." name="owner_social_media_1"
                                value="{{ old('owner_social_media_1') ?? $business_location->owner->social_media_1 }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>

                    {{-- Social Media Link 2 --}}
                    <div class="col-md-4 mt-4">
                        <label for="owner_social_media_2" class="form-label">Social Media Link</label>
                        <div class="input-group has-validation">
                            <span class="input-group-text" id="inputGroupPrepend">
                                <i class="fa-solid fa-hashtag"></i>
                            </span>
                            <input type="url" class="form-control text-start" id="owner_social_media_2"
                                placeholder="Enter Owner Social Media Link ..." name="owner_social_media_2"
                                value="{{ old('owner_social_media_2') ?? $business_location->owner->social_media_2 }}">
                            {{-- <div class="invalid-feedback">
                                Please choose a student_name.
                            </div> --}}
                        </div>
                    </div>


                </div>
            </div>


        </div>



        <div class="col-12">
            <button class="btn btn-outline-primary" type="submit">save</button>
        </div>

    </form>
@endsection




<!-- Change password Modal -->
<form method="POST" action="{{ route('updateUserPassword', $business_location->owner->id) }}">
    <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel">Changing User Password</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="owner_password">New Password</label>
                        <input type="owner_password" class="form-control" id="owner_password"
                            aria-describedby="passwordHelp" placeholder="owner_Password" name="owner_password">
                        <small id="passwordHelp" class="form-text text-muted">Be careful will writing your password
                            and
                            use complex password</small>
                    </div>

                    <div class="form-group">
                        <label for="confirm_password">Confirm New Password</label>
                        <input type="password" class="form-control" id="confirm_password"
                            aria-describedby="confirmPasswordHelp" placeholder="Password">
                        <small id="confirmPasswordHelp" class="form-text text-muted">Password not matched</small>
                    </div>




                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-outline-primary">Submit</button>
                </div>
            </div>
        </div>
    </div>
</form>
