@extends('layouts.app_layout')

@section('title')
Edit Business Location
@endsection

@section('content')

@include('inc.errors')

<form method="POST" action="{{ route('updateBusinessLocation' , $business_location->id ) }}" enctype="multipart/form-data">
    @csrf
    <h2>Edit Business Location</h2>
    <div class="form-group">
      <label for="business_name">Business Location Name</label>
      <input type="text" class="form-control" id="business_name" aria-describedby="nameHelp" placeholder="Business Location Name" name="business_name" value="{{old('business_name') ?? $business_location->business_name}}" required>
      {{-- <input type="text" class="form-control" id="full_name" aria-describedby="nameHelp" placeholder="Full Name" name="full_name" value="{{old('full_name') ?? $user->full_name}}" required> --}}
      <small id="nameHelp" class="form-text text-muted">Please enter your first, second and last names.</small>
    </div>
    
    <div class="form-group">
      <label for="email">Email</label>
      <input type="text" class="form-control" id="email" aria-describedby="email" placeholder="email" name="email" value="{{old('email') ?? $business_location->email}}" required>
    </div>
    
    <div class="form-group">
        <label for="phone">Phone</label>
        <input type="number" class="form-control" id="phone" placeholder="Phone" name="phone" value="{{old('phone') ?? $business_location->phone}}">
    </div>
    
    <div class="form-group">
        <label for="alternative_phone">Alternative Phone Number</label>
        <input type="number" class="form-control" id="alternative_phone" placeholder="Alternative Phone Number" name="alternative_phone" value="{{old('alternative_phone') ?? $business_location->alternative_phone}}">
    </div>
    
    <div class="form-group">
        <label for="address">Address</label>
        <input type="text" class="form-control" id="address" aria-describedby="address" placeholder="Address" name="address" value="{{old('address') ?? $business_location->address}}" required>
    </div>

    @if ($business_location->logo !== null)
    <div class="form-group">
        <img class="image-fload" width="100px" height="100px" src='{{ asset("uploads/$business_location->logo") }}' alt="{{$business_location->business_name}}">   
    </div>
    @endif
    
    <div class="form-group">
        <label for="logo">Upload Logo</label>
        <input type="file" name="logo" id="logo" >
    </div>
    
    <div class="form-group">
        <label for="owner_id">Owner Name</label>
        <select class="form-control" id="owner_id" name="owner_id" required>
            <option value="">Select Owner Name</option>
            @foreach ($users as $user)
            <option value="{{$user->id}}" @if (old('owner_id') == null) {{ $business_location->owner_id == $user->id ? 'selected' : '' }} @else {{ old('business_location_id') == $user->id ? 'selected' : '' }} @endif >{{$user->full_name}}</option>
            @endforeach
        </select>
    </div>
    
    <div class="form-group">
        <label for="license_start_date">License Start Date</label>
        <input type="date" class="form-control" id="license_start_date" placeholder="License Start Date" name="license_start_date" value="{{old('license_start_date') ?? $business_location->license_start_date}}" required>
    </div>
    
    <div class="form-group">
        <label for="license_end_date">License End Date</label>
        <input type="date" class="form-control" id="license_end_date" placeholder="License End Date" name="license_end_date" value="{{old('license_end_date') ?? $business_location->license_end_date}}" required>
    </div>
    
    <div class="form-group">
        <label for="max_students">Max. No. Of Students</label>
        <input type="number" class="form-control" id="max_students" placeholder="Max. No. Of Students" name="max_students" value="{{old('max_students') ?? $business_location->max_students}}" required>
    </div>
    
    <div class="form-group">
        <label for="max_assignments">Max. No. Of Assignments</label>
        <input type="number" class="form-control" id="max_assignments" placeholder="Max. No. Of Assignments" name="max_assignments" value="{{old('max_assignments') ?? $business_location->max_assignments}}" required>
    </div>
    
    <div class="form-group">
        <label for="max_submissions">Max. No. Of Submissions</label>
        <input type="number" class="form-control" id="max_submissions" placeholder="Max. No. Of Submissions" name="max_submissions" value="{{old('max_submissions') ?? $business_location->max_submissions}}" required>
    </div>    
    
    <div class="form-group ">
        <input class="form-check-input" type="hidden" name="is_active" value = 0 >
        <input class="form-check-input" type="checkbox" id="active" name="is_active" @if (old('is_active') == null && $business_location->is_active == 1)  value = 1 checked @else {{(old('is_active') == 1) ? 'value = 1 checked' : ' value = 1 '}} @endif >        <label class="form-check-label" for="active">Is Active ?</label>
    </div>


    <button type="submit" class="btn btn-outline-primary">Submit</button>
</form>

  <a href="{{ route('allBusinessLocations') }}" class="btn btn-outline-primary mt-3">Back To All Business Locations</a>


@endsection